/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.commun;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class UnzipHelper {
    private static void copyStream(InputStream in, OutputStream out, byte[] pBuffer) throws IOException {
        int len;
        while ((len = in.read(pBuffer)) >= 0) {
            out.write(pBuffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static void unzip(File pFile, File pDirectory) throws IOException {
        byte[] buffer = new byte[0x100000];
        try (ZipFile zipFile = new ZipFile(pFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            ArrayList<ZipEntry> sortedList = new ArrayList<ZipEntry>();
            while (entries.hasMoreElements()) {
                sortedList.add(entries.nextElement());
            }
            sortedList.sort(Comparator.comparing(ZipEntry::getName));
            for (ZipEntry entry : sortedList) {
                if (entry.isDirectory()) {
                    new File(pDirectory, entry.getName()).mkdirs();
                    continue;
                }
                UnzipHelper.copyStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(new File(pDirectory, entry.getName()))), buffer);
            }
        }
    }
}

