/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.commun;

import fr.dbe.util.commun.ClassLoaderPerso;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class CompilerUtils {
    public static Class compile(String pCode, File pOutputDir) throws Exception {
        File f;
        int debut = pCode.indexOf("public class");
        int fin = pCode.indexOf(" ", (debut += "public class ".length()) + 1);
        String nomClasse = pCode.substring(debut, fin);
        if (pOutputDir == null) {
            f = File.createTempFile("com,", "dir");
            f.delete();
            f = new File(f.getParentFile(), nomClasse + ".java");
        } else {
            f = new File(pOutputDir, nomClasse + ".java");
        }
        f.deleteOnExit();
        try (PrintWriter pw = new PrintWriter(f);){
            pw.print(pCode);
            pw.flush();
        }
        File[] files1 = new File[]{f};
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new Exception("Aucun compilateur trouv\u00e9 " + System.getProperty("java.home"));
        }
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> compilationUnits1 = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(files1));
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, null, null, compilationUnits1);
        task.call();
        new File(pOutputDir, nomClasse + ".class").deleteOnExit();
        StringBuilder err = new StringBuilder();
        for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
            err.append("Erreur ligne ").append(diagnostic.getLineNumber()).append(" colonne ").append(diagnostic.getColumnNumber()).append(" : ").append(diagnostic.getMessage(null)).append("\n");
        }
        if (err.length() == 0) {
            assert (pOutputDir != null);
            return ClassLoaderPerso.getInstance().findClass(nomClasse, pOutputDir.getAbsolutePath());
        }
        throw new Exception(err.toString());
    }
}

