/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.commun;

public class Bornes {
    private final double fMin;
    private final double fMax;

    public Bornes(double pMin, double pMax) {
        this.fMin = pMin;
        this.fMax = pMax;
    }

    public double getMin() {
        return this.fMin;
    }

    public double getMax() {
        return this.fMax;
    }

    public String toString() {
        return "Bornes [fMin=" + this.fMin + ", fMax=" + this.fMax + "]";
    }

    public boolean isEmpty() {
        return this.fMax - this.fMin < 0.0;
    }

    public int hashCode() {
        double prime = 31.0;
        double result = 1.0;
        result = 31.0 * result + this.fMax;
        result = 31.0 * result + this.fMin;
        return (int)result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bornes other = (Bornes)obj;
        if (this.fMax != other.fMax) {
            return false;
        }
        return this.fMin == other.fMin;
    }

    public Bornes union(Bornes pBornes) {
        return new Bornes(Math.min(this.fMin, pBornes.fMin), Math.max(this.fMax, pBornes.fMax));
    }

    public Bornes intersection(Bornes pBornes) {
        return new Bornes(Math.max(this.fMin, pBornes.fMin), Math.min(this.fMax, pBornes.fMax));
    }
}

