/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique.pixeltransformer;

import fr.dbe.graphique.ScaleFunction;
import fr.dbe.graphique.pixeltransformer.PixelTransformer;

public class IndirectHPixelTransformer
extends PixelTransformer {
    public IndirectHPixelTransformer(double pMin, double pMax, double pMargeGaucheAxe, double pMargeDroiteAxe, double pWidth, double pTranslation, double pZoom, ScaleFunction pScaleFunction) {
        super(pMin, pMax, pMargeGaucheAxe, pMargeDroiteAxe, pWidth, pTranslation, pZoom, pScaleFunction);
    }

    @Override
    protected double estimeDpix() {
        if (this.scaleFunction == null) {
            return (this.zoom * this.width - this.margeGaucheAxe - this.margeDroiteAxe) / (this.max - this.min);
        }
        return (this.zoom * this.width - this.margeGaucheAxe - this.margeDroiteAxe) / (this.scaleFunction.transform(this.max) - this.scaleFunction.transform(this.min));
    }

    @Override
    public double val2Pix(double pX) {
        if (!Double.isFinite(pX)) {
            return Double.NaN;
        }
        if (this.scaleFunction == null) {
            return (this.max - pX) * this.dPix + this.translation + this.margeGaucheAxe;
        }
        return (this.scaleFunction.transform(this.max) - this.scaleFunction.transform(pX)) * this.dPix + this.translation + this.margeGaucheAxe;
    }

    @Override
    public double pix2Val(double pX) {
        if (this.scaleFunction == null) {
            return this.max - (pX - this.translation - this.margeGaucheAxe) / this.dPix;
        }
        return this.scaleFunction.revert(this.scaleFunction.transform(this.max) - (pX - this.translation - this.margeGaucheAxe) / this.dPix);
    }
}

