/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.AxeH;
import fr.dbe.graphique.Positionnable;
import fr.dbe.graphique.Repartition;
import fr.dbe.util.commun.Vecteur;
import java.util.Arrays;

public class PositionComputer {
    public static double[] compute(Positionnable pPositionnable, Axe pAxe, double pPositionAxe, double[] pPositions) {
        double[] res;
        double m;
        double M;
        double minVal = pAxe.getMin();
        double maxVal = pAxe.getMax();
        if (pAxe instanceof AxeH) {
            M = pAxe.pixToVal((int)pAxe.getRepere().getDrawingRectangle().getMaxX());
            m = pAxe.pixToVal((int)pAxe.getRepere().getDrawingRectangle().getMinX());
        } else {
            M = pAxe.pixToVal((int)pAxe.getRepere().getDrawingRectangle().getMaxY());
            m = pAxe.pixToVal((int)pAxe.getRepere().getDrawingRectangle().getMinY());
        }
        double tmp = M;
        M = Math.max(m, M);
        m = Math.min(m, tmp);
        if (pPositionnable.getRepartition() == Repartition.POSITIONS) {
            Vecteur v = new Vecteur(pPositions.length, 1);
            for (double d : pPositions) {
                if (!(d >= m) || !(d <= M)) continue;
                v.ajouter(d);
            }
            double[] res2 = v.toArray();
            Arrays.sort(res2);
            return res2;
        }
        if (pAxe.fPixelTransformer.getScaleFunction() != null) {
            Axe autreAxe;
            Axe axe = autreAxe = pAxe.getRepere().getAxeH() == pAxe ? pAxe.getRepere().getAxeV() : pAxe.getRepere().getAxeH();
            if (pPositionnable.getRepartition() == Repartition.INTERVALLE) {
                return pAxe.fPixelTransformer.getScaleFunction().valeursQuadrillageIntervalle(autreAxe.getMin(), autreAxe.getMax(), pAxe, pPositionAxe, pPositionnable.getIntervalle());
            }
            if (pPositionnable.getRepartition() == Repartition.NOMBRE) {
                return pAxe.fPixelTransformer.getScaleFunction().valeursQuadrillageNombre(autreAxe.getMin(), autreAxe.getMax(), pAxe, pPositionAxe, pPositionnable.getNombre());
            }
        }
        double dVal = 0.0;
        if (pPositionnable.getRepartition() == Repartition.INTERVALLE) {
            dVal = Math.min(pPositionnable.getIntervalle(), M - m);
        } else if (pPositionnable.getRepartition() == Repartition.NOMBRE && pPositionnable.getNombre() > 0) {
            dVal = pPositionnable.computeIntervalle(pAxe);
        }
        if (pPositionnable.getMinSpaceVerifier() != null) {
            dVal = pPositionnable.getMinSpaceVerifier().space(pPositionnable.getIntervalle(), pAxe);
        }
        if (dVal > 0.0) {
            double min;
            double x;
            double nb;
            double minValRounded;
            double d = Math.abs(M - m);
            if (d > 100.0 && pPositionnable.isValeursRondes()) {
                m = Math.pow(10.0, (int)Math.log10(m));
                double l = Math.log10(dVal);
                dVal = (double)((int)Math.pow(10.0, l - (double)((int)l))) * Math.pow(10.0, (int)l);
            }
            if (dVal != M - m) {
                double mm = m - m % dVal;
                if (mm < m) {
                    mm += dVal;
                }
                m = mm;
                double MM = M - M % dVal;
                if (MM > M) {
                    MM -= dVal;
                }
                M = MM;
            }
            Vecteur v = new Vecteur(100, 100);
            if (minVal > 0.0) {
                double l = Math.pow(10.0, (int)Math.log10(minVal));
                minValRounded = Math.ceil(minVal / l) * l;
            } else {
                minValRounded = minVal;
            }
            if (d > 100.0 && pPositionnable.isValeursRondes()) {
                double debut = Math.max(m, pPositionAxe + dVal);
                nb = M - (debut = Math.max(minValRounded, Math.pow(10.0, (int)Math.log10(debut)))) / dVal;
                if (nb > 500.0) {
                    v.ajouter(debut);
                    v.ajouter(M);
                } else {
                    for (x = debut; x <= M; x += dVal) {
                        v.ajouter(x);
                    }
                }
            } else {
                if (pPositionnable.getRepartition() == Repartition.NOMBRE || pPositionAxe >= m && pPositionAxe <= M) {
                    v.ajouter(pPositionAxe);
                }
                if ((nb = M - (min = Math.max(m, pPositionAxe + dVal)) / dVal) > 500.0) {
                    v.ajouter(min);
                    v.ajouter(M);
                } else {
                    for (x = min; x <= M; x += dVal) {
                        v.ajouter(x);
                    }
                }
            }
            min = Math.max(minValRounded, m);
            double max = Math.min(pPositionAxe - dVal, M);
            double nb2 = max - min / dVal;
            if (nb2 > 500.0) {
                v.ajouter(min);
                v.ajouter(max);
            } else {
                for (double x2 = max; x2 >= min; x2 -= dVal) {
                    v.ajouter(x2);
                }
            }
            if (pPositionnable.isIntValues()) {
                for (int i = 0; i < v.size(); ++i) {
                    double c;
                    double f;
                    double round = Math.round(v.get(i));
                    if (v.get(i) == round) continue;
                    if (round >= minVal && round <= maxVal) {
                        v.set(i, round);
                    }
                    if ((f = Math.floor(v.get(i))) >= minVal && f <= maxVal) {
                        v.ajouter(f);
                    }
                    if (!((c = Math.ceil(v.get(i))) >= minVal) || !(c <= maxVal)) continue;
                    v.ajouter(c);
                }
            }
            if (v.size() == 1) {
                v.clear();
            }
            res = v.toArray();
            Arrays.sort(res);
        } else {
            res = new double[]{};
        }
        if (res.length <= 2 && pPositionnable.getRepartition() == Repartition.INTERVALLE) {
            double intervalle = pPositionnable.getIntervalle();
            pPositionnable.setNombre(4);
            res = PositionComputer.compute(pPositionnable, pAxe, pPositionAxe, null);
            pPositionnable.setIntervalle(intervalle);
        }
        return res;
    }
}

