/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Messages;
import fr.dbe.graphique.Repere;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;

public abstract class PointGraphique
extends Point2D.Double {
    protected Color fCouleur = Color.black;

    public PointGraphique(double pX, double pY) {
        super(pX, pY);
    }

    private static Object valeurChaine(double pValeur) {
        if (Double.isNaN(pValeur)) {
            return "NaN";
        }
        if (Double.isInfinite(pValeur)) {
            return "\u221e";
        }
        if (pValeur == 0.0) {
            return "0";
        }
        if (Math.abs(pValeur) > Math.pow(10.0, 4.0) || Math.abs(pValeur) < Math.pow(10.0, -4.0)) {
            return new DecimalFormat("#.###E0").format(pValeur);
        }
        return new DecimalFormat("#.####").format(pValeur);
    }

    @Override
    public String toString() {
        return Messages.getString("PointGraphique.0") + (int)this.x + ", y=" + this.toStringY();
    }

    public String toStringY() {
        return PointGraphique.valeurChaine(this.y).toString();
    }

    public String toStringX() {
        return String.valueOf(this.x);
    }

    public Color getCouleur() {
        return this.fCouleur;
    }

    public void setCouleur(Color c) {
        this.fCouleur = c;
    }

    public abstract void dessine(Graphics var1, Repere var2);

    public abstract int getDiametre();

    public abstract void setDiametre(int var1);

    public abstract void dessineLegende(Graphics2D var1, int var2, int var3, int var4, int var5);
}

