/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.IWidget;
import fr.dbe.graphique.JDessinGraphique;
import fr.dbe.graphique.JProprietesGraphique;
import fr.dbe.graphique.LegendeRow;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.Messages;
import fr.dbe.graphique.Serie;
import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.HorizontalLabelPosition;
import fr.dbe.util.ihm.SharedFrame;
import fr.dbe.util.ihm.Utils;
import fr.dbe.util.ihm.VerticalLabelPosition;
import fr.dbe.util.log.Log;
import fr.dbe.util.xml.XmlUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LegendeWidget
extends MouseInputAdapter
implements IWidget {
    private static final String DOM_VISIBLE = "visible";
    private static final String DOM_X = "x";
    private static final String DOM_Y = "y";
    private static final String DOM_CADRE = "cadre";
    private static final String DOM_TRANSPARENCE = "transparence";
    private final Rectangle fRectangle;
    private final JDessinGraphique fDessin;
    private final List<LegendeRow> fRows = new ArrayList<LegendeRow>();
    protected int fDxGauche = -5;
    protected int fPosY = 15;
    private Font fFont = Utilitaire.FONT_DEFAUT;
    private boolean fVisible = false;
    private boolean fSelected = false;
    private boolean fCadre = true;
    private Color fCouleurCadre = Color.DARK_GRAY;
    private Color fCouleurFond = Color.WHITE;
    private float fTransparence = 0.6f;
    private Color fCouleurTexte = Color.DARK_GRAY;
    private boolean fCtrlDown;

    public LegendeWidget(JDessinGraphique pDessin) {
        this.fDessin = pDessin;
        this.fRectangle = new Rectangle();
    }

    public void setDxGauche(int pDxGauche) {
        this.fDxGauche = pDxGauche;
    }

    public Font getFont() {
        return this.fFont;
    }

    public void setFont(Font pFont) {
        this.fFont = pFont;
    }

    @Override
    public boolean isVisible() {
        return this.fVisible;
    }

    @Override
    public void setVisible(boolean pVisible) {
        this.fVisible = pVisible;
    }

    @Override
    public void dessine(Graphics pGraphics) {
        this.deplace(0.0, 0.0);
        this.fRows.clear();
        Graphics2D g = (Graphics2D)pGraphics;
        if (this.fVisible) {
            Rectangle r;
            Font oldFont = g.getFont();
            g.setFont(this.fFont);
            g.setComposite(AlphaComposite.getInstance(3, this.fTransparence));
            g.setColor(this.fCouleurFond);
            g.fillRect(this.fRectangle.x, this.fRectangle.y, this.fRectangle.width, this.fRectangle.height);
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
            Rectangle rLegende = null;
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(5.0f));
            int y = this.fPosY;
            int padding = 1;
            g.setFont(new Font(this.fFont.getFontName(), 1, this.fFont.getSize()));
            for (Serie serie : this.fDessin.getSeriesActives()) {
                if (!serie.isVisibleInMenu()) continue;
                g.setColor(this.fCouleurTexte);
                r = Utils.libelleHtmlBounds(g, 0, y, serie.getNom(), HorizontalLabelPosition.LEFT, VerticalLabelPosition.TOP);
                rLegende = rLegende == null ? r : rLegende.createUnion(r).getBounds();
                y += r.height + padding;
            }
            g.setFont(this.fFont);
            if (rLegende == null) {
                return;
            }
            rLegende.width += 20;
            rLegende.x = (int)((double)this.getDessin().getWidth() - rLegende.getWidth() - 20.0) - this.fDxGauche;
            y = this.fPosY;
            for (Serie s : this.fDessin.getSeriesActives()) {
                if (!s.isVisibleInMenu()) continue;
                Color color = s.isVisible() && s.isHighlighted() ? Color.BLUE : (s.isVisible() ? this.fCouleurTexte : this.fCouleurTexte.brighter().brighter().brighter());
                g.setColor(color);
                if (s.isHighlighted()) {
                    g.setFont(new Font(this.fFont.getFontName(), 1, this.fFont.getSize()));
                } else {
                    g.setFont(this.fFont);
                }
                r = Utils.drawLibelleHtml(g, rLegende.x + 20, y, s.getNomLegende(), HorizontalLabelPosition.LEFT, VerticalLabelPosition.TOP, null);
                int x = (int)((double)(this.getDessin().getWidth() - this.fDxGauche) - rLegende.getWidth() - 15.0);
                s.dessineLegende(g, x, y, 10, 10);
                Rectangle rr = new Rectangle(r.x - 20, r.y, r.width + 15, r.height);
                this.fRows.add(new LegendeRow(rr, s));
                if (s.isHighlighted()) {
                    g.setColor(Color.LIGHT_GRAY);
                    g.setStroke(new BasicStroke(1.0f));
                    g.drawRoundRect(rr.x - 2, rr.y - 2, rr.width + 4, rr.height + 4, 5, 5);
                }
                y += r.height + padding;
            }
            int n = 5;
            rLegende.x -= n;
            rLegende.y -= n;
            rLegende.width += 2 * n;
            rLegende.height += 2 * n;
            this.getRectangle().setRect(rLegende);
            if (this.fCadre) {
                g.setStroke(new BasicStroke(1.0f));
                g.setColor(this.fCouleurCadre);
                g.drawRoundRect(this.fRectangle.x, this.fRectangle.y, this.fRectangle.width, this.fRectangle.height, 10, 10);
            }
            if (this.fSelected) {
                g.setColor(Color.DARK_GRAY.brighter());
                g.fillRoundRect(this.fRectangle.x - 3, this.fRectangle.y - 3, 6, 6, 2, 2);
                g.fillRoundRect(this.fRectangle.x - 3, this.fRectangle.y + this.fRectangle.height - 3, 6, 6, 2, 2);
                g.fillRoundRect(this.fRectangle.x + this.fRectangle.width - 3, this.fRectangle.y - 3, 6, 6, 2, 2);
                g.fillRoundRect(this.fRectangle.x + this.fRectangle.width - 3, this.fRectangle.y + this.fRectangle.height - 3, 6, 6, 2, 2);
            }
            g.setFont(oldFont);
            g.setStroke(oldStroke);
        }
    }

    @Override
    public boolean contains(Point pPoint) {
        return this.containsFast(pPoint);
    }

    @Override
    public boolean containsFast(Point pPoint) {
        return this.fRectangle.contains(pPoint);
    }

    @Override
    public boolean isSelected() {
        return this.fSelected;
    }

    @Override
    public void setSelected(boolean pSelected) {
        this.fSelected = pSelected;
    }

    @Override
    public Dimension deplace(double pDx, double pDy) {
        int dx = this.fDxGauche;
        int dy = this.fPosY;
        Rectangle rDessin = this.fDessin.getBounds();
        if ((double)(this.fRectangle.x + this.fRectangle.width) + pDx > rDessin.getWidth()) {
            pDx = rDessin.getWidth() - (double)(this.fRectangle.x + this.fRectangle.width);
        }
        if ((double)this.fRectangle.x + pDx < 0.0) {
            pDx = -this.fRectangle.x;
        }
        if ((double)(this.fRectangle.y + this.fRectangle.height) + pDy > rDessin.getHeight()) {
            pDy = rDessin.getHeight() - (double)(this.fRectangle.y + this.fRectangle.height);
        }
        if ((double)this.fRectangle.y + pDy < 0.0) {
            pDy = -this.fRectangle.y;
        }
        this.fDxGauche = (int)((double)this.fDxGauche - pDx);
        this.fPosY = (int)((double)this.fPosY + pDy);
        return new Dimension(dx - this.fDxGauche, -(dy - this.fPosY));
    }

    @Override
    public Element getDomElement(Document doc) {
        Element elt = doc.createElement(MapXmlGraph.getInstance().getNomElement(this));
        elt.setAttribute(DOM_VISIBLE, String.valueOf(this.fVisible));
        elt.setAttribute(DOM_X, String.valueOf(this.fDxGauche));
        elt.setAttribute(DOM_Y, String.valueOf(this.fPosY));
        elt.setAttribute(DOM_TRANSPARENCE, String.valueOf(this.fTransparence));
        Element cadre = doc.createElement(DOM_CADRE);
        cadre.appendChild(XmlUtils.createColorNode(doc, this.fCouleurCadre));
        cadre.setAttribute(DOM_VISIBLE, String.valueOf(this.fCadre));
        elt.appendChild(cadre);
        elt.appendChild(XmlUtils.createColorNode(doc, this.fCouleurTexte));
        elt.appendChild(XmlUtils.createPoliceNode(doc, this.fFont));
        return elt;
    }

    @Override
    public void setProperties(Node pNoeud) {
        this.setVisible(XmlUtils.getAttributeBooleanValue(pNoeud, DOM_VISIBLE, true));
        this.fDxGauche = XmlUtils.getAttributeIntValue(pNoeud, DOM_X, 30);
        this.fPosY = XmlUtils.getAttributeIntValue(pNoeud, DOM_Y, 10);
        this.setTransparence((float)XmlUtils.getAttributeDoubleValue(pNoeud, DOM_TRANSPARENCE, 0.0));
        this.setCouleurTexte(XmlUtils.getColor(pNoeud));
        this.setFont(XmlUtils.getPolice(pNoeud));
        Node nCadre = XmlUtils.getFils(pNoeud, DOM_CADRE);
        if (nCadre != null) {
            this.fCadre = XmlUtils.getAttributeBooleanValue(nCadre, DOM_VISIBLE, true);
            this.setCouleurCadre(XmlUtils.getColor(nCadre));
        } else {
            Log.getInstance().warn(Messages.getString("LegendeWidget.5") + DOM_CADRE + Messages.getString("LegendeWidget.6"));
        }
    }

    public boolean isCadre() {
        return this.fCadre;
    }

    public void setCadre(boolean pCadre) {
        this.fCadre = pCadre;
    }

    public Color getCouleurCadre() {
        return this.fCouleurCadre;
    }

    public void setCouleurCadre(Color pCouleurCadre) {
        this.fCouleurCadre = pCouleurCadre;
    }

    public Color getCouleurTexte() {
        return this.fCouleurTexte;
    }

    public void setCouleurTexte(Color pCouleurTexte) {
        this.fCouleurTexte = pCouleurTexte;
    }

    public Rectangle getRectangle() {
        return this.fRectangle;
    }

    public Color getCouleurFond() {
        return this.fCouleurFond;
    }

    public void setCouleurFond(Color pCouleurFond) {
        this.fCouleurFond = pCouleurFond;
    }

    public float getTransparence() {
        return this.fTransparence;
    }

    public void setTransparence(float pTransparence) {
        this.fTransparence = pTransparence;
    }

    public JDessinGraphique getDessin() {
        return this.fDessin;
    }

    @Override
    public void setDebutDrag(Point pPoint) {
    }

    public void setPosY(int pPosY) {
        this.fPosY = pPosY;
    }

    @Override
    public void mouseMoved(MouseEvent pE) {
        for (LegendeRow row : this.fRows) {
            if (pE.isControlDown()) {
                this.fCtrlDown = true;
                row.getSerie().setVisible(false);
                row.getSerie().setHighlighted(false);
                if (!row.getBounds().contains(pE.getPoint())) continue;
                if (!row.getSerie().isHighlighted()) {
                    row.getSerie().setHighlighted(true);
                }
                if (row.getSerie().isVisible()) continue;
                row.getSerie().setVisible(true);
                continue;
            }
            if (pE.isShiftDown()) {
                this.fCtrlDown = true;
                row.getSerie().setVisible(true);
                row.getSerie().setHighlighted(false);
                continue;
            }
            boolean highlighted = row.getBounds().contains(pE.getPoint());
            if (row.getSerie().isHighlighted() == highlighted) continue;
            row.getSerie().setHighlighted(highlighted);
        }
        this.getDessin().repaint();
    }

    @Override
    public void mouseExited(MouseEvent pE) {
        for (LegendeRow row : this.fRows) {
            if (!row.getSerie().isHighlighted()) continue;
            row.getSerie().setHighlighted(false);
            row.getSerie().getRepere().getDessin().repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent pE) {
        for (LegendeRow row : this.fRows) {
            if (!row.getBounds().contains(pE.getPoint())) continue;
            if (pE.getClickCount() == 1) {
                row.getSerie().setVisible(!row.getSerie().isVisible());
                row.getSerie().setHighlighted(true);
                row.getSerie().getRepere().getDessin().repaint();
                continue;
            }
            SharedFrame f = new SharedFrame();
            SwingUtilities.invokeLater(() -> {
                JProprietesGraphique d = new JProprietesGraphique((Component)f, this.fDessin);
                d.selectAffichage();
                d.setLocationRelativeTo(pE.getComponent());
                d.setVisible(true);
                f.dispose();
                pE.getComponent().repaint();
            });
        }
    }

    @Override
    public boolean isDeplacable() {
        return true;
    }

    public int getDxGauche() {
        return this.fDxGauche;
    }
}

