/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.BoxFonds;
import fr.dbe.graphique.BoxGeneral;
import fr.dbe.graphique.BoxLegende;
import fr.dbe.graphique.BoxRepere;
import fr.dbe.graphique.BoxSeries;
import fr.dbe.graphique.JDessinGraphique;
import fr.dbe.graphique.Messages;
import fr.dbe.graphique.Repere;
import fr.dbe.graphique.Serie;
import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.JAssistant;
import fr.dbe.util.ihm.Utils;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

class JProprietesGraphique
extends JAssistant {
    public static final int TAILLE_LIBELLE = 70;
    public static final int TAILLE_SAISIE = 150;
    private final JDessinGraphique fDessin;
    private JTextField fSleTitle;
    private JTabbedPane fJTabbedPane;
    private BoxSeries fBoxSeries;

    public JProprietesGraphique(Component parent, JDessinGraphique pDessin) {
        super(Utils.getParentFrame(parent), Messages.getString("JProprietesGraphique.0"), true);
        this.fDessin = pDessin;
        this.init();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    @Override
    public void doAnnuler() {
        this.setVisible(false);
        this.fDessin.firePropertiesChanged();
        this.dispose();
    }

    @Override
    protected void majBtOk() {
        this.validateBoxes();
        if (this.isOk()) {
            this.info(Messages.getString("JProprietesGraphique.1"));
        }
    }

    @Override
    protected void doOk() {
        this.fDessin.setTitle(this.fSleTitle.getText());
        this.doOkBoxes();
        this.fDessin.firePropertiesChanged();
        this.setVisible(false);
        this.dispose();
    }

    @Override
    protected void doAppliquer() {
        this.fDessin.setTitle(this.fSleTitle.getText());
        this.doOkBoxes();
        this.info(Messages.getString("JProprietesGraphique.2"));
        this.fDessin.firePropertiesChanged();
        this.fDessin.repaint();
    }

    @Override
    protected Box getBox() {
        Box res = Box.createVerticalBox();
        this.fJTabbedPane = new JTabbedPane();
        int i = 1;
        ArrayList<BoxRepere> list = new ArrayList<BoxRepere>();
        for (Repere r : this.fDessin.getReperes()) {
            Box box = Box.createHorizontalBox();
            BoxRepere br = new BoxRepere((JAssistant)this, r);
            list.add(br);
            box.add(br);
            box.add(Box.createHorizontalGlue());
            this.fJTabbedPane.add(Messages.getString("JProprietesGraphique.3") + i++, box);
        }
        BoxGeneral bGeneral = new BoxGeneral(this, this.fDessin, list);
        TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("JProprietesGraphique.4"));
        b.setTitleFont(Utilitaire.FONT_DEFAUT);
        bGeneral.setBorder(b);
        this.fSleTitle = Utils.createTextFieldSel(this.fDessin.getTitle(), 500);
        BoxLegende bLegende = new BoxLegende((JAssistant)this, this.fDessin.getLegende());
        b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("JProprietesGraphique.5"));
        b.setTitleFont(Utilitaire.FONT_DEFAUT);
        bLegende.setBorder(b);
        BoxLegende bTitre = new BoxLegende((JAssistant)this, this.fDessin.getTitre());
        b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("JProprietesGraphique.6"));
        b.setTitleFont(Utilitaire.FONT_DEFAUT);
        bTitre.setBorder(b);
        Box bOnglets = Utils.createHorizontalBox(10, bGeneral, bLegende, bTitre);
        Box bTitle = Utils.createHorizontalBox(10, Utils.createLabel(Messages.getString("JProprietesGraphique.6") + " :"), this.fSleTitle);
        Box bTot = Utils.createVerticalBox(10, bTitle, bOnglets);
        this.fJTabbedPane.add(Messages.getString("JProprietesGraphique.7"), bTot);
        Component[] componentArray = new Component[2];
        this.fBoxSeries = new BoxSeries((JAssistant)this, this.fDessin);
        componentArray[0] = this.fBoxSeries;
        componentArray[1] = new BoxFonds((JAssistant)this, this.fDessin);
        this.fJTabbedPane.add(Messages.getString("JProprietesGraphique.8"), Utils.createVerticalBox(10, componentArray));
        res.add(this.fJTabbedPane);
        return res;
    }

    public void selectAffichage() {
        this.fJTabbedPane.setSelectedIndex(this.fDessin.getReperes().size());
    }

    public void selectRepere(Repere pRepere) {
        this.fJTabbedPane.setSelectedIndex(this.fDessin.getReperes().indexOf(pRepere));
    }

    public void selectSerie(Serie pSerie) {
        this.fJTabbedPane.setSelectedIndex(this.fDessin.getReperes().size() + 1);
        this.fBoxSeries.selectSerie(pSerie);
    }
}

