/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.Courbe;
import fr.dbe.graphique.HistoSuperpose;
import fr.dbe.graphique.ITypeDessin;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.PositionBarreHistogramme;
import fr.dbe.graphique.Sens;
import fr.dbe.graphique.Serie;
import fr.dbe.util.commun.Plage;
import fr.dbe.util.xml.XmlUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HistogrammeSuperpose
implements ITypeDessin {
    private final PositionBarreHistogramme fPositionBarre;
    private Color fFillColor;
    private Stroke fStroke = new BasicStroke(1.0f);

    public HistogrammeSuperpose(PositionBarreHistogramme pPositionBarre) {
        this.fPositionBarre = pPositionBarre;
    }

    @Override
    public Color getFillColor() {
        return this.fFillColor;
    }

    @Override
    public void setFillColor(Color pFillColor) {
        this.fFillColor = pFillColor;
    }

    @Override
    public boolean hasFillColor() {
        return true;
    }

    @Override
    public Stroke getStroke() {
        return this.fStroke;
    }

    @Override
    public void setStroke(Stroke pStroke) {
        this.fStroke = pStroke == null ? new BasicStroke(1.0f) : pStroke;
    }

    @Override
    public void dessine(Serie pCourbe, Graphics pG, double pXMin, double pXMax, int pPasAffichage) {
        if (pCourbe.size() < 1) {
            return;
        }
        List<Courbe> courbes = ((HistoSuperpose)pCourbe).getCourbes();
        for (Courbe c : courbes) {
            if (c.getTypeDessin().getFillColor() != null) continue;
            c.getTypeDessin().setFillColor(new Color(c.getCouleur().getRed(), c.getCouleur().getGreen(), c.getCouleur().getBlue(), 10));
        }
        Courbe c0 = courbes.get(0);
        int i = Math.max(0, (int)((pXMin - c0.getXMin()) / c0.getDx()));
        if (i >= c0.size()) {
            return;
        }
        Axe axeH = pCourbe.getRepere().getAxeH();
        Axe axeV = pCourbe.getRepere().getAxeV();
        int i0 = Math.max(0, (int)((pXMin - c0.getXMin()) / c0.getDx()) - 1);
        int i1 = Math.min(c0.size(), (int)((pXMax - c0.getXMin()) / c0.getDx()) + 2);
        if (pCourbe.getConfigPlage() != null) {
            Plage p = pCourbe.getConfigPlage().getPlage();
            i0 = Math.max(i0, p.getIndiceMin());
            i1 = Math.min(i1, p.getIndiceMax());
        }
        if (i0 >= i1) {
            return;
        }
        double x0 = axeH.valToPix(c0.getX(i0 + this.getDXMinAff()));
        double y0 = axeV.valToPix(i0);
        Stroke oldStroke = ((Graphics2D)pG).getStroke();
        ((Graphics2D)pG).setStroke(this.fStroke);
        for (int j = i0 + pPasAffichage + this.getDXMinAff(); j < i1 + this.getDXMaxAff(); j += pPasAffichage) {
            int yPdt = (int)y0;
            double x = axeH.valToPix(c0.getX(j));
            for (Courbe cc : courbes) {
                int yR;
                int h;
                double y;
                if (!cc.isVisible() || !Double.isFinite(y = axeV.valToPix(cc.getY(this.fPositionBarre == PositionBarreHistogramme.GAUCHE ? j : j - 1))) || !Double.isFinite(y0)) continue;
                int w = Math.abs((int)(x - x0));
                int xR = (int)Math.min(x0, x);
                if (axeV.getSens() == Sens.INDIRECT) {
                    h = (int)(y - y0);
                    yR = yPdt;
                    yPdt = yR + h;
                } else {
                    h = (int)(y0 - y);
                    yPdt = yR = yPdt - h;
                }
                pG.setColor(cc.getTypeDessin().getFillColor());
                pG.fillRect(xR, yR, w, h);
                pG.setColor(cc.getCouleur());
                pG.drawRect(xR, yR, w, h);
            }
            x0 = x;
        }
        ((Graphics2D)pG).setStroke(oldStroke);
    }

    @Override
    public Element getDomElement(Document pDoc) {
        Element root = pDoc.createElement(MapXmlGraph.getInstance().getNomElement(ITypeDessin.class));
        root.appendChild(XmlUtils.createStrokeNode(pDoc, (BasicStroke)this.fStroke));
        root.appendChild(XmlUtils.createColorNode(pDoc, this.fFillColor));
        return root;
    }

    @Override
    public void setProperties(Node pNoeud) {
        this.setStroke(XmlUtils.getStroke(pNoeud));
        this.setFillColor(XmlUtils.getColor(pNoeud));
    }

    @Override
    public int getDXMinAff() {
        return this.fPositionBarre == PositionBarreHistogramme.DROITE ? 0 : -1;
    }

    @Override
    public int getDXMaxAff() {
        return this.fPositionBarre == PositionBarreHistogramme.GAUCHE ? 0 : 1;
    }
}

