/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.ITypeDessin;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.PositionBarreHistogramme;
import fr.dbe.graphique.Serie;
import fr.dbe.util.commun.Plage;
import fr.dbe.util.xml.XmlUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Histogramme
implements ITypeDessin {
    private final PositionBarreHistogramme fPositionBarre;
    private Color fFillColor;
    private Stroke fStroke = new BasicStroke(1.0f);

    public Histogramme() {
        this.fPositionBarre = PositionBarreHistogramme.GAUCHE;
    }

    public Histogramme(PositionBarreHistogramme pPositionBarre) {
        this.fPositionBarre = pPositionBarre;
    }

    @Override
    public void dessine(Serie pCourbe, Graphics pG, double pXMin, double pXMax, int pPasAffichage) {
        if (pCourbe.size() < 1) {
            return;
        }
        if (this.fFillColor == null) {
            this.fFillColor = new Color(pCourbe.getCouleur().getRed(), pCourbe.getCouleur().getGreen(), pCourbe.getCouleur().getBlue(), 10);
        }
        Plage plage = pCourbe.plageFor(pXMin, pXMax);
        int i0 = plage.getIndiceMin();
        int i1 = plage.getIndiceMax();
        if (i0 >= pCourbe.size()) {
            return;
        }
        Axe axeH = pCourbe.getRepere().getAxeH();
        Axe axeV = pCourbe.getRepere().getAxeV();
        if (i0 < i1) {
            double x = axeH.valToPix(pCourbe.getX(i0 + this.getDXMinAff()));
            double y0 = axeV.valToPix(0.0);
            if (Double.isFinite(y0)) {
                Stroke oldStroke = ((Graphics2D)pG).getStroke();
                ((Graphics2D)pG).setStroke(this.fStroke);
                double x1 = (int)axeH.valToPix(pCourbe.getX(i0 + this.getDXMaxAff()));
                double valY = pCourbe.getY(i0);
                double y = axeV.valToPix(valY);
                int w = Math.abs((int)(x1 - x));
                int h = Math.abs((int)(y - y0));
                int xR = (int)Math.min(x1, x);
                int yR = (int)Math.min(y, y0);
                pG.setColor(this.getFillColor(valY));
                pG.fillRect(xR, yR, w, h);
                pG.setColor(this.getColor(pCourbe, y));
                pG.drawRect(xR, yR, w, h);
                x = x1;
                for (int j = i0 + pPasAffichage; j < i1; j += pPasAffichage) {
                    x1 = axeH.valToPix(pCourbe.getX(j + this.getDXMaxAff()));
                    valY = pCourbe.getY(j);
                    y = axeV.valToPix(valY);
                    if (Double.isFinite(y)) {
                        w = Math.abs((int)(x1 - x));
                        h = Math.abs((int)(y - y0));
                        xR = (int)Math.min(x1, x);
                        yR = (int)Math.min(y, y0);
                        pG.setColor(this.getFillColor(valY));
                        pG.fillRect(xR, yR, w, h);
                        pG.setColor(this.getColor(pCourbe, valY));
                        pG.drawRect(xR, yR, w, h);
                    }
                    x = x1;
                }
                ((Graphics2D)pG).setStroke(oldStroke);
            }
        }
    }

    protected Color getFillColor(double pY) {
        return this.fFillColor;
    }

    protected Color getColor(Serie pCourbe) {
        return pCourbe.getCouleur();
    }

    protected Color getColor(Serie pCourbe, double y) {
        return pCourbe.getCouleur();
    }

    @Override
    public Color getFillColor() {
        return this.fFillColor;
    }

    @Override
    public void setFillColor(Color pFillColor) {
        this.fFillColor = pFillColor;
    }

    @Override
    public Stroke getStroke() {
        return this.fStroke;
    }

    @Override
    public void setStroke(Stroke pStroke) {
        this.fStroke = pStroke == null ? new BasicStroke(1.0f) : pStroke;
    }

    @Override
    public Element getDomElement(Document pDoc) {
        Element root = pDoc.createElement(MapXmlGraph.getInstance().getNomElement(ITypeDessin.class));
        root.appendChild(XmlUtils.createStrokeNode(pDoc, (BasicStroke)this.fStroke));
        root.appendChild(XmlUtils.createColorNode(pDoc, this.fFillColor));
        return root;
    }

    @Override
    public void setProperties(Node pNoeud) {
        this.setStroke(XmlUtils.getStroke(pNoeud));
        this.setFillColor(XmlUtils.getColor(pNoeud));
    }

    @Override
    public boolean hasFillColor() {
        return true;
    }

    @Override
    public int getDXMinAff() {
        return this.fPositionBarre == PositionBarreHistogramme.DROITE ? 0 : -1;
    }

    @Override
    public int getDXMaxAff() {
        return this.fPositionBarre == PositionBarreHistogramme.DROITE ? 1 : 0;
    }
}

