/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Messages;
import fr.dbe.graphique.Quadrillage;
import fr.dbe.graphique.Repartition;
import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.BoxAssistant;
import fr.dbe.util.ihm.JAssistant;
import fr.dbe.util.ihm.JButtonColorWithLib;
import fr.dbe.util.ihm.JTextFieldSel;
import fr.dbe.util.ihm.Utils;
import java.awt.Color;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;

class BoxQuadrillage
extends BoxAssistant {
    private final JButtonColorWithLib fBtCouleur = new JButtonColorWithLib(70);
    protected JTextFieldSel fSleIntervalle = Utils.createTextFieldSel("", 150);
    protected JTextFieldSel fSleNombre = Utils.createTextFieldSel("", 150);
    protected JTextFieldSel fSlePositions = Utils.createTextFieldSel("", 150);
    protected JRadioButton fRbLie = Utils.createRadioButton(Messages.getString("BoxQuadrillage.14"), 180);
    protected JRadioButton fRbIntervalle = Utils.createRadioButton(Messages.getString("BoxQuadrillage.3"), 90);
    protected JRadioButton fRbNombre = Utils.createRadioButton(Messages.getString("BoxQuadrillage.4"), 90);
    protected JRadioButton fRbPositions = Utils.createRadioButton(Messages.getString("BoxQuadrillage.12"), 90);
    protected JCheckBox fCbVisible = Utils.createCheckBox(Messages.getString("BoxQuadrillage.2"));
    private Quadrillage fQuadrillage;

    public BoxQuadrillage(JAssistant pAssistant, Quadrillage pQuadrillage) {
        super(pAssistant, 0);
        this.add(Box.createHorizontalStrut(10));
        Box bLie = Utils.createHorizontalBox(0, this.fRbLie);
        Box bIntervalle = Utils.createHorizontalBox(0, this.fRbIntervalle, this.fSleIntervalle);
        Box bNombre = Utils.createHorizontalBox(0, this.fRbNombre, this.fSleNombre);
        Box bPositions = Utils.createHorizontalBox(0, this.fRbPositions, this.fSlePositions);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.fRbLie);
        bg.add(this.fRbIntervalle);
        bg.add(this.fRbNombre);
        bg.add(this.fRbPositions);
        Box bSelIntNb = Utils.createVerticalBox(5, bLie, bIntervalle, bNombre, bPositions);
        Box bLibIntNBox = Utils.createVerticalBox(5, Utils.createLabel(Messages.getString("BoxQuadrillage.5"), 70));
        this.add(Utils.createVerticalBox(5, this.fBtCouleur, Utils.createHorizontalBox(0, bLibIntNBox, bSelIntNb), Utils.createHorizontalBox(0, this.fCbVisible)));
        this.add(Box.createHorizontalStrut(10));
        this.setQuadrillage(pQuadrillage);
        ItemListener il = pItemEvent -> {
            this.fSleIntervalle.setEnabled(this.fRbIntervalle.isSelected());
            this.fSleNombre.setEnabled(this.fRbNombre.isSelected());
            this.fSlePositions.setEnabled(this.fRbPositions.isSelected());
        };
        this.fRbLie.addItemListener(il);
        this.fRbIntervalle.addItemListener(il);
        this.fRbNombre.addItemListener(il);
        this.fRbPositions.addItemListener(il);
        il.itemStateChanged(null);
    }

    private void setQuadrillage(Quadrillage pQuadrillage) {
        this.fQuadrillage = pQuadrillage;
        this.fBtCouleur.setCouleur(this.fQuadrillage.getCouleur());
        this.fCbVisible.setSelected(this.fQuadrillage.isVisible());
        this.fRbLie.setSelected(this.fQuadrillage.getRepartition() == Repartition.LIE);
        this.fRbIntervalle.setSelected(this.fQuadrillage.getRepartition() == Repartition.INTERVALLE);
        this.fRbNombre.setSelected(this.fQuadrillage.getRepartition() == Repartition.NOMBRE);
        this.fRbPositions.setSelected(this.fQuadrillage.getRepartition() == Repartition.POSITIONS);
        this.fSleIntervalle.setText("" + this.fQuadrillage.getIntervalle());
        this.fSleNombre.setText("" + this.fQuadrillage.getNombre());
        if (this.fQuadrillage.getPositions() != null) {
            StringBuilder sb = new StringBuilder(100);
            for (double d : this.fQuadrillage.getPositions()) {
                sb.append(d).append(";");
            }
            this.fSlePositions.setText(sb.toString());
        }
        this.addValidationFor(this.fSleIntervalle);
        this.addValidationFor(this.fSleNombre);
        this.addValidationFor(this.fSlePositions);
        this.addValidationFor(this.fRbLie);
        this.addValidationFor(this.fRbNombre);
        this.addValidationFor(this.fRbIntervalle);
        this.addValidationFor(this.fRbPositions);
    }

    @Override
    public void majbtOk() {
        this.fRbNombre.setForeground(Color.BLACK);
        if (this.fRbNombre.isSelected()) {
            try {
                int nb = Utilitaire.parseInt(this.fSleNombre.getText());
                if (nb < 1 || nb > 999) {
                    this.fAssistant.error(Messages.getString("BoxQuadrillage.8"));
                    this.fRbNombre.setForeground(Color.RED);
                }
            }
            catch (Exception ex) {
                this.fAssistant.error(Messages.getString("BoxQuadrillage.9"));
                this.fRbNombre.setForeground(Color.RED);
            }
        }
        this.fRbIntervalle.setForeground(Color.BLACK);
        if (this.fRbIntervalle.isSelected()) {
            try {
                double intervalle = Utilitaire.parseDouble(this.fSleIntervalle.getText());
                if (intervalle < 0.0) {
                    this.fAssistant.error(Messages.getString("BoxQuadrillage.10"));
                    this.fRbIntervalle.setForeground(Color.RED);
                }
            }
            catch (Exception ex) {
                this.fAssistant.error(Messages.getString("BoxQuadrillage.11"));
                this.fRbIntervalle.setForeground(Color.RED);
            }
        }
        this.fRbPositions.setForeground(Color.BLACK);
        if (this.fRbPositions.isSelected()) {
            try {
                Utilitaire.stringToDoubleArray(this.fSlePositions.getText(), ";");
            }
            catch (Exception ex) {
                this.fAssistant.error(Messages.getString("BoxQuadrillage.13"));
                this.fRbPositions.setForeground(Color.RED);
            }
        }
    }

    @Override
    public void doOk() {
        this.fQuadrillage.setCouleur(this.fBtCouleur.getCouleur());
        this.fQuadrillage.setVisible(this.fCbVisible.isSelected());
        if (this.fRbLie.isSelected()) {
            this.fQuadrillage.linkToGraduation();
        } else if (this.fRbIntervalle.isSelected()) {
            this.fQuadrillage.setIntervalle(Utilitaire.parseDouble(this.fSleIntervalle.getText()));
        } else if (this.fRbNombre.isSelected()) {
            this.fQuadrillage.setNombre(Utilitaire.parseInt(this.fSleNombre.getText()));
        } else if (this.fRbPositions.isSelected()) {
            this.fQuadrillage.setPositions(Utilitaire.stringToDoubleArray(this.fSlePositions.getText(), ";"));
        }
    }
}

