/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.JDessinGraphique;
import fr.dbe.graphique.Messages;
import fr.dbe.graphique.Serie;
import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.BoxAssistant;
import fr.dbe.util.ihm.JAssistant;
import fr.dbe.util.ihm.JTextFieldSel;
import fr.dbe.util.ihm.Utils;
import java.awt.Color;
import java.awt.GridLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

class BoxExportCsv
extends BoxAssistant {
    private static final String PREFS_KEY_FILE = "fr.dbe.graphique.expostCSV.FILE";
    private static final String PREFS_KEY_MIN = "fr.dbe.graphique.expostCSV.MIN";
    private static final String PREFS_KEY_MAX = "fr.dbe.graphique.expostCSV.MAX";
    private static final String PREFS_KEY_UNCHECKED_SERIES = "fr.dbe.graphique.expostCSV.UNCHECKED_SERIES";
    private final JTextFieldSel fSleFichier = Utils.createTextFieldSel("", 300);
    private final JTextFieldSel fSleMin = Utils.createTextFieldSel("", 50);
    private final JTextFieldSel fSleMax = Utils.createTextFieldSel("", 50);
    private final Map<JCheckBox, Serie> fMapCBSerie;
    private final JDessinGraphique fDessin;
    private final JCheckBox fCbTot;
    private boolean listen = true;

    public BoxExportCsv(JAssistant pAssistant, JDessinGraphique pDessin) {
        super(pAssistant, 1);
        this.fDessin = pDessin;
        JButton btParcourir = Utils.createButton("...");
        Box boxFichier = Utils.createHorizontalBox(5, Utils.createLabel(Messages.getString("BoxExportCsv.0"), 70), this.fSleFichier, btParcourir);
        Box boxIntervalle = Utils.createHorizontalBox(5, Utils.createLabel(Messages.getString("BoxExportCsv.3"), 70), this.fSleMin, Utils.createLabel(Messages.getString("BoxExportCsv.4"), 20), this.fSleMax);
        ArrayList<Serie> series = new ArrayList<Serie>(this.fDessin.getSeriesActives());
        Serie[] tabSeries = series.toArray(new Serie[0]);
        Arrays.sort(tabSeries, Comparator.comparing(pPS -> pPS.getNom() == null ? "" : pPS.getNom()));
        this.fSleFichier.setText(Preferences.userRoot().get(PREFS_KEY_FILE, ""));
        this.fSleMin.setText(Preferences.userRoot().get(PREFS_KEY_MIN, ""));
        this.fSleMax.setText(Preferences.userRoot().get(PREFS_KEY_MAX, ""));
        this.fMapCBSerie = new HashMap<JCheckBox, Serie>();
        List<String> unchecked = Arrays.asList(Preferences.userRoot().get(PREFS_KEY_UNCHECKED_SERIES, "").split(";"));
        JPanel boxCb = new JPanel(new GridLayout(tabSeries.length / 2 + 1, 2));
        for (Serie serie : tabSeries) {
            JCheckBox cb = Utils.createCheckBox(serie.getNom());
            boxCb.add(cb);
            cb.setSelected(serie.isVisible() && !unchecked.contains(serie.getNom().replaceAll(";", "")));
            this.fMapCBSerie.put(cb, serie);
            cb.addItemListener(pE -> {
                if (this.listen) {
                    this.majCb();
                }
            });
        }
        this.fCbTot = Utils.createCheckBox(Messages.getString("BoxExportCsv.7"));
        this.fCbTot.addItemListener(pE -> {
            if (this.listen) {
                this.listen = false;
                for (JCheckBox c : this.fMapCBSerie.keySet()) {
                    c.setSelected(this.fCbTot.isSelected());
                }
                this.listen = true;
            }
        });
        this.majCb();
        Box boxLabelSerie = Utils.createHorizontalBox(5, Utils.createLabel(Messages.getString("BoxExportCsv.1")), this.fCbTot);
        Box boxSeries = Utils.createHorizontalBox(5, new JScrollPane(boxCb));
        this.add(boxFichier);
        this.add(Box.createVerticalStrut(5));
        this.add(boxIntervalle);
        this.add(Box.createVerticalStrut(5));
        this.add(boxLabelSerie);
        this.add(Box.createVerticalStrut(5));
        this.add(boxSeries);
        this.addValidationFor(this.fSleFichier);
        this.addValidationFor(this.fSleMin);
        this.addValidationFor(this.fSleMax);
        btParcourir.addActionListener(pE -> {
            try {
                JFileChooser jfc = new JFileChooser();
                jfc.setAcceptAllFileFilterUsed(false);
                jfc.setMultiSelectionEnabled(false);
                jfc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.getAbsolutePath().toLowerCase().endsWith(".txt") || f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return Messages.getString("JPanneauGraphique.38");
                    }
                });
                if (this.fSleFichier.getText() != null) {
                    jfc.setSelectedFile(new File(this.fSleFichier.getText()));
                }
                boolean continuer = true;
                while (continuer) {
                    if (jfc.showSaveDialog(this.fDessin) == 1) {
                        return;
                    }
                    if (jfc.getSelectedFile().exists()) {
                        switch (JOptionPane.showConfirmDialog(this.fDessin, Messages.getString("JPanneauGraphique.39"), Messages.getString("JPanneauGraphique.40"), 1)) {
                            case 0: {
                                continuer = false;
                                break;
                            }
                            case 2: {
                                return;
                            }
                        }
                        continue;
                    }
                    continuer = false;
                }
                this.fSleFichier.setText(jfc.getSelectedFile().toString());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.fDessin, Messages.getString("JPanneauGraphique.41"));
            }
        });
    }

    private void majCb() {
        boolean all = true;
        for (JCheckBox cb : this.fMapCBSerie.keySet()) {
            if (cb.isSelected()) continue;
            all = false;
            break;
        }
        if (this.listen) {
            this.listen = false;
            this.fCbTot.setSelected(all);
            this.listen = true;
        } else {
            this.fCbTot.setSelected(all);
        }
    }

    @Override
    public void majbtOk() {
        this.fSleFichier.setForeground(Color.BLACK);
        if (this.fSleFichier.getText() == null || this.fSleFichier.getText().length() == 0) {
            this.fAssistant.error(Messages.getString("BoxExportCsv.2"));
            this.fSleFichier.setForeground(Color.RED);
        }
        this.fSleMin.setForeground(Color.BLACK);
        try {
            int min = Utilitaire.parseInt(this.fSleMin.getText());
            if (min < 0) {
                this.fAssistant.error(Messages.getString("BoxExportCsv.5"));
                this.fSleMin.setForeground(Color.RED);
            }
        }
        catch (Exception ex) {
            this.fAssistant.error(Messages.getString("BoxExportCsv.5"));
            this.fSleMin.setForeground(Color.RED);
        }
        this.fSleMax.setForeground(Color.BLACK);
        try {
            int max = Utilitaire.parseInt(this.fSleMax.getText());
            if (max < 0) {
                this.fAssistant.error(Messages.getString("BoxExportCsv.5"));
                this.fSleMax.setForeground(Color.RED);
            }
        }
        catch (Exception ex) {
            this.fAssistant.error(Messages.getString("BoxExportCsv.5"));
            this.fSleMax.setForeground(Color.RED);
        }
        boolean one = false;
        for (JCheckBox cb : this.fMapCBSerie.keySet()) {
            if (!cb.isSelected()) continue;
            one = true;
            break;
        }
        if (!one) {
            this.fAssistant.error(Messages.getString("BoxExportCsv.6"));
        }
    }

    @Override
    public void doOk() {
        Preferences.userRoot().put(PREFS_KEY_FILE, this.fSleFichier.getText());
        Preferences.userRoot().put(PREFS_KEY_MIN, this.fSleMin.getText());
        Preferences.userRoot().put(PREFS_KEY_MAX, this.fSleMax.getText());
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<JCheckBox, Serie> entry : this.fMapCBSerie.entrySet()) {
            if (entry.getKey().isSelected()) continue;
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(entry.getValue().getNom().replaceAll(";", ""));
        }
        Preferences.userRoot().put(PREFS_KEY_UNCHECKED_SERIES, sb.toString());
    }

    public int getMin() {
        return this.fSleMin.getText().trim().length() == 0 ? Integer.MIN_VALUE : Integer.parseInt(this.fSleMin.getText());
    }

    public int getMax() {
        return this.fSleMax.getText().trim().length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(this.fSleMax.getText());
    }

    public String getFichier() {
        return this.fSleFichier.getText();
    }

    public List<Serie> getSeries() {
        ArrayList<Serie> checked = new ArrayList<Serie>();
        for (Map.Entry<JCheckBox, Serie> entry : this.fMapCBSerie.entrySet()) {
            if (!entry.getKey().isSelected()) continue;
            checked.add(entry.getValue());
        }
        return checked;
    }
}

