/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.Log10Function;
import fr.dbe.graphique.Messages;
import fr.dbe.graphique.Sens;
import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.BoxAssistant;
import fr.dbe.util.ihm.JAssistant;
import fr.dbe.util.ihm.JButtonColorWithLib;
import fr.dbe.util.ihm.JFontSel;
import fr.dbe.util.ihm.JTextFieldWithLabel;
import fr.dbe.util.ihm.Utils;
import java.awt.Color;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;

class BoxAxe
extends BoxAssistant {
    protected final JTextFieldWithLabel fSleEtiquette = new JTextFieldWithLabel(Messages.getString("BoxAxe.0"), 70, "", 150, null);
    protected JTextFieldWithLabel fSleUnit = new JTextFieldWithLabel(Messages.getString("BoxAxe.11"), 70, "", 150, null);
    protected JTextFieldWithLabel fSleMin = new JTextFieldWithLabel(Messages.getString("BoxAxe.2"), 70, "", 150, null);
    protected JTextFieldWithLabel fSleMax = new JTextFieldWithLabel(Messages.getString("BoxAxe.1"), 70, "", 150, null);
    protected JCheckBox fCbLog = Utils.createCheckBox(Messages.getString("BoxAxe.6"));
    protected JCheckBox fCbVisible = Utils.createCheckBox(Messages.getString("BoxAxe.3"));
    protected JRadioButton fRbSensDirect = Utils.createRadioButton(Messages.getString("BoxAxe.8"));
    protected JRadioButton fRbSensIndirect = Utils.createRadioButton(Messages.getString("BoxAxe.9"));
    protected JButtonColorWithLib fBtCouleur = new JButtonColorWithLib(70);
    protected JFontSel fFontSel = new JFontSel(70);
    private Axe fAxe;

    public BoxAxe(JAssistant pAssistant, Axe pAxe) {
        super(pAssistant, 0);
        this.add(Box.createHorizontalStrut(10));
        this.add(Utils.createVerticalBox(5, this.fSleEtiquette, this.fSleUnit, this.fFontSel, this.fBtCouleur, Utils.createRadioButtonGroupWithLib(Messages.getString("BoxAxe.10"), 70, this.fRbSensDirect, this.fRbSensIndirect), this.fSleMin, this.fSleMax, Utils.createHorizontalBox(0, this.fCbLog), Utils.createHorizontalBox(0, this.fCbVisible)));
        this.add(Box.createHorizontalStrut(10));
        if (pAxe.getMaster() != null) {
            this.fSleMin.setEnabled(false);
            this.fSleMax.setEnabled(false);
        } else {
            this.addValidationFor(this.fSleMin.getTextField());
            this.addValidationFor(this.fSleMax.getTextField());
        }
        this.setAxe(pAxe);
    }

    private void setAxe(Axe pAxe) {
        this.fAxe = pAxe;
        this.fBtCouleur.setCouleur(this.fAxe.getCouleur());
        this.fCbLog.setSelected(this.fAxe.getScaleFunction() instanceof Log10Function);
        this.fCbLog.setVisible(this.fAxe.getScaleFunction() == null || this.fAxe.getScaleFunction() instanceof Log10Function);
        this.fCbVisible.setSelected(this.fAxe.isVisible());
        this.fFontSel.setPolice(this.fAxe.getActualFont());
        this.fFontSel.setCouleur(this.fAxe.getCouleurEtiquette());
        this.fRbSensDirect.setSelected(this.fAxe.getSens().equals((Object)Sens.DIRECT));
        this.fRbSensIndirect.setSelected(this.fAxe.getSens().equals((Object)Sens.INDIRECT));
        this.fSleEtiquette.setText(this.fAxe.getEtiquette());
        this.fSleUnit.setText(this.fAxe.getUnit());
        this.fSleMax.setText("" + this.fAxe.getMax());
        this.fSleMin.setText("" + this.fAxe.getMin());
    }

    @Override
    public void majbtOk() {
        double min = Double.NaN;
        double max = Double.NaN;
        try {
            min = Utilitaire.parseDouble(this.fSleMin.getText());
            this.fSleMin.getLabel().setForeground(Color.BLACK);
        }
        catch (Exception ex) {
            this.fAssistant.error(Messages.getString("BoxAxe.13"));
            this.fSleMin.getLabel().setForeground(Color.RED);
        }
        try {
            max = Utilitaire.parseDouble(this.fSleMax.getText());
            this.fSleMax.getLabel().setForeground(Color.BLACK);
        }
        catch (Exception ex) {
            this.fSleMax.getLabel().setForeground(Color.RED);
            this.fAssistant.error(Messages.getString("BoxAxe.14"));
        }
        if (!Double.isNaN(min) && !Double.isNaN(max)) {
            if (max <= min) {
                this.fSleMin.getLabel().setForeground(Color.RED);
                this.fSleMax.getLabel().setForeground(Color.RED);
                this.fAssistant.error(Messages.getString("BoxAxe.15"));
            } else {
                this.fSleMin.getLabel().setForeground(Color.BLACK);
                this.fSleMax.getLabel().setForeground(Color.BLACK);
            }
        }
    }

    @Override
    public void doOk() {
        this.fAxe.setCouleur(this.fBtCouleur.getCouleur());
        if (this.fCbLog.isSelected()) {
            this.fAxe.setScaleFunction(new Log10Function());
        } else {
            this.fAxe.setScaleFunction(null);
        }
        this.fAxe.setVisible(this.fCbVisible.isSelected());
        this.fAxe.setPolice(this.fFontSel.getPolice());
        this.fAxe.setCouleurEtiquette(this.fFontSel.getCouleur());
        this.fAxe.setSens(this.fRbSensDirect.isSelected() ? Sens.DIRECT : Sens.INDIRECT);
        this.fAxe.setEtiquette(this.fSleEtiquette.getText());
        this.fAxe.setUnit(this.fSleUnit.getText());
        this.fAxe.setBornes(Utilitaire.parseDouble(this.fSleMin.getText()), Utilitaire.parseDouble(this.fSleMax.getText()));
    }

    public void maj() {
        this.fSleMin.setText("" + this.fAxe.getMin());
        this.fSleMax.setText("" + this.fAxe.getMax());
    }
}

