/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.Direction;
import fr.dbe.graphique.GraduationV;
import fr.dbe.graphique.JDessinGraphique;
import fr.dbe.graphique.PositionAxeV;
import fr.dbe.graphique.Repere;
import fr.dbe.graphique.Sens;
import fr.dbe.graphique.VerticalLabel;
import fr.dbe.graphique.pixeltransformer.DirectVPixelTransformer;
import fr.dbe.util.ihm.HorizontalLabelPosition;
import fr.dbe.util.ihm.Utils;
import fr.dbe.util.ihm.VerticalLabelPosition;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JLabel;

public class AxeV
extends Axe {
    public AxeV(JDessinGraphique p, Repere pRepere) {
        super(p, pRepere);
        this.fGraduation = new GraduationV(this);
        this.fEtiquette = "";
        this.fPixelTransformer = new DirectVPixelTransformer(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, null);
    }

    @Override
    public void dessineAxe(Graphics g) {
        int p;
        int signe;
        int yMin = (int)this.getRepere().getDrawingRectangle().getMinY();
        int yMax = (int)this.getRepere().getDrawingRectangle().getMaxY();
        Font oldFont = g.getFont();
        g.setFont(this.fPolice);
        g.setColor(this.fCouleur);
        g.drawLine(this.getPosition(), yMin, this.getPosition(), yMax);
        if (this.fSens.equals((Object)Sens.DIRECT)) {
            signe = 1;
            p = yMin;
        } else {
            signe = -1;
            p = yMax;
        }
        g.drawLine(this.getPosition() - 2, p + signe * 5, this.getPosition(), p);
        g.drawLine(this.getPosition() + 2, p + signe * 5, this.getPosition(), p);
        String etiquette = this.getEtiquetteEtUnit();
        if (etiquette != null) {
            int x;
            VerticalLabel label = new VerticalLabel();
            label.setForeground(g.getColor());
            label.setOpaque(false);
            label.setFont(g.getFont());
            label.setHorizontalAlignment(0);
            label.setText(etiquette);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D textbounds = fm.getStringBounds(etiquette, g);
            int w = (int)textbounds.getWidth();
            int h = (int)textbounds.getHeight() + fm.getDescent();
            label.setSize(new Dimension(w + 4, h));
            if (this.getFont() != null) {
                JLabel l = new JLabel(etiquette);
                l.setFont(g.getFont());
                while (g.getFont().getSize() > 4 && l.getPreferredSize().getWidth() > (double)(yMax - yMin)) {
                    g.setFont(new Font(g.getFont().getFontName(), g.getFont().getStyle(), g.getFont().getSize() - 1));
                    l.setFont(g.getFont());
                }
                label.setFont(g.getFont());
            }
            if (this.fCouleurEtiquette != null) {
                label.setForeground(this.fCouleurEtiquette);
            }
            int y = (this.getDessin().getHeight() - h) / 2;
            if (this.getRepere().getPosAxeV().equals(PositionAxeV.GAUCHE) || this.getRepere().getPosAxeV().equals(PositionAxeV.ORIGINE)) {
                label.setRotation(-1);
                x = (int)this.fDessin.getMarges().getGauche();
            } else {
                label.setRotation(1);
                x = (int)((double)this.getDessin().getWidth() - this.fDessin.getMarges().getDroite());
            }
            g.translate(x, y);
            label.update(g);
            g.translate(-x, -y);
        }
        g.setFont(oldFont);
    }

    @Override
    public double valToPix(double v) {
        return this.fPixelTransformer.val2Pix(v);
    }

    @Override
    public double pixToVal(int y) {
        return this.fPixelTransformer.pix2Val(y);
    }

    public int getTailleTexteGraduation() {
        return 0;
    }

    @Override
    public Direction getDirection() {
        return Direction.VERTICALE;
    }

    @Override
    public double getPositionAutreAxe() {
        return this.getRepere().getValPosAxeH();
    }

    @Override
    public Rectangle2D empriseEtiquette(Graphics pGraphics) {
        Font font;
        String etiquette = this.getEtiquetteEtUnit();
        if (etiquette == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        int xMin = (int)this.getRepere().getDrawingRectangle().getMinX();
        int xMax = (int)this.getRepere().getDrawingRectangle().getMaxX();
        Font font2 = font = this.getFont() == null ? pGraphics.getFont() : this.getActualFont();
        while (font.getSize() > 4 && Utils.libelleHtmlBounds(pGraphics, 0, 0, etiquette, HorizontalLabelPosition.CENTER, VerticalLabelPosition.MIDDLE, font).getWidth() > (double)(xMax - xMin)) {
            font = new Font(font.getFontName(), font.getStyle(), font.getSize() - 1);
        }
        Rectangle rect = Utils.libelleHtmlBounds(pGraphics, 0, 0, etiquette, HorizontalLabelPosition.CENTER, VerticalLabelPosition.MIDDLE, font);
        return new Rectangle(0, 0, (int)((RectangularShape)rect).getHeight(), (int)((RectangularShape)rect).getWidth());
    }
}

