/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.AxeH;
import fr.dbe.graphique.Direction;
import fr.dbe.graphique.Graduation;
import fr.dbe.graphique.JDessinGraphique;
import fr.dbe.graphique.Log10Function;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.Messages;
import fr.dbe.graphique.Repere;
import fr.dbe.graphique.ScaleFunction;
import fr.dbe.graphique.Sens;
import fr.dbe.graphique.pixeltransformer.PixelTransformer;
import fr.dbe.util.commun.ElementListenerHelper;
import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.log.Log;
import fr.dbe.util.xml.IXmlElement;
import fr.dbe.util.xml.XmlUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Axe
implements IXmlElement {
    public static final String PROPERTY_BORNES = "BORNES";
    public static final double MIN_LOG = 1.0E-10;
    private static final String DOM_VISIBLE = "visible";
    private static final String DOM_MAX = "max";
    private static final String DOM_MIN = "min";
    private static final String DOM_SENS = "sens";
    private static final String DOM_ETIQUETTE = "etiquette";
    private static final String DOM_UNIT = "unite";
    private final Repere fRepere;
    private final List<Axe> fLinkedAxes;
    protected final JDessinGraphique fDessin;
    protected Sens fSens = Sens.DIRECT;
    protected String fEtiquette;
    protected String fUnit;
    protected Graduation fGraduation;
    protected ScaleFunction fScaleFunction;
    protected boolean fVisible = true;
    protected Color fCouleur = Color.BLACK;
    protected Color fCouleurEtiquette;
    protected Font fPolice = Utilitaire.FONT_PLAIN_12;
    protected PixelTransformer fPixelTransformer;
    final ElementListenerHelper fElementListenerHelper;
    private double fMin;
    private double fMax;
    private Double fBorneMinAutorisee;
    private Double fBorneMaxAutorisee;
    private double fMinMax = Double.POSITIVE_INFINITY;
    private double fMaxMin = Double.NEGATIVE_INFINITY;
    private int fPosition;
    private Axe fMaster;

    public Axe(JDessinGraphique p, Repere pRepere) {
        this.fDessin = p;
        this.fRepere = pRepere;
        this.fLinkedAxes = new ArrayList<Axe>();
        this.fElementListenerHelper = new ElementListenerHelper();
        this.setBornes(-1.0, -1.0);
    }

    public void setIntervalleMini(double pMinMax, double pMaxMin) {
        this.fMinMax = pMinMax;
        this.fMaxMin = pMaxMin;
    }

    public void addLinkedAxe(Axe pAxe) {
        this.fLinkedAxes.add(pAxe);
        pAxe.setBornes(this.fMin, this.fMax);
        pAxe.getGraduation().setTaille(this.getGraduation().getTaille());
        pAxe.getGraduation().setOrientation(this.getGraduation().getOrientation());
        switch (this.getGraduation().getRepartition()) {
            case INTERVALLE: {
                pAxe.getGraduation().setIntervalle(this.getGraduation().getIntervalle());
                break;
            }
            case NOMBRE: {
                pAxe.getGraduation().setNombre(this.getGraduation().getNombre());
                break;
            }
            case POSITIONS: {
                pAxe.getGraduation().setPositions(this.getGraduation().getPositions());
                break;
            }
        }
        pAxe.fMaster = this;
        if (pAxe instanceof AxeH) {
            pAxe.getGraduation().setVisible(false);
            pAxe.setEtiquette("");
            pAxe.setUnit("");
        }
    }

    public Axe getMaster() {
        return this.fMaster;
    }

    public void removeLinkedAxe(Axe pAxe) {
        this.fLinkedAxes.remove(pAxe);
        pAxe.fMaster = null;
    }

    public List<Axe> getLinkedAxes() {
        return this.fLinkedAxes;
    }

    public String getEtiquette() {
        return this.fEtiquette;
    }

    public void setEtiquette(String e) {
        this.fEtiquette = e;
    }

    protected void dessine(Graphics g) {
        if (!this.fVisible) {
            return;
        }
        Font oldFont = g.getFont();
        g.setFont(this.getActualFont());
        g.setColor(this.fCouleur);
        this.dessineAxe(g);
        g.setFont(oldFont);
    }

    protected abstract void dessineAxe(Graphics var1);

    public void setBornes(double pMin, double pMax) {
        if (this.fMaster != null) {
            return;
        }
        double oldMin = this.fMin;
        double oldMax = this.fMax;
        this.fMin = this.fBorneMinAutorisee != null ? Math.min(this.fBorneMinAutorisee, pMin) : pMin;
        if (this.fScaleFunction != null && this.fScaleFunction instanceof Log10Function && this.fMin <= 0.0) {
            this.fMin = Math.max(this.fMin, 1.0E-10);
        }
        this.fMax = this.fBorneMaxAutorisee != null ? Math.max(this.fBorneMaxAutorisee, pMax) : pMax;
        this.fMin = Math.min(this.fMinMax, this.fMin);
        this.fMax = Math.max(this.fMaxMin, this.fMax);
        if (this.fMin != oldMin || this.fMax != oldMax) {
            if (!this.fLinkedAxes.isEmpty()) {
                for (Axe axe : this.fLinkedAxes) {
                    axe.fMin = this.fMin;
                    axe.fMax = this.fMax;
                }
            }
            this.fElementListenerHelper.fireValueChanged(PROPERTY_BORNES, this);
            this.fRepere.getDessin().majDpix();
        }
    }

    public ElementListenerHelper getElementListenerHelper() {
        return this.fElementListenerHelper;
    }

    public double getMin() {
        return this.fMin;
    }

    public double getMax() {
        return this.fMax;
    }

    public Repere getRepere() {
        return this.fRepere;
    }

    protected JDessinGraphique getDessin() {
        return this.fDessin;
    }

    public abstract double valToPix(double var1);

    public abstract double pixToVal(int var1);

    public ScaleFunction getScaleFunction() {
        return this.fScaleFunction;
    }

    protected void setScaleFunction(ScaleFunction pScaleFunction) {
        this.fScaleFunction = pScaleFunction;
        if (this.fScaleFunction != null && this.fScaleFunction instanceof Log10Function && this.fMin <= 0.0) {
            this.fMin = Math.max(this.fMin, 1.0E-10);
        }
        this.fElementListenerHelper.fireValueChanged(PROPERTY_BORNES, this);
        if (this.fScaleFunction != pScaleFunction) {
            this.fRepere.getDessin().majDpix();
        }
    }

    protected boolean isVisible() {
        return this.fVisible;
    }

    protected void setVisible(boolean etat) {
        this.fVisible = etat;
    }

    public Color getCouleur() {
        return this.fCouleur;
    }

    public void setCouleur(Color c) {
        this.fCouleur = c;
    }

    public void setPolice(Font f) {
        this.fPolice = f;
    }

    protected Font getFont() {
        return this.fPolice;
    }

    @Override
    public Element getDomElement(Document doc) {
        Element root = doc.createElement(MapXmlGraph.getInstance().getNomElement(this));
        root.appendChild(XmlUtils.createColorNode(doc, this.fCouleur));
        root.setAttribute(DOM_ETIQUETTE, this.fEtiquette);
        root.setAttribute(DOM_UNIT, this.fUnit);
        root.setAttribute(DOM_MIN, String.valueOf(this.fMin));
        root.setAttribute(DOM_MAX, String.valueOf(this.fMax));
        root.setAttribute(DOM_SENS, String.valueOf(this.fSens.ordinal()));
        root.appendChild(XmlUtils.createPoliceNode(doc, this.fPolice));
        root.setAttribute(DOM_VISIBLE, String.valueOf(this.fVisible));
        root.appendChild(this.fGraduation.getDomElement(doc));
        return root;
    }

    @Override
    public void setProperties(Node pNoeud) {
        this.fSens = Sens.values()[XmlUtils.getAttributeIntValue(pNoeud, DOM_SENS, 0)];
        this.setEtiquette(XmlUtils.getAttributeStringValue(pNoeud, DOM_ETIQUETTE, "?"));
        this.setUnit(XmlUtils.getAttributeStringValue(pNoeud, DOM_UNIT, "?"));
        this.setBornes(XmlUtils.getAttributeDoubleValue(pNoeud, DOM_MIN, -1.0), XmlUtils.getAttributeDoubleValue(pNoeud, DOM_MAX, 1.0));
        this.setVisible(XmlUtils.getAttributeBooleanValue(pNoeud, DOM_VISIBLE, true));
        this.setCouleur(XmlUtils.getColor(pNoeud));
        this.setPolice(XmlUtils.getPolice(pNoeud));
        Node n = XmlUtils.getFils(pNoeud, MapXmlGraph.getInstance().getNomElement(this.fGraduation));
        if (n != null) {
            this.fGraduation.setProperties(n);
        } else {
            Log.getInstance().warn(Messages.getString("Axe.7") + MapXmlGraph.getInstance().getNomElement(this.fGraduation) + Messages.getString("Axe.8"));
        }
    }

    public Graduation getGraduation() {
        return this.fGraduation;
    }

    public Sens getSens() {
        return this.fSens;
    }

    public void setSens(Sens pSens) {
        this.fSens = pSens;
        this.fRepere.getDessin().majDpix();
    }

    public abstract Direction getDirection();

    public Color getCouleurEtiquette() {
        return this.fCouleurEtiquette;
    }

    public void setCouleurEtiquette(Color pCouleurEtiquette) {
        this.fCouleurEtiquette = pCouleurEtiquette;
    }

    public int getPosition() {
        return this.fPosition;
    }

    public void setPosition(int pPosition) {
        this.fPosition = pPosition;
    }

    public PixelTransformer getPixelTransformer() {
        return this.fPixelTransformer;
    }

    public void setPixelTransformer(PixelTransformer pPixelTransformer) {
        this.fPixelTransformer = pPixelTransformer;
    }

    public void setBorneMinAutorisee(Double pBorneMinAutorisee) {
        this.fBorneMinAutorisee = pBorneMinAutorisee;
    }

    public void setBorneMaxAutorisee(Double pBorneMaxAutorisee) {
        this.fBorneMaxAutorisee = pBorneMaxAutorisee;
    }

    public abstract double getPositionAutreAxe();

    public Font getActualFont() {
        if (this.getDessin().getHeight() > 0 && this.getDessin().getHeight() / this.getFont().getSize() < 8) {
            return new Font(this.getFont().getFontName(), this.getFont().getStyle(), this.getDessin().getHeight() / 8);
        }
        return this.getFont();
    }

    public abstract Rectangle2D empriseEtiquette(Graphics var1);

    public String getUnit() {
        return this.fUnit;
    }

    public void setUnit(String pUnit) {
        this.fUnit = pUnit;
    }

    public String getEtiquetteEtUnit() {
        StringBuilder sb = new StringBuilder();
        if (this.fEtiquette == null || this.fEtiquette.trim().length() == 0) {
            if (this.fUnit == null || this.fUnit.trim().length() == 0) {
                return null;
            }
            if (this.fUnit.startsWith("<html>")) {
                String unit = this.fUnit.replaceAll("<html>", "").replaceAll("</html>", "");
                sb.append(unit.trim());
            } else {
                sb.append(this.fUnit.trim());
            }
        } else {
            if (this.fEtiquette.startsWith("<html>")) {
                String etiquette = this.fEtiquette.replaceAll("<html>", "").replaceAll("</html>", "");
                sb.append(etiquette);
            } else {
                sb.append(this.fEtiquette);
            }
            if (this.fUnit != null && this.fUnit.trim().length() > 0) {
                if (this.fUnit.startsWith("<html>")) {
                    String unit = this.fUnit.replaceAll("<html>", "").replaceAll("</html>", "");
                    sb.append(" (").append(unit.trim()).append(")");
                } else {
                    sb.append(" (").append(this.fUnit.trim()).append(")");
                }
            }
        }
        return "<html>" + sb + "</html>";
    }
}

