/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.StringProperty;

public class Watcher {
    private boolean fStopped;
    private ExecutorService fExecutorService = null;
    private WatchService fWatchService = null;

    public Watcher(StringProperty pPathnameProperty, Runnable pRunnable) throws Exception {
        pPathnameProperty.addListener((pObservable, pOldValue, pNewValue) -> {
            if (pNewValue != null && new File((String)pNewValue).exists()) {
                try {
                    this.stopServices();
                    this.fStopped = false;
                    this.fExecutorService = Executors.newCachedThreadPool();
                    FileSystem fs = FileSystems.getDefault();
                    this.fWatchService = fs.newWatchService();
                    ConcurrentHashMap<WatchKey, Path> keys = new ConcurrentHashMap<WatchKey, Path>();
                    this.fExecutorService.submit(() -> {
                        while (!this.fStopped && !Thread.interrupted()) {
                            WatchKey key;
                            try {
                                key = this.fWatchService.poll(2L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException | ClosedWatchServiceException e1) {
                                break;
                            }
                            if (key == null) continue;
                            Path path = (Path)keys.get(key);
                            for (WatchEvent<?> watchEvent : key.pollEvents()) {
                                if (!path.resolve((Path)watchEvent.context()).equals(fs.getPath((String)pPathnameProperty.get(), new String[0]))) continue;
                                pRunnable.run();
                            }
                            if (key.reset()) continue;
                            keys.remove(key);
                            if (!keys.isEmpty()) continue;
                            break;
                        }
                        this.stopServices();
                    });
                    this.register(fs.getPath((String)pPathnameProperty.get(), new String[0]).getParent(), keys);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void stopServices() {
        if (this.fExecutorService != null) {
            try {
                this.fWatchService.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fExecutorService.shutdownNow();
        }
    }

    private void register(Path dir, Map<WatchKey, Path> keys) throws IOException {
        WatchKey key = dir.register(this.fWatchService, StandardWatchEventKinds.ENTRY_MODIFY);
        keys.put(key, dir);
    }

    public void stop() {
        this.fStopped = true;
    }
}

