/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx.draw;

import fr.geonosis.karstmod.modele.Reservoir;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfig;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfigType;
import fr.geonosis.karstmod.viewfx.StylesV2;
import fr.geonosis.karstmod.viewfx.draw.ClassicalReservoirGroup;
import fr.geonosis.karstmod.viewfx.draw.NoConfigReservoirGroup;
import fr.geonosis.karstmod.viewfx.draw.PiezoGroup;
import fr.geonosis.karstmod.viewfx.draw.TcInfReservoirGroup;
import fr.geonosis.karstmod.viewfx.utils.HtmlTextBox;
import fr.geonosis.karstmod.viewfx.utils.MyTooltip;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;

public class ReservoirGroup
extends Group {
    private final Reservoir fReservoir;
    private final PiezoGroup fPiezo;
    public static final LinearGradient BOTTOMLESS_GRADIENT = new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, StylesV2.COLOR_RESERVOIR_BACKGROUND), new Stop(1.0, Color.TRANSPARENT)});
    public static final LinearGradient BOTTOMLESS_BORDER_GRADIENT = new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.BLACK), new Stop(1.0, Color.TRANSPARENT)});
    private final double fHeight;
    private final ImageView fConfigImageView;
    private final ClassicalReservoirGroup fClassicalReservoirGroup;
    private final TcInfReservoirGroup fTcInfReservoirGroup;

    public ReservoirGroup(Reservoir pReservoir, double pWidth, double pHeight, ZeroPos pClassical0Pos) {
        this.fReservoir = pReservoir;
        this.fHeight = pHeight;
        this.fClassicalReservoirGroup = new ClassicalReservoirGroup(pReservoir, pWidth, pHeight, pClassical0Pos);
        this.fTcInfReservoirGroup = new TcInfReservoirGroup(pReservoir, pWidth, pHeight);
        NoConfigReservoirGroup noConfigReservoirGroup = new NoConfigReservoirGroup(pReservoir, pWidth, pHeight);
        Image questionImage = new Image(((Object)((Object)this)).getClass().getResourceAsStream("resources/question.png"));
        Image classicalImage = new Image(((Object)((Object)this)).getClass().getResourceAsStream("resources/classical.png"));
        Image infiniteImage = new Image(((Object)((Object)this)).getClass().getResourceAsStream("resources/infinite.png"));
        Image fallImage = new Image(((Object)((Object)this)).getClass().getResourceAsStream("resources/fall.png"));
        this.fConfigImageView = new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("resources/question.png")));
        this.fConfigImageView.setPreserveRatio(true);
        this.fConfigImageView.setOpacity(0.5);
        VBox configImagePane = new VBox(new Node[]{this.fConfigImageView});
        HtmlTextBox label = new HtmlTextBox(pReservoir.getHtmlLabel(), StylesV2.FONT_RESERVOIR_LABEL);
        configImagePane.setTranslateX((pWidth + label.getComputedWidth()) / 2.0 + 10.0);
        configImagePane.setCursor(Cursor.HAND);
        configImagePane.setOnMousePressed(e -> {
            pReservoir.selectNextConfig();
            e.consume();
        });
        configImagePane.visibleProperty().bind((ObservableValue)pReservoir.activeProperty());
        MyTooltip tooltip = new MyTooltip("Config", 100.0, 60000.0, 200.0);
        Tooltip.install((Node)configImagePane, (Tooltip)tooltip);
        ChangeListener configListener = (pObservable, pOldValue, pNewValue) -> {
            ReservoirConfig activeConfig = pReservoir.activeConfig();
            if (activeConfig == null) {
                this.fConfigImageView.setImage(questionImage);
                tooltip.textProperty().set((Object)"No configuration selected");
            } else {
                switch (activeConfig.getType()) {
                    case CLASSICAL: {
                        this.fConfigImageView.setImage(classicalImage);
                        tooltip.textProperty().set((Object)"Classical config");
                        break;
                    }
                    case INFINITE_TC: {
                        this.fConfigImageView.setImage(infiniteImage);
                        tooltip.textProperty().set((Object)"Infinite Tc");
                        break;
                    }
                    case NASH_FALL: {
                        this.fConfigImageView.setImage(fallImage);
                        tooltip.textProperty().set((Object)"Nash fall");
                    }
                }
            }
            configImagePane.setTranslateY(this.fHeight / 2.0 + 2.0 - this.fConfigImageView.getBoundsInLocal().getHeight() / 2.0);
        };
        configListener.changed(null, null, null);
        for (ReservoirConfig config : pReservoir.getConfigs()) {
            config.activeProperty().addListener(configListener);
        }
        this.getChildren().add((Object)noConfigReservoirGroup);
        this.getChildren().add((Object)this.fClassicalReservoirGroup);
        this.getChildren().add((Object)this.fTcInfReservoirGroup);
        this.getChildren().add((Object)configImagePane);
        for (ReservoirConfig config : pReservoir.getConfigs()) {
            config.activeProperty().addListener((pObservable, pOldValue, pNewValue) -> {
                this.fClassicalReservoirGroup.setVisible(pReservoir.getConfig(ReservoirConfigType.CLASSICAL).isActive());
                this.fTcInfReservoirGroup.setVisible(pReservoir.getConfig(ReservoirConfigType.INFINITE_TC).isActive());
                noConfigReservoirGroup.setVisible(!pReservoir.getConfig(ReservoirConfigType.CLASSICAL).isActive() && !pReservoir.getConfig(ReservoirConfigType.INFINITE_TC).isActive());
            });
        }
        this.fClassicalReservoirGroup.setVisible(pReservoir.getConfig(ReservoirConfigType.CLASSICAL).isActive());
        this.fTcInfReservoirGroup.setVisible(pReservoir.getConfig(ReservoirConfigType.INFINITE_TC).isActive());
        noConfigReservoirGroup.setVisible(!pReservoir.getConfig(ReservoirConfigType.CLASSICAL).isActive() && !pReservoir.getConfig(ReservoirConfigType.INFINITE_TC).isActive());
        if (pReservoir.isActivable()) {
            this.setCursor(Cursor.HAND);
            this.setOnMousePressed(e -> {
                if (pReservoir.isActivable()) {
                    pReservoir.setSelected(!pReservoir.isSelected());
                }
            });
        }
        this.fPiezo = new PiezoGroup(pReservoir.getPiezo(), pWidth / 20.0, pHeight - 2.0);
        this.fPiezo.setTranslateX(9.0 * pWidth / 10.0);
        this.fPiezo.setTranslateY(3.0);
        this.getChildren().add((Object)this.fPiezo);
    }

    public double getHeight() {
        return this.fHeight;
    }

    public ClassicalReservoirGroup getClassicalReservoirGroup() {
        return this.fClassicalReservoirGroup;
    }

    public TcInfReservoirGroup getTcInfReservoirGroup() {
        return this.fTcInfReservoirGroup;
    }

    public Reservoir getReservoir() {
        return this.fReservoir;
    }

    public PiezoGroup getPiezo() {
        return this.fPiezo;
    }

    public static enum ZeroPos {
        LEFT,
        RIGHT,
        IN;

    }
}

