/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx.draw;

import fr.geonosis.karstmod.modele.IBaseElement;
import fr.geonosis.karstmod.viewfx.utils.HtmlTextBox;
import fr.geonosis.karstmod.viewfx.utils.MyTooltip;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Tooltip;

public class AbstractElementGroup<T extends IBaseElement>
extends Group {
    private boolean fTipInstalled;
    private MyTooltip fTip;
    private final T fElt;
    private final boolean fHideable;

    public AbstractElementGroup(T pElt, boolean pHideable) {
        this.fElt = pElt;
        this.fHideable = pHideable;
        this.setCursor(Cursor.HAND);
        this.fElt.activeProperty().addListener((pObservable, pOldValue, pNewValue) -> this.majOpacity());
        this.majOpacity();
        if (pHideable) {
            this.fElt.getParentsHandler().addActiveListener(pObservable -> this.setVisible(this.fElt.getParentsHandler().isActive()));
            this.setVisible(this.fElt.getParentsHandler().isActive());
        }
        this.fElt.tooltipTextproperty().addListener((obs, o, n) -> this.updateTip());
        this.updateTip();
        this.setOnMousePressed(e -> {
            if (this.fElt.isActivable()) {
                this.fElt.setSelected(!this.fElt.isSelected());
            }
            e.consume();
        });
    }

    private void updateTip() {
        if (this.fElt.getToolTipText() != null && !this.fElt.getToolTipText().isEmpty() && !((String)this.fElt.htmlLabelProperty().get()).equals(this.fElt.getToolTipText())) {
            String content = this.fElt.getToolTipText();
            if (this.fTipInstalled) {
                HtmlTextBox tf = new HtmlTextBox(content);
                this.fTip.setGraphic((Node)tf);
            } else {
                this.fTip = new MyTooltip(null, 200.0, 60000.0, 100.0);
                HtmlTextBox tf = new HtmlTextBox(content);
                this.fTip.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.fTip.setGraphic((Node)tf);
                Tooltip.install((Node)this, (Tooltip)this.fTip);
                this.fTipInstalled = true;
            }
        } else if (this.fTipInstalled) {
            Tooltip.uninstall((Node)this, (Tooltip)this.fTip);
        }
    }

    private void majOpacity() {
        this.setOpacity(this.fElt.isActive() ? 1.0 : 0.2);
    }

    public boolean isTipInstalled() {
        return this.fTipInstalled;
    }

    public T getElt() {
        return this.fElt;
    }

    protected MyTooltip getTip() {
        return this.fTip;
    }

    public boolean isHideable() {
        return this.fHideable;
    }
}

