/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.MessageType;
import fr.geonosis.karstmod.modele.ModeKarstMod;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.Unit;
import fr.geonosis.karstmod.viewfx.AbstractParamPaneController;
import fr.geonosis.karstmod.viewfx.StylesV2;
import fr.geonosis.karstmod.viewfx.utils.DecimalFormatHelper;
import fr.geonosis.karstmod.viewfx.utils.DecimalFormatter;
import fr.geonosis.karstmod.viewfx.utils.HtmlTextBox;
import fr.geonosis.karstmod.viewfx.utils.MyTooltip;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class ParamPaneController
extends AbstractParamPaneController {
    private static double maxWidth = 0.0;
    private static final List<ParamPaneController> instances = new ArrayList<ParamPaneController>();
    private static final double CB_BASE_WIDTH = 21.0;
    @FXML
    private HBox root;
    @FXML
    private CheckBox checkBox;
    @FXML
    private HBox cbBox;
    @FXML
    private Pane namePane;
    @FXML
    private TextField minField;
    @FXML
    private Label toLabel;
    @FXML
    private TextField maxField;
    @FXML
    private TextField valueField;
    @FXML
    private Pane unitPane;
    @FXML
    private ImageView errorImage;
    @FXML
    private ImageView warningImage;
    private Parameter fParameter;
    private MyTooltip imageTooltip;

    @FXML
    private void initialize() {
        this.root.managedProperty().bind((ObservableValue)this.root.visibleProperty());
        this.namePane.managedProperty().bind((ObservableValue)this.namePane.visibleProperty());
        this.imageTooltip = new MyTooltip(null, 0.0, 60000.0, 200.0);
        this.imageTooltip.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        Tooltip.install((Node)this.errorImage, (Tooltip)this.imageTooltip);
        Tooltip.install((Node)this.warningImage, (Tooltip)this.imageTooltip);
        this.minField.setTextFormatter((TextFormatter)new DecimalFormatter());
        this.maxField.setTextFormatter((TextFormatter)new DecimalFormatter());
        this.valueField.setTextFormatter((TextFormatter)new DecimalFormatter());
        this.checkBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.majState((boolean)newValue));
        this.valueField.managedProperty().bind((ObservableValue)this.valueField.visibleProperty());
        this.minField.managedProperty().bind((ObservableValue)this.minField.visibleProperty());
        this.maxField.managedProperty().bind((ObservableValue)this.maxField.visibleProperty());
        this.toLabel.managedProperty().bind((ObservableValue)this.toLabel.visibleProperty());
        this.errorImage.managedProperty().bind((ObservableValue)this.errorImage.visibleProperty());
        this.warningImage.managedProperty().bind((ObservableValue)this.warningImage.visibleProperty());
        this.valueField.setVisible(false);
        this.errorImage.setVisible(false);
        this.warningImage.setVisible(false);
    }

    public void setParameter(Parameter pParameter) {
        double w;
        if (this.fParameter != null) {
            throw new IllegalArgumentException("Can't change Parameter");
        }
        this.fParameter = pParameter;
        this.root.paddingProperty().set((Object)new Insets(0.0, 0.0, 0.0, (double)(this.fParameter.getLevel() * 20) + (double)this.fParameter.getLevel() * 4.0));
        this.checkBox.setVisible(this.fParameter.isActivable());
        this.namePane.setVisible(!this.fParameter.isActivable());
        HtmlTextBox cbTextBox = new HtmlTextBox(this.fParameter.getHtmlLabel());
        cbTextBox.setTranslateX(5.0);
        if (this.fParameter.isActivable()) {
            this.checkBox.setGraphic((Node)cbTextBox);
            w = cbTextBox.getComputedWidth();
            if (w > maxWidth) {
                maxWidth = w;
                ParamPaneController.updateInstanceWidths();
            }
            instances.add(this);
            this.checkBox.setPrefWidth(maxWidth + 21.0);
            this.checkBox.setMinWidth(maxWidth + 21.0);
        } else {
            this.namePane.getChildren().add((Object)new HtmlTextBox(this.fParameter.getHtmlLabel()));
            w = ((HtmlTextBox)((Object)this.namePane.getChildren().get(0))).getComputedWidth();
            if (w > maxWidth) {
                maxWidth = w;
                ParamPaneController.updateInstanceWidths();
            }
            instances.add(this);
            this.namePane.setMinWidth(maxWidth);
            this.namePane.setMinWidth(maxWidth);
        }
        HtmlTextBox unitTextBox = new HtmlTextBox(Unit.getInstance().getBase().get(this.fParameter.getDimension()));
        this.unitPane.getChildren().add((Object)unitTextBox);
        Unit.getInstance().baseProperty().addListener((pObservable, pOldValue, pNewValue) -> unitTextBox.setLabel(Unit.getInstance().getBase().get(this.fParameter.getDimension())));
        this.checkBox.selectedProperty().bindBidirectional((Property)this.fParameter.selectedProperty());
        this.fParameter.calibrateProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            if (this.fParameter.isActivable()) {
                ((HtmlTextBox)this.checkBox.getGraphic()).setTextColor((Paint)this.getParamColor());
            } else {
                for (Node text : this.namePane.getChildren()) {
                    ((HtmlTextBox)text).setTextColor((Paint)this.getParamColor());
                }
            }
        });
        this.fParameter.activeProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            this.validate();
            this.validateChained();
        });
        this.fParameter.getParentsHandler().addActiveListener(observable -> this.root.setVisible(this.fParameter.getParentsHandler().isActive()));
        this.root.setVisible(this.fParameter.getParentsHandler().isActive());
        this.fParameter.minProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            this.minField.getStyleClass().remove((Object)".error-field");
            try {
                String textValue = DecimalFormatHelper.preformat((String)this.minField.textProperty().get());
                if (textValue.isEmpty() || NumberFormat.getNumberInstance().parse(textValue).doubleValue() != pNewValue.doubleValue()) {
                    this.minField.textProperty().set((Object)(Double.isNaN(pNewValue.doubleValue()) ? "" : String.valueOf(pNewValue)));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (Double.isNaN(pNewValue.doubleValue())) {
                this.minField.getStyleClass().remove((Object)".error-field");
            }
        });
        this.minField.textProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            this.fParameter.minProperty().set((Object)DecimalFormatHelper.parseExact(pNewValue));
            this.validate();
            this.validateChained();
        });
        this.fParameter.maxProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            this.maxField.getStyleClass().remove((Object)".error-field");
            try {
                String textValue = DecimalFormatHelper.preformat((String)this.maxField.textProperty().get());
                if (NumberFormat.getNumberInstance().parse(textValue).doubleValue() != pNewValue.doubleValue()) {
                    this.maxField.textProperty().set((Object)String.valueOf(pNewValue));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (Double.isNaN(pNewValue.doubleValue())) {
                this.maxField.getStyleClass().add((Object)".error-field");
            }
        });
        this.maxField.textProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            this.fParameter.maxProperty().set((Object)DecimalFormatHelper.parseExact(pNewValue));
            this.validate();
            this.validateChained();
        });
        this.fParameter.valueProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            this.valueField.getStyleClass().remove((Object)".error-field");
            try {
                String textValue = DecimalFormatHelper.preformat((String)this.valueField.textProperty().get());
                if (NumberFormat.getNumberInstance().parse(textValue).doubleValue() != pNewValue.doubleValue()) {
                    this.valueField.textProperty().set((Object)String.format("%.7g", pNewValue));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (Double.isNaN(pNewValue.doubleValue())) {
                this.valueField.getStyleClass().add((Object)".error-field");
            }
        });
        this.valueField.textProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            this.fParameter.valueProperty().set((Object)DecimalFormatHelper.parseExact(pNewValue));
            this.validate();
            this.validateChained();
        });
        this.fParameter.modeProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            this.validate();
            this.validateChained();
            this.majState(this.checkBox.isSelected());
        });
        if (this.fParameter.getConstraint() != null) {
            this.fParameter.getConstraint().typeProperty().addListener((pObservable, pOldValue, pNewValue) -> this.constraintUpdated());
            this.fParameter.getConstraint().activeProperty().addListener((pObservable, pOldValue, pNewValue) -> this.constraintUpdated());
            this.fParameter.getConstraint().getParameter().valueProperty().addListener((pObservable, pOldValue, pNewValue) -> this.constraintUpdated());
            this.fParameter.getConstraint().getParameter().minProperty().addListener((pObservable, pOldValue, pNewValue) -> this.constraintUpdated());
            this.fParameter.getConstraint().getParameter().maxProperty().addListener((pObservable, pOldValue, pNewValue) -> this.constraintUpdated());
        }
        this.minField.textProperty().set((Object)String.valueOf(this.fParameter.getMin()));
        this.maxField.textProperty().set((Object)String.valueOf(this.fParameter.getMax()));
        this.valueField.textProperty().set((Object)String.valueOf(this.fParameter.getValue()));
        cbTextBox.setTextColor((Paint)this.getParamColor());
        for (Node text : this.namePane.getChildren()) {
            ((HtmlTextBox)text).setTextColor((Paint)this.getParamColor());
        }
        this.constraintUpdated();
        if (this.fParameter.isConstant()) {
            this.toLabel.setVisible(false);
            this.maxField.setVisible(false);
        }
    }

    private static void updateInstanceWidths() {
        for (ParamPaneController instance : instances) {
            if (instance.fParameter.isActivable()) {
                instance.checkBox.setPrefWidth(maxWidth + 21.0);
                instance.checkBox.setMinWidth(maxWidth + 21.0);
                continue;
            }
            instance.namePane.setPrefWidth(maxWidth);
            instance.namePane.setMinWidth(maxWidth);
        }
    }

    private void majState(boolean pChecked) {
        this.minField.setVisible(pChecked && this.fParameter.getMode() == ModeKarstMod.CALIBRATION);
        this.toLabel.setVisible(pChecked && this.fParameter.getMode() == ModeKarstMod.CALIBRATION && !this.fParameter.isConstant());
        this.maxField.setVisible(pChecked && this.fParameter.getMode() == ModeKarstMod.CALIBRATION && !this.fParameter.isConstant());
        this.valueField.setVisible(pChecked && this.fParameter.getMode() == ModeKarstMod.RUN);
        this.unitPane.setVisible(pChecked);
        this.errorImage.setOpacity(!pChecked ? 0.0 : 1.0);
        this.warningImage.setOpacity(!pChecked ? 0.0 : 1.0);
    }

    private void constraintUpdated() {
        if (this.fParameter.getConstraint() != null && this.fParameter.getConstraint().isActive()) {
            switch (this.fParameter.getConstraint().getType()) {
                case EQUAL: {
                    this.minField.setOpacity(0.0);
                    this.toLabel.setOpacity(0.0);
                    this.maxField.setOpacity(0.0);
                    this.valueField.setOpacity(0.0);
                    this.unitPane.setOpacity(0.0);
                    break;
                }
                case LESSER: {
                    this.minField.setOpacity(1.0);
                    this.toLabel.setOpacity(0.0);
                    this.maxField.setOpacity(0.0);
                    this.valueField.setOpacity(1.0);
                    this.unitPane.setOpacity(1.0);
                    break;
                }
                case GREATER: {
                    this.minField.setOpacity(0.0);
                    this.toLabel.setOpacity(1.0);
                    this.maxField.setOpacity(1.0);
                    this.valueField.setOpacity(1.0);
                    this.unitPane.setOpacity(1.0);
                }
            }
        } else {
            this.minField.setOpacity(1.0);
            this.toLabel.setOpacity(1.0);
            this.maxField.setOpacity(1.0);
            this.valueField.setOpacity(1.0);
            this.unitPane.setOpacity(1.0);
        }
        this.validate();
    }

    @Override
    public void validate() {
        MessageList msgs = this.fParameter.validate();
        this.imageTooltip.setGraphic((Node)new HtmlTextBox(msgs.toBasicString()));
        if (msgs.has(MessageType.ERROR)) {
            this.errorImage.setVisible(true);
            this.warningImage.setVisible(false);
        } else if (msgs.has(MessageType.WARNING)) {
            this.warningImage.setVisible(true);
            this.errorImage.setVisible(false);
        } else {
            this.warningImage.setVisible(false);
            this.errorImage.setVisible(false);
        }
    }

    private Color getParamColor() {
        return this.fParameter.needsCalibration() ? StylesV2.COLOR_PARAMETER_TO_CALIBRATE : StylesV2.getDefaultParamColor(this.fParameter.isSelected());
    }

    @Override
    public Node getRootNode() {
        return this.root;
    }
}

