/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.modele.Exutoire;
import fr.geonosis.karstmod.modele.IBaseElement;
import fr.geonosis.karstmod.modele.KarstModConfig;
import fr.geonosis.karstmod.modele.Model;
import fr.geonosis.karstmod.modele.ParamChoiceType;
import fr.geonosis.karstmod.modele.Reservoir;
import fr.geonosis.karstmod.viewfx.ElementPaneController;
import fr.geonosis.karstmod.viewfx.ParamPaneController;
import fr.geonosis.karstmod.viewfx.ParamPaneFactory;
import fr.geonosis.karstmod.viewfx.ReservoirPaneController;
import fr.geonosis.karstmod.viewfx.SubcatchmentsDialog;
import java.io.IOException;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;

public class ModelParamsPaneController {
    @FXML
    private VBox column1;
    @FXML
    private VBox column2;
    @FXML
    private VBox column3;
    @FXML
    private VBox column4;
    @FXML
    private VBox column5;
    @FXML
    private Pane rootPane;
    private double fWidth = 0.0;
    private VBox boxGen;
    private VBox boxRoutines;
    private Node[] reservoirPanes;

    public static ModelParamsPaneController create() throws IOException {
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(ModelParamsPaneController.class.getClassLoader());
        loader.setLocation(ModelParamsPaneController.class.getResource("ModelParamsPane.fxml"));
        loader.load();
        return (ModelParamsPaneController)loader.getController();
    }

    @FXML
    private void initialize() {
    }

    public void setConfig(KarstModConfig pConfig) throws IOException {
        Model model = pConfig.getModel();
        this.clearColumns();
        this.boxGen = new VBox();
        this.boxRoutines = new VBox();
        VBox boxRa = new VBox(5.0);
        boxRa.getStyleClass().add((Object)"model-params-block");
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(this.getClass().getClassLoader());
        loader.setLocation(ElementPaneController.class.getResource("ElementPane.fxml"));
        Node qpsBox = (Node)loader.load();
        ElementPaneController qpsPaneController = (ElementPaneController)loader.getController();
        qpsPaneController.setElement(model.getFluxQPumpS());
        boxRa.getChildren().add((Object)qpsBox);
        boxRa.getChildren().add((Object)ParamPaneFactory.createPaneController(model.getExutoire().getParameter(Exutoire.AIRE_RECHARGE), ParamChoiceType.CHECK).getRootNode());
        this.boxGen.getChildren().add((Object)boxRa);
        this.reservoirPanes = new Node[model.getReservoirs().length];
        int i = 0;
        for (Reservoir reservoir : model.getReservoirs()) {
            loader = new FXMLLoader();
            loader.setClassLoader(this.getClass().getClassLoader());
            loader.setLocation(ReservoirPaneController.class.getResource("ReservoirPane.fxml"));
            this.reservoirPanes[i] = (Node)loader.load();
            ReservoirPaneController reservoirPaneController = (ReservoirPaneController)loader.getController();
            reservoirPaneController.setReservoir(reservoir);
            this.hideIfNotSelected(this.reservoirPanes[i], reservoir);
            ++i;
        }
        loader = new FXMLLoader();
        loader.setClassLoader(this.getClass().getClassLoader());
        loader.setLocation(ParamPaneController.class.getResource("ElementPane.fxml"));
        Node eltBox = (Node)loader.load();
        ElementPaneController eltPaneController = (ElementPaneController)loader.getController();
        eltPaneController.setElement(model.getPetRoutine(), "PET routine ");
        VBox boxPet = new VBox(5.0);
        boxPet.getStyleClass().add((Object)"model-params-block");
        boxPet.getChildren().add((Object)eltBox);
        boxPet.getChildren().add((Object)eltPaneController.getParamsBox());
        this.hideIfNotSelected((Node)boxPet, model.getPetRoutine());
        this.boxRoutines.getChildren().add((Object)boxPet);
        loader = new FXMLLoader();
        loader.setClassLoader(this.getClass().getClassLoader());
        loader.setLocation(ParamPaneController.class.getResource("ElementPane.fxml"));
        eltBox = (Node)loader.load();
        eltPaneController = (ElementPaneController)loader.getController();
        eltPaneController.setElement(model.getSnowRoutine(), "Snow routine ");
        VBox boxSnow = new VBox(5.0);
        boxSnow.getStyleClass().add((Object)"model-params-block");
        boxSnow.getChildren().add((Object)eltBox);
        HBox boxSubCatchments = new HBox(5.0);
        boxSubCatchments.paddingProperty().set((Object)new Insets(0.0, 0.0, 0.0, 15.0));
        CheckBox cbSubcatchments = new CheckBox("Subcatchments (" + model.getSnowRoutine().getSubcatchmentTable().size() + ")");
        boxSubCatchments.setAlignment(Pos.BASELINE_LEFT);
        boxSubCatchments.getChildren().add((Object)cbSubcatchments);
        Button btSubCatchments = new Button("...");
        btSubCatchments.setOnAction(e -> SubcatchmentsDialog.getInstance().showDialog(model.getSnowRoutine()));
        btSubCatchments.setDisable(!model.getSnowRoutine().getSubcatchmentTable().activeProperty().get());
        boxSubCatchments.getChildren().add((Object)btSubCatchments);
        boxSnow.getChildren().add((Object)boxSubCatchments);
        boxSnow.getChildren().add((Object)eltPaneController.getParamsBox());
        this.hideIfNotSelected((Node)boxSnow, model.getSnowRoutine());
        this.boxRoutines.getChildren().add((Object)boxSnow);
        cbSubcatchments.selectedProperty().bindBidirectional((Property)model.getSnowRoutine().getSubcatchmentTable().activeProperty());
        model.getSnowRoutine().getSubcatchmentTable().addListener(e -> Platform.runLater(() -> {
            cbSubcatchments.setText("Subcatchments (" + model.getSnowRoutine().getSubcatchmentTable().size() + ")");
            btSubCatchments.setDisable(!model.getSnowRoutine().getSubcatchmentTable().activeProperty().get());
        }));
        Platform.runLater(this::widthChanged);
        this.setColumnsNumber(2);
    }

    private void hideIfNotSelected(Node pNode, IBaseElement pElt) {
        pNode.managedProperty().bindBidirectional((Property)pNode.visibleProperty());
        pNode.visibleProperty().bind((ObservableValue)pElt.activeProperty());
    }

    private void clearColumns() {
        this.column1.getChildren().clear();
        this.column2.getChildren().clear();
        this.column3.getChildren().clear();
        this.column4.getChildren().clear();
    }

    public void setColumnsNumber(int pNbCols) {
        this.clearColumns();
        switch (pNbCols) {
            case 2: {
                this.column1.getChildren().addAll((Object[])new Node[]{this.reservoirPanes[0], this.reservoirPanes[1]});
                this.column2.getChildren().addAll((Object[])new Node[]{this.reservoirPanes[2], this.reservoirPanes[3], this.boxGen, this.boxRoutines});
                break;
            }
            case 5: {
                this.column1.getChildren().add((Object)this.reservoirPanes[0]);
                this.column2.getChildren().addAll((Object[])new Node[]{this.reservoirPanes[1], this.boxGen});
                this.column3.getChildren().add((Object)this.reservoirPanes[2]);
                this.column4.getChildren().add((Object)this.reservoirPanes[3]);
                this.column5.getChildren().add((Object)this.boxRoutines);
            }
        }
    }

    public void widthChanged() {
        if (this.column1.getWidth() > this.fWidth) {
            this.fWidth = this.column1.getWidth();
            AnchorPane.setLeftAnchor((Node)this.column2, (Double)(this.fWidth + 20.0));
            AnchorPane.setRightAnchor((Node)this.column1, (Double)(this.fWidth + 20.0));
        }
    }

    public Pane getRootPane() {
        return this.rootPane;
    }
}

