/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.modele.AbstractElement;
import fr.geonosis.karstmod.modele.ParamChoiceType;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.viewfx.ParamPaneFactory;
import fr.geonosis.karstmod.viewfx.StylesV2;
import fr.geonosis.karstmod.viewfx.utils.HtmlTextBox;
import fr.geonosis.karstmod.viewfx.utils.MyTooltip;
import java.io.IOException;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;

public class ElementPaneController {
    @FXML
    private CheckBox checkBox;
    @FXML
    private HBox hBox;
    @FXML
    private HBox labelBox;
    @FXML
    private Pane namePane;
    @FXML
    private ImageView errorImage;
    @FXML
    private ImageView warningImage;
    private Pane paramsBox;
    private AbstractElement fElement;
    private InvalidationListener fListenerRadio;
    private final Pane emptyPane = new Pane();
    private HtmlTextBox cbTextBox;

    @FXML
    private void initialize() {
        MyTooltip imageTooltip = new MyTooltip(null, 0.0, 60000.0, 200.0);
        Tooltip.install((Node)this.errorImage, (Tooltip)imageTooltip);
        Tooltip.install((Node)this.warningImage, (Tooltip)imageTooltip);
        this.errorImage.managedProperty().bind((ObservableValue)this.errorImage.visibleProperty());
        this.warningImage.managedProperty().bind((ObservableValue)this.warningImage.visibleProperty());
        this.warningImage.setVisible(false);
        this.errorImage.setVisible(false);
    }

    public void setElement(AbstractElement pElement) throws IOException {
        this.setElement(pElement, pElement.getHtmlLabel());
    }

    public void setElement(AbstractElement pElement, String pHtmlLabel) throws IOException {
        this.fElement = pElement;
        this.paramsBox = null;
        if (!this.fElement.isActivable() && this.fElement.getParameters().size() == 1 && !this.fElement.getParameters().get(0).hasValue()) {
            this.labelBox.setVisible(false);
            return;
        }
        this.paramsBox = new VBox(0.0);
        this.labelBox.managedProperty().bind((ObservableValue)this.labelBox.visibleProperty());
        this.paramsBox.managedProperty().bind((ObservableValue)this.paramsBox.visibleProperty());
        this.cbTextBox = new HtmlTextBox(pHtmlLabel);
        this.cbTextBox.setTranslateX(5.0);
        this.cbTextBox.setTextColor((Paint)StylesV2.getDefaultParamColor(this.fElement.isSelected()));
        HtmlTextBox textBox = new HtmlTextBox(pHtmlLabel);
        textBox.setTranslateX(5.0);
        this.namePane.getChildren().add((Object)textBox);
        double w = textBox.getComputedWidth();
        this.namePane.setPrefWidth(w + 10.0);
        this.namePane.setMinWidth(w + 10.0);
        this.namePane.managedProperty().bind((ObservableValue)this.namePane.visibleProperty());
        this.fElement.showLabelProperty().addListener((pObservable, pOldValue, pNewValue) -> this.majVisibility());
        this.checkBox.selectedProperty().bindBidirectional((Property)this.fElement.selectedProperty());
        this.fElement.activeProperty().addListener((observable, oldValue, newValue) -> this.majVisibility());
        this.fElement.getParentsHandler().addActiveListener(observable -> this.majVisibility());
        this.fElement.activableProperty().addListener((observable, oldValue, newValue) -> this.majVisibility());
        this.fElement.selectedProperty().addListener((observable, oldValue, newValue) -> this.cbTextBox.setTextColor((Paint)StylesV2.getDefaultParamColor(this.fElement.isSelected())));
        this.majVisibility();
        ParamPaneFactory.createAll(this.paramsBox, this.fElement, true);
        if (!this.fElement.activeProperty().get() && this.fElement.getParamChoiceType() == ParamChoiceType.RADIO) {
            this.fListenerRadio = pObservable -> {
                int n = 0;
                for (Parameter pp : this.fElement.getParameters()) {
                    if (!pp.getParentsHandler().isActive()) continue;
                    ++n;
                }
                this.labelBox.setVisible(n > 1);
                this.paramsBox.setVisible(n > 1);
            };
            for (Parameter p : this.fElement.getParameters()) {
                p.getParentsHandler().addActiveListener(this.fListenerRadio);
            }
            this.fListenerRadio.invalidated(null);
        } else {
            this.fListenerRadio = pObservable -> {
                int n = 0;
                for (Parameter pp : this.fElement.getParameters()) {
                    if (!pp.getParentsHandler().isActive()) continue;
                    ++n;
                }
                this.labelBox.setVisible(n > 0 || this.fElement.isAlwaysVisible());
                this.paramsBox.setVisible(n > 0 || this.fElement.isAlwaysVisible());
            };
            for (Parameter p : this.fElement.getParameters()) {
                p.activeProperty().addListener(this.fListenerRadio);
            }
            this.fListenerRadio.invalidated(null);
        }
    }

    private void majVisibility() {
        this.checkBox.setVisible(this.fElement.isActivable());
        if (this.fElement.isActivable()) {
            this.checkBox.setGraphic((Node)this.cbTextBox);
            double w = ((HtmlTextBox)this.checkBox.getGraphic()).getComputedWidth();
            this.checkBox.setPrefWidth(w + 24.0);
            this.checkBox.setMinWidth(w + 24.0);
        } else {
            this.checkBox.setPrefWidth(16.0);
            this.checkBox.setMinWidth(16.0);
            this.checkBox.setGraphic((Node)this.emptyPane);
        }
        this.namePane.setVisible(!this.fElement.isActivable());
        this.paramsBox.setVisible(this.fElement.isActive());
        this.labelBox.setVisible(this.fElement.isActive() && this.fElement.isShowLabel());
    }

    public Node getLabelBox() {
        return this.labelBox;
    }

    public Node getParamsBox() {
        return this.paramsBox;
    }
}

