/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.utils.csv.parser;

import fr.geonosis.karstmod.utils.csv.parser.DataParseException;
import fr.geonosis.karstmod.utils.csv.parser.IColumnType;

public class DoubleType
implements IColumnType<Double> {
    private static final DoubleType instance = new DoubleType();

    private DoubleType() {
    }

    public static DoubleType getInstance() {
        return instance;
    }

    @Override
    public Double parse(String pValue) throws DataParseException {
        if (pValue.isBlank()) {
            return null;
        }
        try {
            return Double.parseDouble(pValue.trim().replace(',', '.'));
        }
        catch (NumberFormatException e) {
            throw new DataParseException("bad numeric format for input " + pValue);
        }
    }

    @Override
    public String format(Double pValue) {
        if (pValue == null) {
            return "";
        }
        if (Double.isInfinite(pValue)) {
            return "\u221e";
        }
        if (Double.isNaN(pValue)) {
            return "NaN";
        }
        return String.format("%f", pValue);
    }

    @Override
    public void reset() {
    }
}

