/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.utils.csv;

import fr.geonosis.karstmod.utils.csv.Column;
import fr.geonosis.karstmod.utils.csv.DataColumnException;
import fr.geonosis.karstmod.utils.csv.IntRange;
import fr.geonosis.karstmod.utils.csv.parser.DataParseException;
import fr.geonosis.karstmod.utils.csv.parser.IColumnType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class DataColumn<T> {
    private static final String GAPS_ID = UUID.randomUUID().toString();
    private final Column<T> fColumn;
    private final int fIndex;
    private final List<T> fData;
    private final Map<String, LinkedList<IntRange>> fIndexedValuesMap;

    DataColumn(Column<T> pColumn, int pIndex) {
        if (Objects.isNull(pColumn)) {
            throw new IllegalArgumentException("Column cannot be null");
        }
        if (pIndex < 0) {
            throw new IllegalArgumentException("Index must be positive or nul");
        }
        this.fIndex = pIndex;
        this.fColumn = pColumn;
        this.fData = new ArrayList<T>();
        this.fIndexedValuesMap = new HashMap<String, LinkedList<IntRange>>();
        this.fIndexedValuesMap.put(GAPS_ID, new LinkedList());
        for (String val : this.fColumn.getIndexedValues()) {
            this.fIndexedValuesMap.put(val, new LinkedList());
        }
        IColumnType<T> dt = pColumn.getDataType();
    }

    DataColumn(Column<T> pColumn, int pIndex, T[] pValues) {
        this(pColumn, pIndex, pValues == null ? new ArrayList() : Arrays.asList(pValues));
    }

    DataColumn(Column<T> pColumn, int pIndex, List<T> pValues) {
        if (Objects.isNull(pColumn)) {
            throw new IllegalArgumentException("Column cannot be null");
        }
        if (pIndex < 0) {
            throw new IllegalArgumentException("Index must be positive or nul");
        }
        this.fIndex = pIndex;
        this.fColumn = pColumn;
        this.fData = pValues == null ? new ArrayList() : pValues;
        this.fIndexedValuesMap = new HashMap<String, LinkedList<IntRange>>();
        this.fIndexedValuesMap.put(GAPS_ID, new LinkedList());
        for (String val : this.fColumn.getIndexedValues()) {
            this.fIndexedValuesMap.put(val, new LinkedList());
        }
    }

    void add(String pValue) throws DataColumnException {
        if (pValue.isBlank()) {
            this.addCurrentIndex(GAPS_ID);
            return;
        }
        for (String val : this.fIndexedValuesMap.keySet()) {
            if (!val.equalsIgnoreCase(pValue)) continue;
            this.addCurrentIndex(val);
            return;
        }
        try {
            this.fData.add(this.fColumn.getDataType().parse(pValue));
        }
        catch (DataParseException e) {
            throw new DataColumnException(e.getMessage() + " in column " + this.getColumn().getName());
        }
    }

    private void addCurrentIndex(String pName) {
        int index = this.fData.size();
        LinkedList<IntRange> rangeList = this.fIndexedValuesMap.get(pName);
        if (rangeList.isEmpty()) {
            rangeList.add(new IntRange(index, index));
        } else {
            IntRange lastRange = rangeList.getLast();
            if (lastRange.max() == index - 1) {
                rangeList.pollLast();
                rangeList.add(lastRange.extend());
            } else {
                rangeList.add(new IntRange(index, index));
            }
        }
        this.fData.add(null);
    }

    public List<T> getValues() {
        return Collections.unmodifiableList(this.fData);
    }

    public List<IntRange> getIndices4(String pValue) {
        ArrayList list = (ArrayList)((Object)this.fIndexedValuesMap.get(pValue));
        if (Objects.isNull(list)) {
            list = new ArrayList();
        }
        return Collections.unmodifiableList(list);
    }

    public List<IntRange> getGapsIndices() {
        return Collections.unmodifiableList((List)this.fIndexedValuesMap.get(GAPS_ID));
    }

    public Column<T> getColumn() {
        return this.fColumn;
    }

    public int getIndex() {
        return this.fIndex;
    }
}

