/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.utils.csv;

import fr.geonosis.karstmod.utils.csv.CSVException;
import fr.geonosis.karstmod.utils.csv.Column;
import fr.geonosis.karstmod.utils.csv.DataColumn;
import fr.geonosis.karstmod.utils.csv.DataColumnException;
import fr.geonosis.karstmod.utils.csv.DataColumnFactory;
import fr.geonosis.karstmod.utils.csv.DataColumnMap;
import fr.geonosis.karstmod.utils.csv.LoadException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;

public class CSVLoader {
    public static DataColumnMap load(String pFilename, Charset pCharset, String pSeparator, String pComment, Set<Column<?>> pColumns) throws CSVException, LoadException, IOException {
        if (Objects.isNull(pFilename)) {
            throw new IllegalArgumentException("fileName cannot be null");
        }
        return CSVLoader.load(new FileInputStream(pFilename), pFilename, pCharset, pSeparator, pComment, pColumns);
    }

    public static DataColumnMap load(InputStream pInputStream, String pFilename, Charset pCharset, String pSeparator, String pComment, Set<Column<?>> pColumns) throws CSVException, LoadException, IOException {
        if (Objects.isNull(pCharset)) {
            throw new IllegalArgumentException("charset cannot be null");
        }
        if (Objects.isNull(pSeparator)) {
            throw new IllegalArgumentException("separator cannot be null");
        }
        if (Objects.isNull(pComment)) {
            throw new IllegalArgumentException("comment sequence cannot be null");
        }
        HashMap map = new HashMap();
        try (LineNumberReader br = new LineNumberReader(new InputStreamReader(pInputStream, pCharset));){
            String line;
            while ((line = br.readLine()) != null && (line.replaceAll(pSeparator, "").isBlank() || line.trim().startsWith(pComment))) {
            }
            if (line == null) {
                DataColumnMap dataColumnMap = DataColumnMap.emptyMap();
                return dataColumnMap;
            }
            String[] titles = line.trim().split(pSeparator);
            ArrayList dataColumns = new ArrayList();
            ArrayList<Integer> colIndices = new ArrayList<Integer>();
            block11: for (int i = 0; i < titles.length; ++i) {
                String title = titles[i].trim().toUpperCase();
                for (Column<?> column : pColumns) {
                    if (!title.equalsIgnoreCase(column.getName())) continue;
                    for (DataColumn dataColumn : dataColumns) {
                        if (!dataColumn.getColumn().getName().equalsIgnoreCase(column.getName())) continue;
                        throw new CSVException("More than one column named " + column.getName(), br.getLineNumber(), pFilename);
                    }
                    dataColumns.add(DataColumnFactory.createDataColumn(column, i));
                    colIndices.add(i);
                    continue block11;
                }
            }
            if (colIndices.isEmpty()) {
                DataColumnMap i = DataColumnMap.emptyMap();
                return i;
            }
            try {
                while ((line = br.readLine()) != null) {
                    if (line.trim().startsWith(pComment) || line.isBlank()) continue;
                    String[] values = line.split(pSeparator);
                    if (values.length < dataColumns.size()) {
                        throw new CSVException("missing column", br.getLineNumber(), pFilename);
                    }
                    for (int i = 0; i < dataColumns.size(); ++i) {
                        ((DataColumn)dataColumns.get(i)).add(values[(Integer)colIndices.get(i)]);
                    }
                }
            }
            catch (DataColumnException e) {
                throw new CSVException(e.getMessage(), br.getLineNumber(), pFilename);
            }
            catch (Exception e) {
                throw new LoadException(e.getMessage());
            }
            for (DataColumn dataColumn : dataColumns) {
                map.put(dataColumn.getColumn().getName(), dataColumn);
            }
        }
        return DataColumnMap.of(map);
    }
}

