/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run.routine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

public class SubcatchmentTable
implements Observable {
    public static final String TEMP_SHIFT = "tempShift";
    public static final String PROPORTION = "proportion";
    public static final String ACTIVE = "active";
    private final List<InvalidationListener> fListeners = new ArrayList<InvalidationListener>();
    private final BooleanProperty fActiveProperty = new SimpleBooleanProperty(true);
    private Row[] fRows;

    public SubcatchmentTable() {
        this.fActiveProperty.addListener((ob, o, n) -> this.fireChanged());
    }

    public void setRows(Row ... pRows) {
        if (pRows == null || pRows.length == 0) {
            this.fRows = null;
        } else {
            double propSum = Arrays.stream(pRows).mapToDouble(v -> v.proportion()).sum();
            if (Math.abs(propSum - 1.0) > 1.0E-5) {
                throw new UnsupportedOperationException("Sum of proportion is " + propSum + ". It must be equal to 1");
            }
            this.fRows = (Row[])pRows.clone();
        }
        this.fireChanged();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.activeProperty().get() ? (this.fRows == null ? 0 : this.fRows.length) : 0;
    }

    public double getProportion(int i) {
        return this.fRows[i].proportion();
    }

    public double getTempShift(int i) {
        return this.fRows[i].tempShift();
    }

    private String getPrefixe(String pPrefixe, int pIndice) {
        return pPrefixe + "Snow_routine.subcatchment." + pIndice + ".";
    }

    private String getPrefixe(String pPrefixe) {
        return pPrefixe + "Snow_routine.subcatchment.";
    }

    public void save(Properties pProperties, String pPrefixe) {
        pProperties.put(this.getPrefixe(pPrefixe) + ACTIVE, String.valueOf(this.activeProperty().get()));
        if (this.fRows != null && this.fRows.length > 0) {
            for (int i = 0; i < this.fRows.length; ++i) {
                String prefixe = this.getPrefixe(pPrefixe, i + 1);
                pProperties.put(prefixe + PROPORTION, String.valueOf(this.fRows[i].proportion()));
                pProperties.put(prefixe + TEMP_SHIFT, String.valueOf(this.fRows[i].tempShift()));
            }
        }
    }

    public void load(Properties pProperties, String pPrefixe) {
        this.fActiveProperty.set(Boolean.parseBoolean(pProperties.getProperty(this.getPrefixe(pPrefixe) + ACTIVE, "true")));
        int n = 0;
        while (pProperties.containsKey(this.getPrefixe(pPrefixe, ++n) + PROPORTION)) {
        }
        if (--n == 0) {
            this.fRows = null;
            this.fireChanged();
        } else {
            Row[] rows = new Row[n];
            for (int i = 1; i <= n; ++i) {
                String prefixe = this.getPrefixe(pPrefixe, i);
                rows[i - 1] = new Row(Double.parseDouble(pProperties.getProperty(prefixe + PROPORTION)), Double.parseDouble(pProperties.getProperty(prefixe + TEMP_SHIFT)));
            }
            this.setRows(rows);
        }
    }

    public void addListener(InvalidationListener pListener) {
        this.fListeners.add(pListener);
    }

    public void removeListener(InvalidationListener pListener) {
        this.fListeners.remove(pListener);
    }

    protected void fireChanged() {
        for (InvalidationListener listener : this.fListeners) {
            listener.invalidated((Observable)this);
        }
    }

    public BooleanProperty activeProperty() {
        return this.fActiveProperty;
    }

    public static class Row {
        private final double proportion;
        private final double tempShift;

        public Row(double pProportion, double pTempShift) {
            this.proportion = pProportion;
            this.tempShift = pTempShift;
        }

        public double proportion() {
            return this.proportion;
        }

        public double tempShift() {
            return this.tempShift;
        }
    }
}

