/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run.routine;

import fr.geonosis.karstmod.run.routine.PETOudin;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;

public class PETOudinHourly
extends PETOudin {
    private final double[] pdf;
    private final double[] raDivByLe;
    private final double[] tMean;
    private int nbDays;

    public PETOudinHourly(List<ZonedDateTime> pDateTimes, double[] pTemperatures, double pLatitude) {
        super(pDateTimes, pTemperatures, pLatitude);
        int estimatedNbDays = this.dateTimes.size() / 24 + 2;
        ArrayList<ZonedDateTime> days = new ArrayList<ZonedDateTime>(estimatedNbDays);
        this.tMean = new double[estimatedNbDays];
        double[] hMax = new double[estimatedNbDays];
        ZonedDateTime currentDay = (ZonedDateTime)this.dateTimes.get(0);
        double dailytMax = this.temperatures[0];
        double dailyHMax = currentDay.getHour();
        double dailySum = this.temperatures[0];
        double dailyNum = 1.0;
        this.nbDays = 0;
        for (int i = 1; i < this.dateTimes.size(); ++i) {
            double t;
            if (((ZonedDateTime)this.dateTimes.get(i)).getDayOfYear() != currentDay.getDayOfYear()) {
                days.add(currentDay);
                hMax[this.nbDays] = dailyHMax;
                this.tMean[this.nbDays] = dailySum / dailyNum;
                ++this.nbDays;
                dailySum = 0.0;
                dailyNum = 0.0;
                currentDay = (ZonedDateTime)this.dateTimes.get(i);
                dailytMax = -1.7976931348623157E308;
            }
            if ((t = this.temperatures[i]) > dailytMax) {
                dailytMax = t;
                dailyHMax = ((ZonedDateTime)this.dateTimes.get(i)).getHour();
            }
            dailySum += t;
            dailyNum += 1.0;
        }
        days.add(currentDay);
        hMax[this.nbDays] = dailyHMax;
        this.tMean[this.nbDays] = dailySum / dailyNum;
        ++this.nbDays;
        double mu = 0.0;
        for (int i = 0; i < this.nbDays; ++i) {
            mu += hMax[i];
        }
        mu /= (double)this.nbDays;
        double sigma = 0.0;
        for (int i = 0; i < this.nbDays; ++i) {
            double dd = hMax[i] - mu;
            sigma += dd * dd;
        }
        sigma = Math.sqrt(sigma / (double)(this.nbDays - 1)) / 2.0;
        this.pdf = new double[24];
        double deuxSigma2 = 2.0 * sigma * sigma;
        double c = 1.0 / (sigma * Math.sqrt(Math.PI * 2));
        for (int i = 0; i < 24; ++i) {
            double imm = (double)i - mu;
            this.pdf[i] = c * Math.exp(-(imm * imm) / deuxSigma2);
        }
        this.raDivByLe = new double[this.nbDays];
        double latrad = Math.toRadians(this.latitude);
        double Gsc = 0.082;
        double dh = 458.3662361046586;
        for (int i = 0; i < this.raDivByLe.length; ++i) {
            double yday = ((ZonedDateTime)days.get(i)).getDayOfYear();
            double ydayRad = Math.PI * 2 * yday / 365.0;
            double dr = 1.0 + 0.033 * Math.cos(ydayRad);
            double d = 0.409 * Math.sin(ydayRad - 1.39);
            double ws = Math.acos(-Math.tan(latrad) * Math.tan(d));
            double Ra = dh * Gsc * dr * (ws * Math.sin(latrad) * Math.sin(d) + Math.cos(latrad) * Math.cos(d) * Math.sin(ws));
            double le = 2.501 - 0.002361 * this.tMean[i];
            this.raDivByLe[i] = Ra / le;
        }
    }

    @Override
    public double[] compute(double k1, double k2) {
        double[] pet = new double[this.dateTimes.size()];
        double[] daily = new double[this.nbDays];
        for (int i = 0; i < this.nbDays; ++i) {
            double tk2 = this.tMean[i] + k2;
            daily[i] = tk2 > 0.0 ? this.raDivByLe[i] * (tk2 / k1) : 0.0;
        }
        ZonedDateTime debut = (ZonedDateTime)this.dateTimes.get(0);
        for (int i = 0; i < pet.length; ++i) {
            int iDaily = (int)((ZonedDateTime)this.dateTimes.get(0)).until((Temporal)this.dateTimes.get(i), ChronoUnit.DAYS);
            pet[i] = daily[iDaily] * this.pdf[((ZonedDateTime)this.dateTimes.get(i)).getHour()];
        }
        return pet;
    }
}

