/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run.model;

import fr.geonosis.karstmod.modele.BaseUnit;
import fr.geonosis.karstmod.modele.ColumnName;
import fr.geonosis.karstmod.modele.InputData;
import fr.geonosis.karstmod.modele.Model;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterConstraintType;
import fr.geonosis.karstmod.modele.StageBounds;
import fr.geonosis.karstmod.modele.Unit;
import fr.geonosis.karstmod.modele.obj.parser.Varname;
import fr.geonosis.karstmod.modele.reservoirconfig.ClassicalReservoirConfig;
import fr.geonosis.karstmod.modele.reservoirconfig.InfiniteTcReservoirConfig;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfig;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfigType;
import fr.geonosis.karstmod.run.model.IResolE;
import fr.geonosis.karstmod.run.model.KarstModResol;
import fr.geonosis.karstmod.run.model.ResolAnalytiqueResE;
import fr.geonosis.karstmod.run.model.ResolLineariseeResE;
import fr.geonosis.karstmod.run.model.RunModelData;
import fr.geonosis.karstmod.run.model.RunModelParameters;
import fr.geonosis.karstmod.run.model.RunModelStructure;
import fr.geonosis.karstmod.run.model.RunResult;
import fr.geonosis.karstmod.run.model.paramvalue.ParamValue;
import fr.geonosis.karstmod.run.model.paramvalue.ParamValueFactory;
import fr.geonosis.karstmod.run.routine.HbvSnowRoutine;
import fr.geonosis.karstmod.run.routine.PETOudin;
import fr.geonosis.karstmod.run.routine.PETOudinDaily;
import fr.geonosis.karstmod.run.routine.PETOudinHourly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RunModel {
    public static final double DT = 1.0;
    final RunModelParameters fParams;
    final RunModelStructure fStructure;
    private final ParamValue paramE0;
    private final ParamValue paramEmin;
    private final ParamValue paramL0;
    private final ParamValue paramM0;
    private final ParamValue paramC0;
    private final ParamValue paramkEL;
    private final ParamValue paramalphaEL;
    private final ParamValue paramkloss;
    private final ParamValue paramEloss;
    private final ParamValue paramalphaloss;
    private final ParamValue paramxloss;
    private final ParamValue paramxc;
    private final ParamValue paramkES;
    private final ParamValue paramalphaES;
    private final ParamValue paramkhy;
    private final ParamValue paramEhy;
    private final ParamValue paramDhy;
    private final ParamValue paramalphahy;
    private final ParamValue paramxhy;
    private final ParamValue paramkE;
    private final ParamValue paramalphaELinked;
    private final ParamValue paramkEC;
    private final ParamValue paramalphaEC;
    private final ParamValue paramxEM;
    private final ParamValue paramxEC;
    private final ParamValue paramkEM;
    private final ParamValue paramalphaEM;
    private final ParamValue paramkMC;
    private final ParamValue paramalphaMC;
    private final ParamValue paramkLS;
    private final ParamValue paramalphaLS;
    private final ParamValue paramkMS;
    private final ParamValue paramalphaMS;
    private final ParamValue paramkCS;
    private final ParamValue paramalphaCS;
    private final ParamValue paramalphaE;
    private final ParamValue paramTau0E;
    private final ParamValue paramhminE;
    private final ParamValue paramhmaxE;
    private final ParamValue paramalphaL;
    private final ParamValue paramTau0L;
    private final ParamValue paramhmaxL;
    private final ParamValue paramalphaM;
    private final ParamValue paramTau0M;
    private final ParamValue paramhmaxM;
    private final ParamValue paramalphaC;
    private final ParamValue paramTau0C;
    private final ParamValue paramhmaxC;
    private final ParamValue paramRA;
    private final ParamValue paramwE;
    private final ParamValue paramwL;
    private final ParamValue paramwM;
    private final ParamValue paramwC;
    private final ParamValue paramZ0E;
    private final ParamValue paramZ0L;
    private final ParamValue paramZ0M;
    private final ParamValue paramZ0C;
    private final ParamValue paramK1;
    private final ParamValue paramK2;
    private final ParamValue paramTs;
    private final ParamValue paramMF;
    private final ParamValue paramCFR;
    private final ParamValue paramCWH;
    private final ParamValue paramRc;
    private final Model fModel;
    private final boolean fCalcZE;
    private final boolean fCalcZL;
    private final boolean fCalcZM;
    private final boolean fCalcZC;
    private final Map<String, ParamValue> activeParams;
    private final ArrayList<ParamValue> initParams;
    private final ArrayList<ParamValue> valueParams;
    private final InputData fInputData;
    private final StageBounds fGlobalStage;
    private RunModelData fData;
    private final HbvSnowRoutine fHbvSnowRoutine;
    private final PETOudin fPetOudin;
    private final boolean fPetRoutineNeedsCalibration;
    private final boolean fSnowRoutineNeedsCalibration;
    private double[] fLastPET;
    private HbvSnowRoutine.Output fLastSnowRoutineOutput;

    public RunModel(Model pModel, InputData pInputData, StageBounds pGlobalStage) {
        this.fInputData = pInputData;
        this.fGlobalStage = pGlobalStage;
        this.fModel = pModel;
        this.fStructure = new RunModelStructure(pModel);
        this.fParams = new RunModelParameters();
        this.fParams.ios = pInputData.getIOShift();
        this.fParams.dt = 1.0;
        this.fCalcZE = this.fModel.getReservoirE().isActive() && this.fModel.getReservoirE().getPiezo().isActive();
        this.fCalcZL = this.fModel.getReservoirL().isActive() && this.fModel.getReservoirL().getPiezo().isActive();
        this.fCalcZM = this.fModel.getReservoirM().isActive() && this.fModel.getReservoirM().getPiezo().isActive();
        this.fCalcZC = this.fModel.getReservoirC().isActive() && this.fModel.getReservoirC().getPiezo().isActive();
        this.activeParams = new HashMap<String, ParamValue>();
        this.initParams = new ArrayList();
        this.valueParams = new ArrayList();
        this.paramE0 = this.addActiveParam(this.fModel.getReservoirE().getH0());
        this.paramEmin = this.addActiveParam(((ClassicalReservoirConfig)this.fModel.getReservoirE().getConfig(ReservoirConfigType.CLASSICAL)).getHmin(), this.paramE0, ParameterConstraintType.LESSER);
        this.paramkloss = this.addActiveParam(this.fModel.getQloss().getParameter("k"));
        this.paramEloss = this.addActiveParam(this.fModel.getQloss().getParameter("threshold"));
        this.paramalphaloss = this.addActiveParam(this.fModel.getQloss().getParameter("alpha"));
        this.paramxloss = this.addActiveParam(this.fModel.getQrE().getParameter("xLoss"));
        this.paramxc = this.addActiveParam(this.fModel.getQrE().getParameter("xc"));
        this.paramkEL = this.addActiveParam(this.fModel.getQEL().getParameter("k"));
        this.paramalphaEL = this.addActiveParam(this.fModel.getQEL().getParameter("alpha"));
        this.paramxEM = this.addActiveParam(this.fModel.getReservoirE().getConfig(ReservoirConfigType.CLASSICAL).getParameter("xEM"));
        this.paramkEM = this.addActiveParam(this.fModel.getQEM().getParameter("k"));
        this.paramalphaEM = this.addActiveParam(this.fModel.getQEM().getParameter("alpha"));
        this.paramkE = this.addActiveParam(this.fModel.getReservoirE().getConfig(ReservoirConfigType.CLASSICAL).getParameter("k"));
        this.paramalphaELinked = this.addActiveParam(this.fModel.getReservoirE().getConfig(ReservoirConfigType.CLASSICAL).getParameter("alpha"));
        this.paramxEC = this.addActiveParam(this.fModel.getReservoirE().getConfig(ReservoirConfigType.CLASSICAL).getParameter("xEC"));
        this.paramkEC = this.addActiveParam(this.fModel.getQEC().getParameter("k"));
        this.paramalphaEC = this.addActiveParam(this.fModel.getQEC().getParameter("alpha"));
        this.paramkES = this.addActiveParam(this.fModel.getQES().getParameter("k"));
        this.paramalphaES = this.addActiveParam(this.fModel.getQES().getParameter("alpha"));
        this.paramkhy = this.addActiveParam(this.fModel.getQhy().getParameter("k"));
        this.paramEhy = this.addActiveParam(this.fModel.getQhy().getParameter("E"));
        this.paramDhy = this.addActiveParam(this.fModel.getQhy().getParameter("DE"));
        this.paramalphahy = this.addActiveParam(this.fModel.getQhy().getParameter("alpha"));
        this.paramxhy = this.addActiveParam(this.fModel.getQhyEC().getParameter("xhy"));
        this.paramL0 = this.addActiveParam(this.fModel.getReservoirL().getH0());
        this.paramkLS = this.addActiveParam(this.fModel.getQLS().getParameter("k"));
        this.paramalphaLS = this.addActiveParam(this.fModel.getQLS().getParameter("alpha"));
        this.paramM0 = this.addActiveParam(this.fModel.getReservoirM().getH0());
        this.paramkMS = this.addActiveParam(this.fModel.getQMS().getParameter("k"));
        this.paramalphaMS = this.addActiveParam(this.fModel.getQMS().getParameter("alpha"));
        this.paramkMC = this.addActiveParam(this.fModel.getQMC().getParameter("k"));
        this.paramalphaMC = this.addActiveParam(this.fModel.getQMC().getParameter("alpha"));
        this.paramC0 = this.addActiveParam(this.fModel.getReservoirC().getH0());
        this.paramkCS = this.addActiveParam(this.fModel.getQCS().getParameter("k"));
        this.paramalphaCS = this.addActiveParam(this.fModel.getQCS().getParameter("alpha"));
        this.paramRA = ParamValueFactory.create(this.fModel.getExutoire().getParameter("RA"));
        this.activeParams.put(this.fModel.getExutoire().getParameter("RA").columnTitle(), this.paramRA);
        this.paramwE = this.addActiveParam(this.fModel.getReservoirE().getPiezo().getParameter("w"));
        this.paramZ0E = this.addActiveParam(this.fModel.getReservoirE().getPiezo().getParameter("Z0"));
        this.paramwL = this.addActiveParam(this.fModel.getReservoirL().getPiezo().getParameter("w"));
        this.paramZ0L = this.addActiveParam(this.fModel.getReservoirL().getPiezo().getParameter("Z0"));
        this.paramwM = this.addActiveParam(this.fModel.getReservoirM().getPiezo().getParameter("w"));
        this.paramZ0M = this.addActiveParam(this.fModel.getReservoirM().getPiezo().getParameter("Z0"));
        this.paramwC = this.addActiveParam(this.fModel.getReservoirC().getPiezo().getParameter("w"));
        this.paramZ0C = this.addActiveParam(this.fModel.getReservoirC().getPiezo().getParameter("Z0"));
        InfiniteTcReservoirConfig tcinfE = (InfiniteTcReservoirConfig)this.fModel.getReservoirE().getConfig(ReservoirConfigType.INFINITE_TC);
        this.paramalphaE = this.addActiveParam(tcinfE.getAlpha());
        this.paramTau0E = this.addActiveParam(tcinfE.getTau0());
        this.paramhminE = this.addActiveParam(tcinfE.getHmin());
        this.paramhmaxE = this.addActiveParam(tcinfE.getHmax(), this.paramhminE, ParameterConstraintType.GREATER);
        InfiniteTcReservoirConfig tcinfL = (InfiniteTcReservoirConfig)this.fModel.getReservoirL().getConfig(ReservoirConfigType.INFINITE_TC);
        this.paramalphaL = this.addActiveParam(tcinfL.getAlpha());
        this.paramTau0L = this.addActiveParam(tcinfL.getTau0());
        this.paramhmaxL = this.addActiveParam(tcinfL.getHmax());
        InfiniteTcReservoirConfig tcinfM = (InfiniteTcReservoirConfig)this.fModel.getReservoirM().getConfig(ReservoirConfigType.INFINITE_TC);
        this.paramalphaM = this.addActiveParam(tcinfM.getAlpha());
        this.paramTau0M = this.addActiveParam(tcinfM.getTau0());
        this.paramhmaxM = this.addActiveParam(tcinfM.getHmax());
        InfiniteTcReservoirConfig tcinfC = (InfiniteTcReservoirConfig)this.fModel.getReservoirC().getConfig(ReservoirConfigType.INFINITE_TC);
        this.paramalphaC = this.addActiveParam(tcinfC.getAlpha());
        this.paramTau0C = this.addActiveParam(tcinfC.getTau0());
        this.paramhmaxC = this.addActiveParam(tcinfC.getHmax());
        this.addActiveParam(this.fModel.getPetRoutine().getLatitude());
        Double latitude = this.fModel.getPetRoutine().getLatitude().getValue();
        this.fPetOudin = this.fStructure.aPetRoutine ? (Unit.getInstance().getBase() == BaseUnit.DAY ? new PETOudinDaily(pInputData.getDates(), pInputData.getValues(ColumnName.T), latitude) : new PETOudinHourly(pInputData.getDates(), pInputData.getValues(ColumnName.T), latitude)) : null;
        this.paramK1 = this.addActiveParam(this.fModel.getPetRoutine().getK1());
        this.paramK2 = this.addActiveParam(this.fModel.getPetRoutine().getK2());
        this.fPetRoutineNeedsCalibration = this.fModel.getPetRoutine().needsCalibration();
        this.fLastPET = null;
        this.fHbvSnowRoutine = this.fStructure.aSnowRoutine ? new HbvSnowRoutine(pInputData.getValues(ColumnName.T), pInputData.getValues(ColumnName.P), pInputData.getValues(ColumnName.SRAD)) : null;
        this.paramTs = this.addActiveParam(this.fModel.getSnowRoutine().getTs());
        this.paramMF = this.addActiveParam(this.fModel.getSnowRoutine().getMf());
        this.paramCFR = this.addActiveParam(this.fModel.getSnowRoutine().getCfr());
        this.paramCWH = this.addActiveParam(this.fModel.getSnowRoutine().getCwh());
        this.paramRc = this.addActiveParam(this.fModel.getSnowRoutine().getRc());
        this.fSnowRoutineNeedsCalibration = this.fModel.getSnowRoutine().needsCalibration();
        this.fLastSnowRoutineOutput = null;
        this.activeParams.values().forEach(pv -> {
            if (pv.needsInit()) {
                this.initParams.add((ParamValue)pv);
            } else {
                if (pv.getMin() == pv.getMax()) {
                    pv.setBestValue(pv.getMin());
                }
                this.valueParams.add((ParamValue)pv);
            }
        });
        this.fData = new RunModelData(pInputData, this.fStructure, pGlobalStage.getFin() + this.fParams.ios);
    }

    private ParamValue addActiveParam(Parameter pParam, ParamValue pOther, ParameterConstraintType pConstraint) {
        ParamValue res = null;
        if (pParam.isActive()) {
            switch (pConstraint) {
                case EQUAL: {
                    res = ParamValueFactory.create(pParam, (pParamValue, pValue) -> {
                        pParamValue.setValue(pOther.getValue());
                        return false;
                    });
                    break;
                }
                case GREATER: {
                    res = ParamValueFactory.create(pParam, (pParamValue, pValue) -> {
                        pParamValue.setMin(pOther.getValue());
                        return true;
                    });
                    break;
                }
                case LESSER: {
                    res = ParamValueFactory.create(pParam, (pParamValue, pValue) -> {
                        pParamValue.setMax(Math.min(pParam.getMax(), pOther.getValue()));
                        return true;
                    });
                }
            }
            this.activeParams.put(pParam.columnTitle(), res);
        }
        return res;
    }

    private ParamValue addActiveParam(Parameter pParam) {
        if (pParam != null && pParam.isActive()) {
            ParamValue res = ParamValueFactory.create(pParam);
            this.activeParams.put(pParam.columnTitle(), res);
            return res;
        }
        return null;
    }

    public void updateConstraints() {
        for (ParamValue p : this.initParams) {
            if (p.getParameter().getConstraint() == null || !p.getParameter().getConstraint().isActive()) continue;
            p.setValue(p.getParameter().getConstraint().applyTo(p.getParameter().getValue()));
        }
    }

    public void initialize(Map<Parameter, double[]> pParamValueMap, int n) {
        pParamValueMap.forEach((param, value) -> this.activeParams.get(param.columnTitle()).setValue(value[n]));
    }

    public void initialize(double[] pValues) {
        this.valueParams.forEach(p -> p.setValue(p.getMin()));
        int n = 0;
        for (ParamValue p2 : this.initParams) {
            p2.init(pValues[n++]);
        }
    }

    private void raz() {
        this.fData = new RunModelData(this.fInputData, this.fStructure, this.fGlobalStage.getFin() + this.fParams.ios);
    }

    public RunResult run(int pBegining, int pEnd) {
        int t;
        double[] H;
        ReservoirConfig rc;
        int i;
        RunResult result = new RunResult();
        this.raz();
        this.fParams.A = this.paramRA.getValue();
        this.fParams.xEC = this.paramValue(this.paramxEC, 1.0);
        this.fParams.xEM = this.paramValue(this.paramxEM, 1.0);
        this.fParams.Z0E = this.paramValue(this.paramZ0E, 0.0);
        this.fParams.omegaE = this.paramValue(this.paramwE, 0.0);
        this.fParams.Z0L = this.paramValue(this.paramZ0L, 0.0);
        this.fParams.omegaL = this.paramValue(this.paramwL, 0.0);
        this.fParams.Z0M = this.paramValue(this.paramZ0M, 0.0);
        this.fParams.omegaM = this.paramValue(this.paramwM, 0.0);
        this.fParams.Z0C = this.paramValue(this.paramZ0C, 0.0);
        this.fParams.omegaC = this.paramValue(this.paramwC, 0.0);
        this.fParams.alphaE = this.paramValue(this.paramalphaE, 1.0);
        this.fParams.Tau0E = this.paramValue(this.paramTau0E, 0.0);
        this.fParams.hminE = this.paramValue(this.paramhminE, 0.0);
        this.fParams.hmaxE = this.paramValue(this.paramhmaxE, 0.0);
        this.fParams.alphaL = this.paramValue(this.paramalphaL, 1.0);
        this.fParams.Tau0L = this.paramValue(this.paramTau0L, 0.0);
        this.fParams.hmaxL = this.paramValue(this.paramhmaxL, 0.0);
        this.fParams.alphaM = this.paramValue(this.paramalphaM, 1.0);
        this.fParams.Tau0M = this.paramValue(this.paramTau0M, 0.0);
        this.fParams.hmaxM = this.paramValue(this.paramhmaxM, 0.0);
        this.fParams.alphaC = this.paramValue(this.paramalphaC, 1.0);
        this.fParams.Tau0C = this.paramValue(this.paramTau0C, 0.0);
        this.fParams.hmaxC = this.paramValue(this.paramhmaxC, 0.0);
        this.fParams.Emin = this.paramValue(this.paramEmin, 0.0);
        this.fParams.kloss = this.paramValue(this.paramkloss, 0.0);
        this.fParams.Eloss = this.paramValue(this.paramEloss, 0.0);
        this.fParams.aloss = this.paramValue(this.paramalphaloss, 1.0);
        this.fParams.xloss = this.paramValue(this.paramxloss, this.fModel.getQrE().getParameterTo(this.fModel.getReservoirC()).isActive() || this.fModel.getQrE().getParameterTo(this.fModel.getExutoire()).isActive() ? 0.0 : 1.0);
        this.fParams.xc = this.paramValue(this.paramxc, this.fModel.getQrE().getParameterTo(this.fModel.getReservoirC()).isActive() || this.fModel.getQrE().getParameterTo(this.fModel.getExutoire()).isActive() ? 1.0 : 0.0);
        this.fParams.khy = this.paramValue(this.paramkhy, 0.0);
        this.fParams.Ehy = this.paramValue(this.paramEhy, 0.0);
        this.fParams.Dhy = this.paramValue(this.paramDhy, 0.0);
        this.fParams.ahy = this.paramValue(this.paramalphahy, 1.0);
        this.fParams.xhy = this.paramValue(this.paramxhy, this.fModel.getQhyEC().isSelected() ? 1.0 : 0.0);
        this.fParams.kES = this.paramValue(this.paramkES, 0.0);
        this.fParams.aES = this.paramValue(this.paramalphaES, 1.0);
        this.fParams.kEL = this.paramValue(this.paramkEL, 0.0);
        this.fParams.aEL = this.paramValue(this.paramalphaEL, 1.0);
        this.fParams.xEM = this.paramValue(this.paramxEM, 0.0);
        this.fParams.kEM = this.paramValue(this.paramkEM, 0.0);
        this.fParams.aEM = this.paramValue(this.paramalphaEM, 1.0);
        this.fParams.kEC = this.paramValue(this.paramkEC, 0.0);
        this.fParams.aEC = this.paramValue(this.paramalphaEC, 1.0);
        this.fParams.kLS = this.paramValue(this.paramkLS, 0.0);
        this.fParams.aLS = this.paramValue(this.paramalphaLS, 1.0);
        this.fParams.kMS = this.paramValue(this.paramkMS, 0.0);
        this.fParams.aMS = this.paramValue(this.paramalphaMS, 1.0);
        this.fParams.kCS = this.paramValue(this.paramkCS, 0.0);
        this.fParams.aCS = this.paramValue(this.paramalphaCS, 1.0);
        this.fParams.kMC = this.paramValue(this.paramkMC, 0.0);
        this.fParams.aMC = this.paramValue(this.paramalphaMC, 1.0);
        this.fParams.k1 = this.paramValue(this.paramK1, 0.0);
        this.fParams.k2 = this.paramValue(this.paramK2, 0.0);
        this.fParams.Ts = this.paramValue(this.paramTs, 0.0);
        this.fParams.MF = this.paramValue(this.paramMF, 0.0);
        this.fParams.CFR = this.paramValue(this.paramCFR, 0.0);
        this.fParams.CWH = this.paramValue(this.paramCWH, 0.0);
        this.fParams.Rc = this.paramValue(this.paramRc, 0.0);
        double coefQS = this.fParams.A * 1000.0 / (double)Unit.getInstance().getBase().getSecondes();
        if (this.fStructure.aQpumpL) {
            for (i = 0; i < pEnd; ++i) {
                this.fData.QpumpL[i] = this.fData.QpumpL[i] / coefQS;
            }
        }
        if (this.fStructure.aQpumpM) {
            for (i = 0; i < pEnd; ++i) {
                this.fData.QpumpM[i] = this.fData.QpumpM[i] / coefQS;
            }
        }
        if (this.fStructure.aQpumpC) {
            for (i = 0; i < pEnd; ++i) {
                this.fData.QpumpC[i] = this.fData.QpumpC[i] / coefQS;
            }
        }
        if (this.fStructure.aQpumpS) {
            for (i = 0; i < pEnd; ++i) {
                this.fData.QpumpS[i] = this.fData.QpumpS[i] / coefQS;
            }
        }
        if (this.fStructure.aQsinkL) {
            for (i = 0; i < pEnd; ++i) {
                this.fData.QsinkL[i] = this.fData.QsinkL[i] / coefQS;
            }
        }
        if (this.fStructure.aQsinkM) {
            for (i = 0; i < pEnd; ++i) {
                this.fData.QsinkM[i] = this.fData.QsinkM[i] / coefQS;
            }
        }
        if (this.fStructure.aQsinkC) {
            for (i = 0; i < pEnd; ++i) {
                this.fData.QsinkC[i] = this.fData.QsinkC[i] / coefQS;
            }
        }
        if (this.fStructure.aQsinkS) {
            for (i = 0; i < pEnd; ++i) {
                this.fData.QsinkS[i] = this.fData.QsinkS[i] / coefQS;
            }
        }
        if ((rc = this.fModel.getReservoirE().getConfig(ReservoirConfigType.CLASSICAL)).isActive() && rc.getParameter("linkedReservoirs").isActive()) {
            double kE = this.paramValue(this.paramkE, 1.0);
            double alphaE = this.paramValue(this.paramalphaELinked, 1.0);
            this.fParams.kEC = this.fParams.xEC * kE;
            this.fParams.aEC = alphaE;
            if (this.fStructure.aQEM && this.fStructure.aQEL) {
                this.fParams.kEM = this.fParams.xEM * (1.0 - this.fParams.xEC) * kE;
                this.fParams.aEM = alphaE;
                this.fParams.kEL = (1.0 - this.fParams.xEM) * (1.0 - this.fParams.xEC) * kE;
                this.fParams.aEL = alphaE;
            } else if (this.fStructure.aQEM) {
                this.fParams.kEM = (1.0 - this.fParams.xEC) * kE;
                this.fParams.aEM = alphaE;
            } else {
                this.fParams.kEL = (1.0 - this.fParams.xEC) * kE;
                this.fParams.aEL = alphaE;
            }
        }
        this.fParams.Eo = this.paramE0 != null ? this.paramE0.getValue() : 0.0;
        this.fParams.Mo = this.paramM0 != null ? this.paramM0.getValue() : 0.0;
        this.fParams.Co = this.paramC0 != null ? this.paramC0.getValue() : 0.0;
        this.fParams.Lo = this.paramL0 != null ? this.paramL0.getValue() : 0.0;
        this.fData.init(this.fStructure, this.fParams);
        this.fData.E[pBegining] = this.fParams.Eo;
        this.fData.L[pBegining] = this.fParams.Lo;
        this.fData.M[pBegining] = this.fParams.Mo;
        this.fData.C[pBegining] = this.fParams.Co;
        this.fData.SolE = !(this.fStructure.TcinfE || this.fStructure.aQES && this.fParams.aES != 1.0 || this.fStructure.aQEL && this.fParams.aEL != 1.0 || this.fStructure.aQEM && this.fParams.aEM != 1.0 || this.fStructure.aQEC && this.fParams.aEC != 1.0 || this.fStructure.aQloss && this.fParams.aloss != 1.0 || this.fStructure.aQhy && this.fParams.ahy != 1.0);
        this.fData.SolL = this.fStructure.aL && !this.fStructure.TcinfL && this.fParams.aLS == 1.0;
        this.fData.SolM = this.fStructure.aM && !this.fStructure.TcinfM && this.fParams.aMS == 1.0;
        this.fData.SolC = this.fStructure.aC && !this.fStructure.TcinfC && this.fParams.aCS == 1.0;
        IResolE resolE = null;
        if (!this.fStructure.TcinfE) {
            resolE = this.fData.SolE ? new ResolAnalytiqueResE(this.fStructure, this.fParams) : new ResolLineariseeResE(this.fStructure);
        }
        boolean bl = this.fData.ehy = !this.fStructure.TcinfE && this.fStructure.aQhy && this.fStructure.aQhyDhy && this.fParams.Ehy > 0.0 && this.fParams.Eo >= this.fParams.Ehy + this.fParams.Dhy;
        if (this.fPetOudin != null) {
            if (this.fPetRoutineNeedsCalibration || this.fLastPET == null) {
                this.fLastPET = this.fPetOudin.compute(this.fParams.k1, this.fParams.k2);
            }
            this.fData.PET = this.fLastPET;
            this.fData.ET = this.fData.PET;
        } else {
            this.fData.ET = this.fData.ETInit;
        }
        if (this.fHbvSnowRoutine != null) {
            if (this.fSnowRoutineNeedsCalibration || this.fLastSnowRoutineOutput == null) {
                this.fLastSnowRoutineOutput = this.fHbvSnowRoutine.compute(this.fParams.Ts, this.fParams.MF, this.fParams.CFR, this.fParams.CWH, this.fParams.Rc, this.fModel.getSnowRoutine().getSubcatchmentTable());
            }
            this.fData.Psr = this.fLastSnowRoutineOutput.getPsr();
            this.fData.P = this.fData.Psr;
            this.fData.srLiquid = this.fLastSnowRoutineOutput.getLiquid();
            this.fData.srSolid = this.fLastSnowRoutineOutput.getSolid();
            this.fData.srMelt = this.fLastSnowRoutineOutput.getMelt();
            this.fData.srRefreezing = this.fLastSnowRoutineOutput.getRefreezing();
        } else {
            this.fData.P = this.fData.PInit;
        }
        KarstModResol resol = new KarstModResol(this.fParams, this.fStructure, this.fData);
        for (int t2 = pBegining; t2 <= pEnd; ++t2) {
            if (resol.run(t2, resolE)) continue;
            return null;
        }
        for (double[] Q : new double[][]{this.fData.QS, this.fData.Qloss, this.fData.QrEloss, this.fData.QrLloss, this.fData.QrMloss, this.fData.QrCloss, this.fData.QES, this.fData.QEL, this.fData.QEM, this.fData.QE, this.fData.QEC, this.fData.Qhy, this.fData.QLS, this.fData.QMS, this.fData.QCS, this.fData.QMC, this.fData.QbL, this.fData.QrL, this.fData.QbM, this.fData.QrM, this.fData.QbC, this.fData.QrC}) {
            if (Q == null) continue;
            for (int t3 = pEnd; t3 >= pBegining; --t3) {
                Q[t3] = Q[t3] * coefQS;
            }
        }
        if (this.fParams.ios != 0 && pEnd + 1 - pBegining >= 0) {
            System.arraycopy(this.fData.QS, pBegining, this.fData.QS, pBegining + this.fParams.ios, pEnd + 1 - pBegining);
        }
        result.add(Varname.QS, this.fData.QS);
        if (this.fCalcZE) {
            double Z0 = this.paramZ0E.getValue();
            double w = this.paramwE.getValue();
            double[] Z = this.fData.ZE;
            H = this.fData.E;
            for (t = pBegining; t <= pEnd; ++t) {
                Z[t] = Z0 + 0.001 * H[t] / w;
            }
            result.add(Varname.ZE, Z);
        }
        if (this.fCalcZL) {
            double Z0 = this.paramZ0L.getValue();
            double w = this.paramwL.getValue();
            double[] Z = this.fData.ZL;
            H = this.fData.L;
            for (t = pBegining; t <= pEnd; ++t) {
                Z[t] = Z0 + 0.001 * H[t] / w;
            }
            result.add(Varname.ZL, Z);
        }
        if (this.fCalcZM) {
            double Z0 = this.paramZ0M.getValue();
            double w = this.paramwM.getValue();
            double[] Z = this.fData.ZM;
            H = this.fData.M;
            for (t = pBegining; t <= pEnd; ++t) {
                Z[t] = Z0 + 0.001 * H[t] / w;
            }
            result.add(Varname.ZM, Z);
        }
        if (this.fCalcZC) {
            double Z0 = this.paramZ0C.getValue();
            double w = this.paramwC.getValue();
            double[] Z = this.fData.ZC;
            H = this.fData.C;
            for (t = pBegining; t <= pEnd; ++t) {
                Z[t] = Z0 + 0.001 * H[t] / w;
            }
            result.add(Varname.ZC, Z);
        }
        if (this.fStructure.aQloss) {
            result.add(Varname.QLOSS, this.fData.Qloss);
        }
        return result;
    }

    public void printParams() {
        this.activeParams.forEach((key, value) -> System.out.println(key + ": " + value.getValue()));
    }

    private double paramValue(ParamValue pParamValue, double pDefaultValue) {
        return pParamValue != null ? pParamValue.getValue() : pDefaultValue;
    }

    public int getNbParams() {
        return this.initParams.size();
    }

    public Parameter[] getInitParams() {
        return (Parameter[])this.initParams.stream().map(ParamValue::getParameter).toArray(Parameter[]::new);
    }

    public double[] activeParamValues() {
        return this.activeParams.values().stream().mapToDouble(ParamValue::getValue).toArray();
    }

    public double[] getHObsZE() {
        return this.fCalcZE ? this.fData.ZobsE : null;
    }

    public double[] getHObsZL() {
        return this.fCalcZL ? this.fData.ZobsL : null;
    }

    public double[] getHObsZM() {
        return this.fCalcZM ? this.fData.ZobsM : null;
    }

    public double[] getHObsZC() {
        return this.fCalcZC ? this.fData.ZobsC : null;
    }

    public void updateParametersWithBestValues() {
        for (ParamValue pv : this.activeParams.values()) {
            pv.updateValueWithBest();
        }
        this.raz();
    }

    public Parameter[] getActiveParameters() {
        return (Parameter[])this.activeParams.values().stream().map(ParamValue::getParameter).toArray(Parameter[]::new);
    }

    public void saveBest() {
        for (ParamValue pv : this.initParams) {
            pv.saveBest();
        }
    }

    public double[] getQlossValues() {
        return this.fData.Qloss;
    }

    public double[] getQrElossValues() {
        return this.fData.QrEloss;
    }

    public double[] getQrLlossValues() {
        return this.fData.QrLloss;
    }

    public double[] getQrMlossValues() {
        return this.fData.QrMloss;
    }

    public double[] getQrClossValues() {
        return this.fData.QrCloss;
    }

    public double[] getQELValues() {
        return this.fData.QEL;
    }

    public double[] getQEMValues() {
        return this.fData.QEM;
    }

    public double[] getQECValues() {
        return this.fData.QEC;
    }

    public double[] getQEValues() {
        return this.fData.QE;
    }

    public double[] getQESValues() {
        return this.fData.QES;
    }

    public double[] getQhyECValues() {
        double[] res = new double[this.fData.Qhy.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.fData.Qhy[i] * this.fParams.xhy;
        }
        return res;
    }

    public double[] getQhyESValues() {
        double[] res = new double[this.fData.Qhy.length];
        double c = 1.0 - this.fParams.xhy;
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.fData.Qhy[i] * c;
        }
        return res;
    }

    public double[] getQMCValues() {
        return this.fData.QMC;
    }

    public double[] getQMSValues() {
        return this.fData.QMS;
    }

    public double[] getQCSValues() {
        return this.fData.QCS;
    }

    public double[] getQLSValues() {
        return this.fData.QLS;
    }

    public double[] getEValues() {
        return this.fData.E;
    }

    public double[] getLValues() {
        return this.fData.L;
    }

    public double[] getMValues() {
        return this.fData.M;
    }

    public double[] getCValues() {
        return this.fData.C;
    }

    public double[] getQSValues() {
        return this.fData.QS;
    }

    public double[] getZEValues() {
        return this.fData.ZE;
    }

    public double[] getZLValues() {
        return this.fData.ZL;
    }

    public double[] getZMValues() {
        return this.fData.ZM;
    }

    public double[] getZCValues() {
        return this.fData.ZC;
    }

    public double[] getETEffValues() {
        return this.fData.ETeff;
    }

    public double[] getQrLValues() {
        return this.fData.QrL;
    }

    public double[] getQbLValues() {
        return this.fData.QbL;
    }

    public double[] getQrMValues() {
        return this.fData.QrM;
    }

    public double[] getQbMValues() {
        return this.fData.QbM;
    }

    public double[] getQrCValues() {
        return this.fData.QrC;
    }

    public double[] getQbCValues() {
        return this.fData.QbC;
    }

    public double[] getQPumpSValues() {
        return this.fData.QpumpS;
    }

    public double[] getQPumpLValues() {
        return this.fData.QpumpL;
    }

    public double[] getQPumpMValues() {
        return this.fData.QpumpM;
    }

    public double[] getQPumpCValues() {
        return this.fData.QpumpC;
    }

    public double[] getThetaQrEValues() {
        return this.fData.thetaQrEexport;
    }

    public double[] getThetaQrLValues() {
        return this.fData.thetaQrLexport;
    }

    public double[] getThetaQrMValues() {
        return this.fData.thetaQrMexport;
    }

    public double[] getThetaQrCValues() {
        return this.fData.thetaQrCexport;
    }

    public int getBadsolE() {
        return this.fData.badsolE;
    }

    public double[] getPsrValues() {
        return this.fData.Psr;
    }

    public double[] getPETValues() {
        return this.fData.PET;
    }

    public double[] getQobsValues() {
        return this.fData.Qobs;
    }

    public double[] getPOrPsrValues() {
        return this.fHbvSnowRoutine != null ? this.fData.Psr : this.fData.P;
    }

    public double[] getETOrPETValues() {
        return this.fPetOudin != null ? this.fData.PET : this.fData.ET;
    }

    public double[] getPValues() {
        return this.fData.P;
    }

    public double[] getPInputValues() {
        return this.fInputData.getValues(ColumnName.P);
    }

    public double[] getETValues() {
        return this.fData.ET;
    }

    public double[] getETInputValues() {
        return this.fInputData.getValues(ColumnName.ET);
    }

    public double[] getSrLiquidValues(int i) {
        return this.fData.srLiquid[i];
    }

    public double[] getSrSolidValues(int i) {
        return this.fData.srSolid[i];
    }

    public double[] getSrMeltValues(int i) {
        return this.fData.srMelt[i];
    }

    public double[] getSrRefreezingValues(int i) {
        return this.fData.srRefreezing[i];
    }

    public void resetRoutines() {
        this.fLastPET = null;
        this.fLastSnowRoutineOutput = null;
    }
}

