/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run.model;

import fr.geonosis.karstmod.KarstModLogger;
import fr.geonosis.karstmod.modele.ConcurrentParameterValueSet;
import fr.geonosis.karstmod.modele.InputData;
import fr.geonosis.karstmod.modele.KarstModConfig;
import fr.geonosis.karstmod.modele.StageBounds;
import fr.geonosis.karstmod.modele.montecarlo.IRandomGenerator;
import fr.geonosis.karstmod.modele.obj.GlobalObjectiveFunction;
import fr.geonosis.karstmod.modele.obj.WobjResult;
import fr.geonosis.karstmod.modele.obj.WobjRunResults;
import fr.geonosis.karstmod.modele.obj.WobjValues;
import fr.geonosis.karstmod.modele.obj.parser.Varname;
import fr.geonosis.karstmod.run.RunMonitor;
import fr.geonosis.karstmod.run.model.RunModel;
import fr.geonosis.karstmod.run.model.RunResult;
import fr.geonosis.karstmod.viewfx.utils.ModelOutput;
import java.io.IOException;
import java.util.List;

public class ModelRunner {
    private final RunModel fRunModel;
    private final GlobalObjectiveFunction fWobj;
    private final IRandomGenerator fRandomGenerator;
    private final InputData fInputData;
    private final StageBounds fGlobalStage;

    public ModelRunner(KarstModConfig pConfig, StageBounds pGlobalStage) {
        this(pConfig, pGlobalStage, pConfig.getRunParameters().getWobjFunction());
    }

    public ModelRunner(KarstModConfig pConfig, StageBounds pGlobalStage, GlobalObjectiveFunction pWobj) {
        this.fWobj = pWobj;
        this.fInputData = pConfig.getInputData();
        this.fGlobalStage = pGlobalStage;
        this.fRunModel = new RunModel(pConfig.getModel(), this.fInputData, pGlobalStage);
        this.fRandomGenerator = pConfig.getRandomGenerator();
    }

    public RunModel getRunModel() {
        return this.fRunModel;
    }

    public WobjValues doRun(List<StageBounds> pCalibrationStages, List<StageBounds> pValidationStages, int pNobjMax, double pWobjMin) {
        GlobalObjectiveFunction wObjCalibration = this.fWobj.clone();
        wObjCalibration.init(this.fInputData, pCalibrationStages, pNobjMax, pWobjMin, this.fInputData.getIOShift());
        GlobalObjectiveFunction wObjValidation = this.fWobj.clone();
        wObjValidation.init(this.fInputData, pValidationStages, pNobjMax, -1.7976931348623157E308, this.fInputData.getIOShift());
        int t0 = this.fGlobalStage.getDebut();
        int t1 = this.fGlobalStage.getFin();
        this.fRunModel.updateConstraints();
        RunResult result = this.fRunModel.run(t0, t1);
        if (result == null) {
            throw new IllegalStateException("Computation error");
        }
        return new WobjValues(wObjCalibration.compute(result), wObjValidation.compute(result));
    }

    public RunResult doRun(double[] pParams, int pBegining, int pEnd) {
        this.fRunModel.initialize(pParams);
        return this.fRunModel.run(pBegining, pEnd);
    }

    public WobjRunResults doCalibration(RunMonitor pMonitor, int pNObjMax, double pWobjMin, ConcurrentParameterValueSet pParameterValueSet, String pOutputDirectory) {
        GlobalObjectiveFunction fctWObjCalibration = this.fWobj.clone();
        GlobalObjectiveFunction fctWObjValidation = this.fWobj.clone();
        fctWObjCalibration.init(this.fInputData, pMonitor.getCalibrationStages(), pNObjMax, pWobjMin, this.fInputData.getIOShift());
        fctWObjValidation.init(this.fInputData, pMonitor.getValidationStages(), pNObjMax, -4.9E-324, this.fInputData.getIOShift());
        int t0 = this.fGlobalStage.getDebut();
        int t1 = this.fGlobalStage.getFin();
        List<Varname> usedVar = pMonitor.getModel().usedVars();
        int n = 0;
        while (!pMonitor.isDone()) {
            WobjResult wObjCalibration;
            RunResult result;
            if (pParameterValueSet != null) {
                n = pParameterValueSet.next();
                if (n < 0) break;
                this.fRunModel.initialize(pParameterValueSet.getParamValueMap(), n);
            } else {
                this.fRunModel.initialize(this.fRandomGenerator.nextPoint());
            }
            if ((result = this.fRunModel.run(t0, t1)) == null || !Double.isFinite((wObjCalibration = fctWObjCalibration.compute(result)).getRes()) || pParameterValueSet == null && !pMonitor.mustRetain(wObjCalibration.getRes())) continue;
            WobjResult wObjValidation = fctWObjValidation.computeAndSave(result);
            fctWObjCalibration.save(wObjCalibration);
            for (Varname varname : usedVar) {
                pMonitor.addOutput(varname, (double[])result.getValues(varname).clone(), new WobjValues(wObjCalibration, wObjValidation), this.fRunModel.activeParamValues());
            }
            if (pParameterValueSet != null) {
                ModelOutput mo = new ModelOutput(pMonitor, pOutputDirectory, String.valueOf(n + 1), true, false);
                try {
                    mo.saveDischargeOut(this.fRunModel);
                    mo.saveWaterLevel(this.fRunModel);
                    mo.saveParamsOut(wObjCalibration.getRes(), wObjValidation.getRes(), this.fRunModel);
                }
                catch (IOException pE) {
                    KarstModLogger.severe("Error on multi save", pE, false);
                }
            }
            if (!pMonitor.fireWorked(wObjCalibration, wObjValidation, this)) continue;
            this.fRunModel.saveBest();
        }
        return new WobjRunResults(this.fWobj, fctWObjCalibration.getWobjResults(), fctWObjValidation.getWobjResults());
    }

    public void updateParametersWithBestValues() {
        this.fRunModel.updateParametersWithBestValues();
    }
}

