/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run.model;

import fr.geonosis.karstmod.run.model.Functions;
import fr.geonosis.karstmod.run.model.IResolE;
import fr.geonosis.karstmod.run.model.RunModelData;
import fr.geonosis.karstmod.run.model.RunModelParameters;
import fr.geonosis.karstmod.run.model.RunModelStructure;

public class KarstModResol {
    private final RunModelParameters par;
    private final RunModelStructure str;
    private final RunModelData dat;

    public KarstModResol(RunModelParameters pPar, RunModelStructure pStr, RunModelData pDat) {
        this.par = pPar;
        this.str = pStr;
        this.dat = pDat;
    }

    public boolean run(int i, IResolE pResolE) {
        double SM;
        double[] tmp;
        Functions.ResolTcinfResult tmpRes;
        if (this.str.TcinfE) {
            tmpRes = Functions.resolTcinf(this.dat.E[i], this.par.nrE, this.dat.thetaE, this.dat.hE, this.dat.P[i], this.dat.ET[i], this.par.hmaxE, this.par.hminE, this.dat.kIfE, this.par.dt);
            this.dat.thetaQrEexport[i] = tmpRes.thetaQr;
            this.dat.E[i + 1] = tmpRes.hav;
            if (this.par.xloss != 0.0) {
                this.dat.QrEloss[i] = tmpRes.Qrtot * this.par.xloss;
                this.dat.QEC[i] = tmpRes.Qrtot * (1.0 - this.par.xloss) * this.par.xc;
                this.dat.QES[i] = tmpRes.Qrtot * (1.0 - this.par.xloss) * (1.0 - this.par.xc);
            } else if (this.str.QrE2C) {
                this.dat.QEC[i] = tmpRes.Qrtot;
            } else if (this.str.QrE2S) {
                this.dat.QES[i] = tmpRes.Qrtot;
            } else if (this.str.QrE2loss) {
                this.dat.QrEloss[i] = tmpRes.Qrtot;
            }
            if (this.str.QbE2L) {
                this.dat.QEL[i] = tmpRes.Qbtot;
            } else if (this.str.QbE2M) {
                this.dat.QEM[i] = tmpRes.Qbtot;
            } else if (this.str.QbE2C) {
                int n = i;
                this.dat.QEC[n] = this.dat.QEC[n] + tmpRes.Qbtot;
            } else if (this.str.QbE2S) {
                int n = i;
                this.dat.QES[n] = this.dat.QES[n] + tmpRes.Qbtot;
            }
            this.dat.hE = tmpRes.h;
            this.dat.ETeff[i] = Math.min(tmpRes.s + this.dat.P[i], this.dat.ET[i]);
        } else {
            double Qtot = pResolE.solve(this.par, this.dat, i);
            this.dat.ETeff[i] = this.dat.E[i + 1] != this.par.Emin ? this.dat.ET[i] : Math.max((this.dat.E[i] - this.par.Emin) / this.par.dt + (this.dat.P[i] - Qtot), 0.0);
        }
        if (this.str.aL) {
            if (this.str.TcinfL) {
                tmpRes = Functions.resolTcinf(this.dat.L[i], this.par.nrL, this.dat.thetaL, this.dat.hL, this.dat.QEL[i], this.dat.QpumpL[i] - this.dat.QsinkL[i], this.par.hmaxL, 0.0, this.dat.kIfL, this.par.dt);
                this.dat.thetaQrLexport[i] = tmpRes.thetaQr;
                this.dat.L[i + 1] = tmpRes.hav;
                this.dat.QbL[i] = tmpRes.Qbtot;
                this.dat.QLS[i] = tmpRes.Qbtot;
                if (this.str.QrL2loss) {
                    this.dat.QrLloss[i] = tmpRes.Qrtot;
                } else {
                    this.dat.QrL[i] = tmpRes.Qrtot;
                    int n = i;
                    this.dat.QLS[n] = this.dat.QLS[n] + tmpRes.Qrtot;
                    this.dat.QrLloss[i] = 0.0;
                }
                this.dat.hL = tmpRes.h;
            } else if (this.dat.SolL) {
                tmp = Functions.Qth(this.par.kLS, this.par.aLS, this.dat.L[i], this.dat.L[i], this.dat.QEL[i] - (this.dat.QpumpL[i] - this.dat.QsinkL[i]), this.par.dt, false);
                this.dat.L[i + 1] = tmp[0];
                this.dat.QLS[i] = tmp[1];
            } else {
                tmp = Functions.Qth(this.par.kLS, this.par.aLS, this.dat.L[i], this.dat.L[i], this.dat.QEL[i] - (this.dat.QpumpL[i] - this.dat.QsinkL[i]), this.par.dt / 2.0, false);
                double L12 = tmp[0];
                tmp = Functions.Qth(this.par.kLS, this.par.aLS, this.dat.L[i], L12, this.dat.QEL[i] - (this.dat.QpumpL[i] - this.dat.QsinkL[i]), this.par.dt, false);
                this.dat.L[i + 1] = tmp[0];
                this.dat.QLS[i] = tmp[1];
            }
        }
        if (this.str.aM) {
            if (this.str.TcinfM) {
                tmpRes = Functions.resolTcinf(this.dat.M[i], this.par.nrM, this.dat.thetaM, this.dat.hM, this.dat.QEM[i], this.dat.QpumpM[i] - this.dat.QsinkM[i], this.par.hmaxM, 0.0, this.dat.kIfM, this.par.dt);
                this.dat.thetaQrMexport[i] = tmpRes.thetaQr;
                this.dat.M[i + 1] = tmpRes.hav;
                this.dat.QbM[i] = tmpRes.Qbtot;
                this.dat.QMS[i] = tmpRes.Qbtot;
                if (this.str.QrM2loss) {
                    this.dat.QrMloss[i] = tmpRes.Qrtot;
                } else {
                    this.dat.QrM[i] = tmpRes.Qrtot;
                    int n = i;
                    this.dat.QMS[n] = this.dat.QMS[n] + tmpRes.Qrtot;
                    this.dat.QrMloss[i] = 0.0;
                }
                this.dat.hM = tmpRes.h;
            } else if (!this.str.aQMC || this.par.kMC == 0.0 || this.dat.M[i] == this.dat.C[i]) {
                SM = this.dat.QEM[i] - (this.dat.QpumpM[i] - this.dat.QsinkM[i]);
                if (this.dat.SolM) {
                    tmp = Functions.Qth(this.par.kMS, this.par.aMS, this.dat.M[i], this.dat.M[i], SM, this.par.dt, this.str.blessM);
                } else {
                    tmp = Functions.Qth(this.par.kMS, this.par.aMS, this.dat.M[i], this.dat.M[i], SM, this.par.dt / 2.0, this.str.blessM);
                    double M12 = tmp[0];
                    tmp = Functions.Qth(this.par.kMS, this.par.aMS, this.dat.M[i], M12, SM, this.par.dt / 2.0, this.str.blessM);
                }
                this.dat.M[i + 1] = tmp[0];
                this.dat.QMS[i] = tmp[1];
            }
        }
        if (this.str.aC) {
            if (this.str.TcinfC) {
                tmpRes = Functions.resolTcinf(this.dat.C[i], this.par.nrC, this.dat.thetaC, this.dat.hC, this.dat.QEC[i] + (this.str.aQhy ? this.par.xhy * this.dat.Qhy[i] : 0.0), this.dat.QpumpC[i] - this.dat.QsinkC[i], this.par.hmaxC, 0.0, this.dat.kIfC, this.par.dt);
                this.dat.thetaQrLexport[i] = tmpRes.thetaQr;
                this.dat.C[i + 1] = tmpRes.hav;
                this.dat.QbC[i] = tmpRes.Qbtot;
                this.dat.QCS[i] = tmpRes.Qbtot;
                if (this.str.QrC2loss) {
                    this.dat.QrCloss[i] = tmpRes.Qrtot;
                } else {
                    this.dat.QrC[i] = tmpRes.Qrtot;
                    int n = i;
                    this.dat.QCS[n] = this.dat.QCS[n] + tmpRes.Qrtot;
                    this.dat.QrCloss[i] = 0.0;
                }
                this.dat.hC = tmpRes.h;
            } else if (!this.str.aQMC || this.par.kMC == 0.0 || this.dat.M[i] == this.dat.C[i]) {
                double SC = this.dat.QEC[i] - (this.dat.QpumpC[i] - this.dat.QsinkC[i]) + (this.str.aQhy ? this.par.xhy * this.dat.Qhy[i] : 0.0);
                if (this.dat.SolC) {
                    tmp = Functions.Qth(this.par.kCS, this.par.aCS, this.dat.C[i], this.dat.C[i], SC, this.par.dt, this.str.blessC);
                } else {
                    tmp = Functions.Qth(this.par.kCS, this.par.aCS, this.dat.C[i], this.dat.C[i], SC, this.par.dt / 2.0, this.str.blessC);
                    double C12 = tmp[0];
                    tmp = Functions.Qth(this.par.kCS, this.par.aCS, this.dat.C[i], C12, SC, this.par.dt, this.str.blessC);
                }
                this.dat.C[i + 1] = tmp[0];
                this.dat.QCS[i] = tmp[1];
            }
        }
        if (this.str.aC && this.str.aM && this.str.aQMC && this.par.kMC != 0.0 && this.dat.M[i] != this.dat.C[i]) {
            double QMSCS;
            SM = this.dat.QEM[i] - (this.dat.QpumpM[i] - this.dat.QsinkM[i]);
            double SC = this.dat.QEC[i] - (this.dat.QpumpC[i] - this.dat.QsinkC[i]) + (this.str.aQhy ? this.par.xhy * this.dat.Qhy[i] : 0.0);
            double kMSi = this.dat.M[i] >= 0.0 ? Functions.ki(this.par.kMS, this.par.aMS, this.dat.M[i]) : 0.0;
            double kCSi = this.dat.C[i] >= 0.0 ? Functions.ki(this.par.kCS, this.par.aCS, this.dat.C[i]) : 0.0;
            double kMCi = Functions.ki(this.par.kMC, this.par.aMC, Math.abs(this.dat.M[i] - this.dat.C[i]));
            if (!this.dat.SolM || !this.dat.SolC) {
                tmp = Functions.MCth(this.dat.M[i], this.dat.C[i], kMCi, kMSi, kCSi, SM, SC, this.par.dt / 2.0);
                double M12 = tmp[0];
                double C12 = tmp[1];
                kMSi = M12 >= 0.0 ? Functions.ki(this.par.kMS, this.par.aMS, M12) : 0.0;
                kCSi = C12 >= 0.0 ? Functions.ki(this.par.kCS, this.par.aCS, C12) : 0.0;
                kMCi = Functions.ki(this.par.kMC, this.par.aMC, Math.abs(M12 - C12));
            }
            tmp = Functions.MCth(this.dat.M[i], this.dat.C[i], kMCi, kMSi, kCSi, SM, SC, this.par.dt);
            this.dat.M[i + 1] = tmp[0];
            this.dat.C[i + 1] = tmp[1];
            if (!this.str.blessC) {
                if (this.dat.M[i + 1] < 0.0) {
                    this.dat.M[i + 1] = 0.0;
                }
                if (this.dat.C[i + 1] < 0.0) {
                    this.dat.C[i + 1] = 0.0;
                }
            }
            if ((QMSCS = -(this.dat.M[i + 1] - this.dat.M[i]) - (this.dat.C[i + 1] - this.dat.C[i]) + SM + SC) == 0.0 || kMSi == 0.0 && kCSi == 0.0) {
                this.dat.QMS[i] = 0.0;
                this.dat.QCS[i] = 0.0;
            } else {
                this.dat.QMS[i] = QMSCS * (kMSi * (this.dat.M[i] + this.dat.M[i + 1])) / (kMSi * (this.dat.M[i] + this.dat.M[i + 1]) + kCSi * (this.dat.C[i] + this.dat.C[i + 1]));
                this.dat.QCS[i] = QMSCS - this.dat.QMS[i];
            }
            this.dat.QMC[i] = (this.dat.M[i] - this.dat.M[i + 1]) / this.par.dt + SM - this.dat.QMS[i];
        }
        this.dat.QS[i] = Math.max(this.dat.QES[i] + this.dat.QLS[i] + this.dat.QMS[i] + this.dat.QCS[i] + (1.0 - this.par.xhy) * this.dat.Qhy[i] - (this.dat.QpumpS[i] - this.dat.QsinkS[i]), 0.0);
        this.dat.QpumpSeff[i] = -this.dat.QS[i] + this.dat.QES[i] + this.dat.QLS[i] + this.dat.QMS[i] + this.dat.QCS[i] + (1.0 - this.par.xhy) * this.dat.Qhy[i];
        return !Double.isNaN(this.dat.QS[i]);
    }
}

