/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run.model;

public class Functions {
    public static double ki(double k, double a, double H) {
        if (H > 0.0) {
            if (a == 1.0) {
                return k;
            }
            if (a == 2.0) {
                return k * H;
            }
            return k * Math.pow(H, a - 1.0);
        }
        return 0.0;
    }

    public static double kiSeuil(double k, double Hseuil, double a, double H) {
        if (H > Hseuil) {
            if (a == 1.0) {
                return k;
            }
            if (a == 2.0) {
                return k * (H - Hseuil);
            }
            return k * Math.pow(H - Hseuil, a - 1.0);
        }
        return 0.0;
    }

    public static double eth(double E, double k, double S, double PAS, boolean bless, double Emin) {
        double Eth;
        if (k != 0.0) {
            double Eq = S / k;
            Eth = Eq + (E - Eq) * Math.exp(-k * PAS);
        } else {
            Eth = E + PAS * S;
        }
        if (!bless && Eth < Emin) {
            return Emin;
        }
        return Eth;
    }

    public static double[] Qth(double k, double a, double H, double Hk, double S, double PAS, boolean bless) {
        double ki = Functions.ki(k, a, Hk);
        double Htmp = Functions.eth(H, ki, S, PAS, bless, 0.0);
        double Qtmp = S + (H - Htmp) / PAS;
        if (Qtmp < 0.0) {
            Qtmp = 0.0;
        }
        return new double[]{Htmp, Qtmp};
    }

    public static double[] MCth(double M, double C, double kMC, double kM, double kC, double SM, double SC, double PAS) {
        if (kM == 0.0 && kC == 0.0) {
            if (kMC == 0.0) {
                return new double[]{M, C};
            }
            double a = (M + C) / 2.0 + (SM + SC) * PAS / 2.0;
            double b = (SM - SC) / (4.0 * kMC) + 0.5 * (M - C - (SM - SC) / (2.0 * kMC)) * Math.exp(-2.0 * kMC * PAS);
            return new double[]{a + b, a - b};
        }
        kM = -kM;
        kC = -kC;
        kMC = -kMC;
        double a = -(kMC + (kC + kM) / 2.0);
        double b = Math.sqrt(Math.pow(kMC + (kC + kM) / 2.0, 2.0) - (kM * kMC + kC * kMC + kC * kM));
        double l1 = a - b;
        double l2 = a + b;
        double[] K = new double[]{kMC, l2 + kMC + kC, l1 + kMC + kM, kMC};
        double[] K1 = new double[]{kMC, -l2 - kMC - kC, -l1 - kMC - kM, kMC};
        double det = Functions.det22(K);
        int j = 0;
        while (j < K1.length) {
            int n = j++;
            K1[n] = K1[n] / det;
        }
        double[] w0 = Functions.mult22v(K1, new double[]{M, C});
        double[] weq = Functions.mult22v(K1, new double[]{SM, SC});
        weq[0] = weq[0] / l1;
        weq[1] = weq[1] / l2;
        double[] wp = Functions.addv2(weq, Functions.multv2(Functions.substractv2(w0, weq), new double[]{Math.exp(-l1 * PAS), Math.exp(-l2 * PAS)}));
        return Functions.mult22v(K, wp);
    }

    public static EiSeuilsResults eiSeuils(double Ei, double Ri, double[] Eth, double[] kth, double[] Rtab, int nth, double PAS, double dtrest) {
        double tau;
        double kE;
        int dijR = -1;
        double[] Qtotth = new double[nth + 1];
        double[] dteff = new double[nth + 1];
        double Etmp = 0.0;
        double SE = 0.0;
        double found = 0.0;
        double Eeq_beg = Double.NaN;
        if (nth == 0) {
            kE = kth[0];
            SE = Ri;
            if (kE > 0.0) {
                Eeq_beg = Ri / kE;
                if (Ri < 0.0) {
                    tau = Math.log(-Ei / Eeq_beg + 1.0);
                    tau /= Math.max(kE, 1.0E-20);
                } else {
                    tau = 2.0 * dtrest;
                }
            } else {
                tau = Math.abs(Ei) / Math.max(Math.abs(Ri), 1.0E-10);
            }
            if (tau < 0.0 || tau > dtrest) {
                if (kE > 0.0) {
                    Etmp = Eeq_beg + (Ei - Eeq_beg) * Math.exp(-kE * dtrest);
                    Qtotth[0] = Ri * dtrest + (Ei - Etmp);
                } else {
                    Etmp = Ei + Ri * dtrest;
                }
                dteff[0] = dtrest;
            } else {
                dteff[0] = tau;
                Etmp = 0.0;
                Qtotth[0] = Ri * tau + Ei;
            }
        } else {
            int th;
            if (Ei >= Eth[nth + 1 + dijR]) {
                th = nth + 1 + dijR;
            } else if (Ei < Eth[2 + dijR]) {
                th = 1 + dijR;
            } else {
                th = 2 + dijR;
                while (found == 0.0) {
                    if (!(Ei >= Eth[th])) continue;
                    if (Ei < Eth[th + 1]) {
                        found = 1.0;
                        continue;
                    }
                    ++th;
                }
            }
            int thbeg = th;
            while (dtrest > 0.0) {
                int thend;
                kE = kth[thbeg];
                SE = Ri + Rtab[thbeg] - kE * Ei;
                if (thbeg == nth + 1 + dijR && SE >= 0.0) {
                    if (kE == 0.0) {
                        Etmp = Ei + (Ri + Rtab[thbeg]) * dtrest;
                    } else {
                        Eeq_beg = (Ri + Rtab[thbeg]) / kE;
                        Etmp = Eeq_beg + (Ei - Eeq_beg) * Math.exp(-kE * dtrest);
                        Qtotth[thbeg] = Qtotth[thbeg] + Ri * dtrest + (Ei - Etmp);
                    }
                    dteff[thbeg] = dtrest;
                    dtrest = 0.0;
                    continue;
                }
                if (SE > 0.0) {
                    thend = Math.abs(Ei - Eth[thbeg + 1]) < 1.0E-15 ? thbeg + 2 : thbeg + 1;
                } else {
                    if (Math.abs(Ei - Eth[thbeg]) < 1.0E-15) {
                        // empty if block
                    }
                    thend = --thbeg;
                }
                if (thend == dijR) {
                    Etmp = Eth[1 + dijR];
                    Qtotth[1 + dijR] = Qtotth[1 + dijR] + Ri * dtrest + (Ei - Eth[1 + dijR]);
                    dteff[1 + dijR] = dtrest;
                    dtrest = 0.0;
                    continue;
                }
                kE = kth[thbeg];
                if (kE > 0.0) {
                    Eeq_beg = (Ri + Rtab[thbeg]) / kE;
                    if (Math.abs(Eth[thend] - Ei) < Math.abs(Eeq_beg - Ei)) {
                        tau = Math.log((Ei - Eeq_beg) / (Eth[thend] - Eeq_beg));
                        tau /= Math.max(kE, 1.0E-20);
                    } else {
                        tau = 2.0 * dtrest;
                    }
                } else {
                    tau = Math.abs(Ei - Eth[thend]) / Math.max(Math.abs(Ri), 1.0E-10);
                }
                if (tau < 0.0 || tau > dtrest) {
                    if (kE > 0.0) {
                        Etmp = Eeq_beg + (Ei - Eeq_beg) * Math.exp(-kE * dtrest);
                        Qtotth[thbeg] = Qtotth[thbeg] + Ri * dtrest + (Ei - Etmp);
                    } else {
                        Etmp = Ei + Ri * dtrest;
                    }
                    dteff[thbeg] = dtrest;
                    dtrest = 0.0;
                    continue;
                }
                double SEend = Ri + Rtab[thend] - kth[thend] * Eth[thend];
                dteff[thbeg] = tau;
                Etmp = Eth[thend];
                if (SE * SEend <= 0.0) {
                    Qtotth[thbeg] = Qtotth[thbeg] + Ri * tau + (Ei - Etmp);
                    dtrest = 0.0;
                } else {
                    Qtotth[thbeg] = Qtotth[thbeg] + Ri * tau + (Ei - Etmp);
                    thbeg = thend;
                    Ei = Etmp;
                    dtrest -= tau;
                }
                SE = SEend;
            }
        }
        for (int i = 0; i < Qtotth.length; ++i) {
            Qtotth[i] = Math.max(Qtotth[i], 0.0) / PAS;
        }
        return new EiSeuilsResults(Etmp, Qtotth, dteff, SE);
    }

    public static double[] MatVec(int nr, int[] nA, int[][] jA, double[][] AA, double[] x, double[] y) {
        for (int i = 0; i < nr; ++i) {
            y[i] = 0.0;
            for (int p = 0; p < nA[i]; ++p) {
                int j = jA[i][p];
                y[i] = y[i] + AA[i][p] * x[j];
            }
        }
        return y;
    }

    public static double[] TMatVec(int nr, int[] nA, int[][] jA, double[][] AA, double[] x, double[] y) {
        int i;
        for (i = 0; i < nr; ++i) {
            y[i] = 0.0;
        }
        for (int j = 0; j < nr; ++j) {
            for (int p = 0; p < nA[j]; ++p) {
                i = jA[j][p];
                y[i] = y[i] + AA[j][p] * x[j];
            }
        }
        return y;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double[] conjGrad(int nitmax, double eps, int nr, int[] nA, int[][] jA, double[][] AA, double[] b, double[] x, int nrmax, double small) {
        double[] p = new double[nrmax];
        double[] p0 = new double[nrmax];
        double[] r = new double[nrmax];
        double[] r0 = new double[nrmax];
        double[] x0 = new double[nrmax];
        double[] y = new double[nrmax];
        double[] z = new double[nrmax];
        if (nr >= 0) {
            System.arraycopy(b, 0, x0, 0, nr);
        }
        y = Functions.MatVec(nr, nA, jA, AA, x0, y);
        for (int i = 0; i < nr; ++i) {
            z[i] = b[i] - y[i];
        }
        r0 = Functions.TMatVec(nr, nA, jA, AA, z, r0);
        if (nr >= 0) {
            System.arraycopy(r0, 0, p0, 0, nr);
        }
        boolean iter = true;
        int nbit = 0;
        while (iter) {
            int i;
            ++nbit;
            y = Functions.MatVec(nr, nA, jA, AA, p0, y);
            z = Functions.TMatVec(nr, nA, jA, AA, y, z);
            double a1 = 0.0;
            double a2 = 0.0;
            for (i = 0; i < nr; ++i) {
                a1 += r0[i] * r0[i];
                a2 += z[i] * p0[i];
            }
            double alpha = 0.0;
            if (a2 == 0.0) {
                if (a1 != 0.0) throw new RuntimeException("Problem in ConjGrad");
                if (nr >= 0) {
                    System.arraycopy(x0, 0, x, 0, nr);
                }
                iter = false;
            } else {
                alpha = a1 / a2;
            }
            for (i = 0; i < nr; ++i) {
                x[i] = x0[i] + alpha * p0[i];
                r[i] = r0[i] - alpha * z[i];
            }
            double beta = 0.0;
            a1 = 0.0;
            a2 = 0.0;
            for (i = 0; i < nr; ++i) {
                a1 += r0[i] * r0[i];
                a2 += r[i] * r[i];
            }
            if (a2 > small) {
                beta = a2 / a1;
            } else {
                iter = false;
            }
            for (i = 0; i < nr; ++i) {
                p[i] = r[i] + beta * p0[i];
            }
            if (nbit > nitmax) {
                iter = false;
            }
            if (a2 < eps) {
                iter = false;
            }
            for (i = 0; i < nr; ++i) {
                p0[i] = p[i];
                r0[i] = r[i];
                x0[i] = x[i];
            }
        }
        return x;
    }

    public static SingleresResult singleres(double hmax, double hmin, double ks, double s, double Dt, double ht) {
        double thetaQrn;
        double Qb;
        double Qr;
        double heq = s / ks;
        double h0 = ht;
        if ((ht = heq + (h0 - heq) * Math.exp(-ks * Dt)) > hmax) {
            Qr = (ht - hmax) / Dt;
            ht = hmax;
            Qb = s - Qr + (h0 - ht) / Dt;
            thetaQrn = 1.0;
        } else if (ht < 0.0) {
            ht = 0.0;
            Qr = 0.0;
            Qb = Math.max(0.0, s + h0 / Dt);
            s = -h0 / Dt + Qb;
            thetaQrn = 0.0;
        } else {
            Qr = 0.0;
            Qb = Math.max(0.0, s + (h0 - ht) / Dt);
            s = (ht - h0) / Dt + Qb;
            thetaQrn = 0.0;
        }
        double Balance = s - Qb - Qr + (h0 - ht) / Dt;
        if (Math.abs(Balance) > 1.0E-10) {
            throw new RuntimeException("balance problem in singleres");
        }
        return new SingleresResult(ht, Qr, Qb, s, thetaQrn);
    }

    public static ResolTcinfResult resolTcinf(double h0, int nr, double[] theta, double[] h, double Qin, double Qout, double hmax, double hmin, double[] kIf, double PAS) {
        double s = h0 > hmin ? Qin - Qout : Qin;
        double hav = 0.0;
        double Qrtot = 0.0;
        double Qbtot = 0.0;
        double seff = 0.0;
        double thetaQr = 0.0;
        for (int n = 0; n < nr; ++n) {
            SingleresResult tmp = Functions.singleres(hmax, hmin, kIf[n], s, PAS, h[n]);
            h[n] = tmp.ht;
            double Qr = tmp.Qr;
            double Qb = tmp.Qb;
            hav += theta[n] * h[n];
            Qrtot += theta[n] * Qr;
            Qbtot += theta[n] * Qb;
            seff = theta[n] * tmp.s + seff;
            thetaQr += theta[n] * tmp.thetaQrn;
        }
        return new ResolTcinfResult(hav, Qrtot, Qbtot, h, -seff, thetaQr);
    }

    public static InitTcinfResult initTcinf(double alpha, double Tau0, int nr, double[] theta, double[] k, int nrmax, double tmax, double small, double eps, int nitmax, double[] phi) {
        int i;
        double xxx;
        int i2;
        int dtJR = -1;
        double[] t = new double[nrmax];
        int[] nA = new int[nrmax];
        int[][] jA = new int[nrmax][nrmax];
        double[][] AA = new double[nrmax][nrmax];
        double expo = Math.min(10.0, 50.0 * alpha);
        expo = Math.max(expo, 0.1);
        double yyy = 1.0 + alpha;
        yyy = 1.0 / yyy;
        for (i2 = 0; i2 < nr - 1; ++i2) {
            xxx = (double)(nr - (i2 - dtJR) + 1) / (double)nr;
            xxx = Math.pow(xxx, expo);
            xxx = Math.pow(xxx, -1.0 / alpha) - 1.0;
            t[i2] = xxx * Tau0;
            k[i2] = 2.0 / (t[i2] + Tau0);
        }
        t[nr + dtJR] = 1000.0 * Math.max(tmax, 10.0 * t[nr - 1 + dtJR]);
        k[nr + dtJR] = 0.1 / (t[nr + dtJR] + Tau0);
        for (i2 = 0; i2 < nr; ++i2) {
            nA[i2] = nr;
            for (int j = 0; j < nr; ++j) {
                jA[i2][j] = j;
                xxx = -k[j] * t[i2];
                AA[i2][j] = Math.exp(xxx);
            }
            xxx = Tau0 / (Tau0 + t[i2]);
            phi[i2] = Math.pow(xxx, alpha);
        }
        theta = Functions.conjGrad(nitmax, eps, nr, nA, jA, AA, phi, theta, nrmax, small);
        double theta_tot = 0.0;
        for (i = 0; i < nr; ++i) {
            theta[i] = Math.max(theta[i], 0.0);
            theta_tot += theta[i];
        }
        for (i = 0; i < nr; ++i) {
            theta[i] = theta[i] / theta_tot;
        }
        theta_tot = 0.0;
        for (i = 0; i < nr; ++i) {
            theta_tot += theta[i];
        }
        return new InitTcinfResult(k, theta);
    }

    public static double[] merror(double[] IN, double[] OUT, double[] STOCK1, double[] STOCK2, double[] STOCK3, double[] STOCK4, int t1, int t2) {
        double[] Merror = new double[t2 + 1];
        for (int i = t1; i <= t2; ++i) {
            Merror[i] = IN[i] - OUT[i] - STOCK1[i + 1] + STOCK1[i] - STOCK2[i + 1] + STOCK2[i] - STOCK3[i + 1] + STOCK3[i] - STOCK4[i + 1] + STOCK4[i];
        }
        return Merror;
    }

    private static double det22(double[] pMatrix22) {
        return pMatrix22[0] * pMatrix22[3] - pMatrix22[1] * pMatrix22[2];
    }

    private static double[] mult22v(double[] pMatrix22, double[] pVector) {
        return new double[]{pMatrix22[0] * pVector[0] + pMatrix22[1] * pVector[1], pMatrix22[2] * pVector[0] + pMatrix22[3] * pVector[1]};
    }

    private static double[] multv2(double[] pV1, double[] pV2) {
        return new double[]{pV1[0] * pV2[0], pV1[1] * pV2[1]};
    }

    private static double[] addv2(double[] pV1, double[] pV2) {
        return new double[]{pV1[0] + pV2[0], pV1[1] + pV2[1]};
    }

    private static double[] substractv2(double[] pV1, double[] pV2) {
        return new double[]{pV1[0] - pV2[0], pV1[1] - pV2[1]};
    }

    public static double sum(double[] pArray) {
        double sum = 0.0;
        for (double v : pArray) {
            sum += v;
        }
        return sum;
    }

    public static boolean arraysEqual(double[] t1, double[] t2, double precision) {
        if (t1.length != t2.length) {
            return false;
        }
        for (int i = 0; i < t1.length; ++i) {
            if (!(Math.abs(t1[i] - t2[i]) > precision)) continue;
            return false;
        }
        return true;
    }

    public static class InitTcinfResult {
        public double[] k;
        public double[] theta;

        public InitTcinfResult(double[] pK, double[] pTheta) {
            this.k = pK;
            this.theta = pTheta;
        }
    }

    public static class SingleresResult {
        public double ht;
        public double Qr;
        public double Qb;
        public double s;
        public double thetaQrn;

        public SingleresResult(double pHt, double pQr, double pQb, double pS, double pThetaQrn) {
            this.ht = pHt;
            this.Qr = pQr;
            this.Qb = pQb;
            this.s = pS;
            this.thetaQrn = pThetaQrn;
        }

        public SingleresResult() {
        }
    }

    public static class ResolTcinfResult {
        public double hav;
        public double Qbtot;
        public double Qrtot;
        public double[] h;
        public double s;
        public double thetaQr;

        public ResolTcinfResult(double pHav, double pQrtot, double pQbtot, double[] pH, double pS, double pThetaQr) {
            this.hav = pHav;
            this.Qbtot = pQbtot;
            this.Qrtot = pQrtot;
            this.h = pH;
            this.s = pS;
            this.thetaQr = pThetaQr;
        }
    }

    public static class EiSeuilsResults {
        public double Etmp;
        public double[] Qtotth;
        public double[] dteff;
        public double SE;

        public EiSeuilsResults(double pEtmp, double[] pQtotth, double[] pDteff, double pSE) {
            this.Etmp = pEtmp;
            this.Qtotth = pQtotth;
            this.dteff = pDteff;
            this.SE = pSE;
        }
    }
}

