/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run;

import fr.geonosis.karstmod.modele.InputData;
import fr.geonosis.karstmod.modele.KarstModConfig;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterSSI;
import fr.geonosis.karstmod.modele.StageBounds;
import fr.geonosis.karstmod.modele.montecarlo.AMSobolGenerator;
import fr.geonosis.karstmod.run.AbstractMonitor;
import fr.geonosis.karstmod.run.IRunListener;
import fr.geonosis.karstmod.run.SSIMonitorListener;
import fr.geonosis.karstmod.run.SSIRunner;
import fr.geonosis.karstmod.run.SSIRunnerData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.property.ReadOnlyListProperty;

public class SSIMonitor
extends AbstractMonitor {
    private int fN;
    private AtomicInteger fNbRun;
    private AtomicInteger fIndices;
    private SSIRunner fLastSsiRunner;
    private SSIRunnerData fLastSsiRunnerData;
    private final InputData fInputData;
    private final KarstModConfig fConfig;

    public SSIMonitor(KarstModConfig pConfig) {
        super(pConfig.getModel(), pConfig.getRunParameters().getWarmupBeginning(), (List<StageBounds>)pConfig.getRunParameters().getCalibrationStages(), (List<StageBounds>)pConfig.getRunParameters().getValidationStages(), pConfig.getRunParameters().getWobjFunction());
        this.fConfig = pConfig;
        this.fInputData = pConfig.getInputData();
    }

    public int next() {
        if (this.isStopped()) {
            return -1;
        }
        int res = this.fIndices.incrementAndGet();
        return res <= this.fN ? res : -1;
    }

    public void worked() {
        this.fNbRun.incrementAndGet();
        for (IRunListener listener : this.getListeners()) {
            ((SSIMonitorListener)listener).worked(this.fNbRun.get());
        }
    }

    @Override
    public boolean isDone() {
        return this.isStopped() || this.fNbRun.get() >= this.fN;
    }

    public Map<Parameter, ParameterSSI> computeIndexes(int N) {
        ReadOnlyListProperty<Parameter> activeParameters = this.getModel().getCalibrateParameters();
        int nbParams = activeParameters.size();
        AMSobolGenerator randomGenerator = this.fConfig.getRandomGenerator();
        this.fLastSsiRunner = new SSIRunner(this, randomGenerator, this.fInputData, this.getWobj());
        this.fLastSsiRunnerData = new SSIRunnerData(nbParams);
        return this.compute(N);
    }

    public Map<Parameter, ParameterSSI> compute(int N) {
        this.fN = N;
        this.fNbRun = new AtomicInteger();
        this.fIndices = new AtomicInteger();
        this.start();
        this.fLastSsiRunnerData = this.fLastSsiRunner.run(this.fLastSsiRunnerData, N);
        Parameter[] parameters = this.fLastSsiRunner.getParameters();
        int nbParams = parameters.length;
        HashMap<Parameter, ParameterSSI> res = new HashMap<Parameter, ParameterSSI>();
        for (int i = 0; i < nbParams; ++i) {
            res.put(parameters[i], this.fLastSsiRunner.getIndexes()[i]);
        }
        return res;
    }

    public KarstModConfig getConfig() {
        return this.fConfig;
    }
}

