/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.obj;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.obj.AbstractObjectiveFunction;
import fr.geonosis.karstmod.modele.obj.WobjVar;
import java.util.List;

public class KGE
extends AbstractObjectiveFunction {
    public static final String S_R = "sr";
    public static final String S_ALPHA = "sa";
    public static final String S_BETA = "sb";
    private double fAlpha;
    private double fBeta;
    private double fR;
    private double fSr;
    private double fSa;
    private double fSb;

    public KGE() {
        super(Messages.getString("KGE.0"), Messages.getString("KGE.0"));
        this.fSr = 1.0;
        this.fSa = 1.0;
        this.fSb = 1.0;
    }

    public KGE(List<AbstractObjectiveFunction.FctParam> pParameters) {
        super(Messages.getString("KGE.0"), Messages.getString("KGE.0"));
        for (AbstractObjectiveFunction.FctParam param : pParameters) {
            switch (param.getKey()) {
                case "sr": {
                    this.fSr = param.getValue();
                    break;
                }
                case "sa": {
                    this.fSa = param.getValue();
                    break;
                }
                case "sb": {
                    this.fSb = param.getValue();
                }
            }
        }
    }

    @Override
    public void init(WobjVar pObsVar, int pIOShift) {
        super.init(pObsVar, pIOShift);
        pObsVar.computeMean();
        pObsVar.computeStdDev();
    }

    @Override
    public double computeValue(WobjVar pSimVar) {
        pSimVar.computeMean();
        pSimVar.computeStdDev();
        this.fBeta = pSimVar.getMean() / this.fObsVar.getMean();
        this.fAlpha = pSimVar.getStdDev() / this.fObsVar.getStdDev();
        double prodSigma = pSimVar.getStdDev() * this.fObsVar.getStdDev();
        this.fR = 0.0;
        for (int i : this.getIndices()) {
            this.fR += (pSimVar.get(i) - pSimVar.getMean()) * (this.fObsVar.get(i) - this.fObsVar.getMean());
        }
        this.fR /= (double)(this.getIndices().length - 1) * prodSigma;
        return 1.0 - Math.sqrt(Math.pow(this.fSr * (this.fR - 1.0), 2.0) + Math.pow(this.fSa * (this.fAlpha - 1.0), 2.0) + Math.pow(this.fSb * (this.fBeta - 1.0), 2.0));
    }

    public double getAlpha() {
        return this.fAlpha;
    }

    public double getBeta() {
        return this.fBeta;
    }

    public double getR() {
        return this.fR;
    }

    public double phi() {
        return Math.atan2(this.fBeta - 1.0, this.fAlpha - 1.0);
    }

    public double eff() {
        return 1.0 - Math.sqrt((this.fBeta - 1.0) * (this.fBeta - 1.0) + (this.fAlpha - 1.0) * (this.fAlpha - 1.0) + (this.fR - 1.0) * (this.fR - 1.0));
    }
}

