/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.flow.law;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterList;
import fr.geonosis.karstmod.modele.RangeValidator;
import fr.geonosis.karstmod.modele.SensLoiVidange;
import fr.geonosis.karstmod.modele.TypeInit;
import fr.geonosis.karstmod.modele.TypeLoiVidange;
import fr.geonosis.karstmod.modele.flow.ClassicalDischargeFlow;
import fr.geonosis.karstmod.modele.flow.law.AbstractDischargeLaw;
import java.util.List;

public class LoiSeuil
extends AbstractDischargeLaw {
    public static final String K = Messages.getString("LoiSeuil.k");
    public static final String SEUIL = Messages.getString("LoiSeuil.E");
    public static final String ALPHA = Messages.getString("LoiSeuil.alpha");
    public static final String ATTR_K = "k";
    public static final String ATTR_EMAX = "Emax";
    public static final String ATTR_E = "threshold";
    public static final String ATTR_ALPHA = "alpha";
    private final boolean fGereEmax;
    private Parameter fK;
    private Parameter fSeuil;
    private Parameter fAlpha;

    public LoiSeuil(double pK, double pSeuil, boolean pGereEmax) {
        this.fParameters = new ParameterList();
        this.fGereEmax = pGereEmax;
        this.initParametres();
        this.fK.setValue(pK);
        this.fSeuil.setValue(pSeuil);
    }

    public LoiSeuil(double pK, double pSeuil) {
        this(pK, pSeuil, false);
    }

    @Override
    public void setFluxVidange(ClassicalDischargeFlow pFluxVidange) {
        this.fFluxVidange = pFluxVidange;
        for (Parameter p : this.getParameters()) {
            if (SEUIL.equals(p.getLabel())) {
                p.setLibelleHtml(p.getHtmlLabel().replaceAll(SEUIL, pFluxVidange.getSource().getName()));
                p.setLabel(p.getShortName().replaceAll(SEUIL, pFluxVidange.getSource().getName()));
            }
            p.setLabel(p.getShortName() + this.fFluxVidange.getName().substring(1));
            p.setLibelleHtml(p.getHtmlLabel() + this.fFluxVidange.getHtmlLabel().substring(this.fFluxVidange.getHtmlLabel().indexOf("<sub>")));
        }
    }

    @Override
    public void reset() {
    }

    private void initParametres() {
        this.fK = new Parameter(ATTR_K, K, "<i>" + K + "</i>", true, false, TypeInit.LOG, Dimension.K, 0.01, 1.0);
        this.fK.setValue(0.1);
        this.fParameters.add(this.fK);
        this.fSeuil = new Parameter(ATTR_E, SEUIL, "<i>" + SEUIL + "</i>", true, false, TypeInit.DEFAULT, Dimension.HEIGHT, 0.0, 200.0);
        this.fParameters.add(this.fSeuil);
        this.fSeuil.addValidator(new RangeValidator(0.0, true, null, false));
        this.fAlpha = new Parameter(ATTR_ALPHA, ALPHA, "<i>" + Messages.getString("LoiSeuil.2") + "</i>", false, true, TypeInit.LOG, Dimension.NONE, 0.2, 4.0);
        this.fAlpha.setValue(1.0);
        this.fParameters.add(this.fAlpha);
        this.fAlpha.addValidator(new RangeValidator(0.0, false, null, false));
        if (this.fGereEmax) {
            Parameter emax = new Parameter(ATTR_EMAX, ATTR_EMAX, "<i>E</i><sup>max</sup>", false, true, TypeInit.DEFAULT, Dimension.HEIGHT, 0.0, 200.0);
            this.fParameters.add(emax);
        }
        this.fK.addValidator(new RangeValidator(1.0E-15, true, null, false));
    }

    @Override
    public List<Parameter> getParameters() {
        return this.fParameters.list();
    }

    @Override
    public TypeLoiVidange getType() {
        return TypeLoiVidange.RAPIDE;
    }

    @Override
    public SensLoiVidange getSens() {
        return SensLoiVidange.ALLER;
    }

    @Override
    public String getName() {
        return Messages.getString("LoiSeuil.9");
    }

    @Override
    public String detail() {
        return this.getName() + "\n  - " + K + " : " + this.fK + "\n  - " + SEUIL + " : " + this.fSeuil;
    }

    @Override
    public String getToolTip(String pDe, String pA) {
        String dh = this.fFluxVidange.getSource().getHtmlLabel() + "-" + this.fSeuil.getHtmlLabel();
        return Messages.getString("LoiSeuil.14") + " " + pDe + " " + Messages.getString("LoiSeuil.17") + " " + pA + ", " + Messages.getString("LoiSeuil.20").replaceAll("@@source", this.fFluxVidange.getSource().getName()) + "<br/>" + this.fFluxVidange.getHtmlLabel() + "=" + this.fK.getHtmlLabel() + "(" + dh + ")<sup>" + this.fAlpha.getHtmlLabel() + "</sup><br/>(" + this.fAlpha.getHtmlLabel() + "=1 if not checked)";
    }

    @Override
    public boolean needsAlwaysCompute() {
        return false;
    }
}

