/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.flow.law;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.InvertedParent;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterList;
import fr.geonosis.karstmod.modele.RangeValidator;
import fr.geonosis.karstmod.modele.Reservoir;
import fr.geonosis.karstmod.modele.SensLoiVidange;
import fr.geonosis.karstmod.modele.TypeInit;
import fr.geonosis.karstmod.modele.TypeLoiVidange;
import fr.geonosis.karstmod.modele.flow.ClassicalDischargeFlow;
import fr.geonosis.karstmod.modele.flow.law.AbstractDischargeLaw;
import fr.geonosis.karstmod.modele.reservoirconfig.ClassicalReservoirConfig;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfigType;

public class LoiLineaire
extends AbstractDischargeLaw {
    public static final String K = Messages.getString("LoiLineaire.0");
    public static final String ALPHA = Messages.getString("LoiLineaire.2");
    public static final String X = Messages.getString("LoiLineaire.3");
    public static final String ATTR_K = "k";
    public static final String ATTR_ALPHA = "alpha";
    public static final String ATTR_X = "x";
    private Parameter fK;
    private Parameter fAlpha;
    private Parameter fX;
    private final ClassicalDischargeFlow fXSource;
    private final double fMin;

    public LoiLineaire(double pK) {
        this(pK, -1.7976931348623157E308);
    }

    public LoiLineaire(double pK, double pMin) {
        this.fMin = pMin;
        this.fXSource = null;
        this.fParameters = new ParameterList();
        this.initParametres();
        this.fK.setValue(pK);
    }

    public LoiLineaire(double pK, double pMin, ClassicalDischargeFlow pXSource) {
        this.fMin = pMin;
        this.fXSource = pXSource;
        this.fParameters = new ParameterList();
        this.initParametres();
        this.fK.setValue(pK);
        this.fX.getParentsHandler().addParent(this.fXSource);
    }

    @Override
    public void setFluxVidange(ClassicalDischargeFlow pFluxVidange) {
        this.fFluxVidange = pFluxVidange;
        for (Parameter p : this.getParameters()) {
            p.setLabel(p.getShortName() + (this.fFluxVidange.getName().length() > 0 ? this.fFluxVidange.getName().substring(1) : ""));
            p.setLibelleHtml(p.getHtmlLabel() + (this.fFluxVidange.getName().length() > 0 ? this.fFluxVidange.getHtmlLabel().substring(this.fFluxVidange.getHtmlLabel().indexOf("<sub>")) : ""));
        }
    }

    @Override
    public void reset() {
    }

    private void initParametres() {
        if (this.fXSource != null) {
            this.fX = new Parameter(ATTR_X, X, "<i>" + Messages.getString("LoiLineaire.3") + "</i>", false, true, TypeInit.DEFAULT, Dimension.NONE, 0.0, 1.0);
            this.fX.setValue(0.5);
            this.fParameters.add(this.fX);
            this.fX.addValidator(new RangeValidator(0.0, true, 1.0, true));
            this.fK = new Parameter(ATTR_K, K, "<i>" + K + "</i>", true, false, TypeInit.LOG, Dimension.K, 1.0E-4, 0.01);
            this.fParameters.add(this.fK);
            this.fAlpha = new Parameter(ATTR_ALPHA, ALPHA, "<i>" + Messages.getString("LoiLineaire.1") + "</i>", false, true, TypeInit.LOG, Dimension.NONE, 0.2, 4.0);
            this.fParameters.add(this.fAlpha);
            this.fAlpha.addValidator(new RangeValidator(0.0, false, null, false));
            this.fX.selectedProperty().addListener((pObservable, pOldValue, pNewValue) -> {
                this.fK.activeProperty().set(this.fK.isActive());
                this.fAlpha.activeProperty().set(this.fAlpha.isActive());
            });
            this.fK.getParentsHandler().addParent(new InvertedParent(this.fX));
            this.fAlpha.getParentsHandler().addParent(new InvertedParent(this.fX));
        } else {
            this.fK = new Parameter(ATTR_K, K, "<i>" + K + "</i>", true, false, TypeInit.LOG, Dimension.K, 1.0E-4, 0.01);
            this.fParameters.add(this.fK);
            this.fAlpha = new Parameter(ATTR_ALPHA, ALPHA, "<i>" + Messages.getString("LoiLineaire.1") + "</i>", false, true, TypeInit.LOG, Dimension.NONE, 0.2, 4.0);
            this.fParameters.add(this.fAlpha);
            this.fAlpha.addValidator(new RangeValidator(0.0, false, null, false));
        }
        this.fK.setValue(0.1);
        this.fAlpha.setValue(1.0);
        this.fK.addValidator(new RangeValidator(1.0E-15, true, null, false));
    }

    @Override
    public TypeLoiVidange getType() {
        return TypeLoiVidange.LENTE;
    }

    @Override
    public SensLoiVidange getSens() {
        return SensLoiVidange.ALLER;
    }

    @Override
    public String getName() {
        return Messages.getString("LoiLineaire.5");
    }

    @Override
    public String detail() {
        return this.getName() + "\n  - " + K + " : " + this.fK;
    }

    @Override
    public String getToolTip(String pDe, String pA) {
        Parameter hMin;
        String dh = this.fFluxVidange.getSource().getHtmlLabel();
        if (this.fXSource != null) {
            return Messages.getString("LoiLineaire.9") + " " + pDe + " " + Messages.getString("LoiLineaire.12") + " " + pA + "<br/>if " + this.fX.getHtmlLabel() + "is checked<br/>&#009;" + this.fFluxVidange.getHtmlLabel() + "=" + this.fX.getHtmlLabel() + this.fXSource.getHtmlLabel() + "<br/>else<br/>&#009;" + this.fFluxVidange.getHtmlLabel() + "=" + this.fK.getHtmlLabel() + "max(sgn(" + dh + ")|" + dh + "|<sup>" + this.fAlpha.getHtmlLabel() + "</sup>, " + this.fMin + ")<br/>(" + this.fAlpha.getHtmlLabel() + "=1 if not checked)";
        }
        Object cplt = "";
        if (this.fFluxVidange.getSource() instanceof Reservoir && (hMin = ((ClassicalReservoirConfig)((Reservoir)this.fFluxVidange.getSource()).getConfig(ReservoirConfigType.CLASSICAL)).getHmin()) != null && hMin.isActive()) {
            cplt = " enabled for " + dh + ">0";
        }
        return Messages.getString("LoiLineaire.9") + " " + pDe + " " + Messages.getString("LoiLineaire.12") + " " + pA + "<br/>" + this.fFluxVidange.getHtmlLabel() + "=" + this.fK.getHtmlLabel() + dh + "<sup>" + this.fAlpha.getHtmlLabel() + "</sup>" + (String)cplt + "<br/>(" + this.fAlpha.getHtmlLabel() + "=1 if not checked)";
    }

    public Parameter getK() {
        return this.fK;
    }

    public Parameter getAlpha() {
        return this.fAlpha;
    }

    public Parameter getX() {
        return this.fX;
    }

    @Override
    public boolean needsAlwaysCompute() {
        return false;
    }
}

