/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.flow.law;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.IElement;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.ModeKarstMod;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterList;
import fr.geonosis.karstmod.modele.RangeValidator;
import fr.geonosis.karstmod.modele.SensLoiVidange;
import fr.geonosis.karstmod.modele.TypeInit;
import fr.geonosis.karstmod.modele.TypeLoiVidange;
import fr.geonosis.karstmod.modele.flow.ClassicalDischargeFlow;
import fr.geonosis.karstmod.modele.flow.FlowNode;
import fr.geonosis.karstmod.modele.flow.law.AbstractDischargeLaw;

public class LoiDerivation
extends AbstractDischargeLaw {
    public static final String ATTR_P = "xhy";
    private Parameter fP;

    public LoiDerivation(double pP, String pLibelle, String pLibelleHtml) {
        this.fParameters = new ParameterList();
        this.initParametres(pLibelle, pLibelleHtml);
        this.fP.setValue(pP);
    }

    @Override
    public void setFluxVidange(ClassicalDischargeFlow pFluxVidange) {
        this.fFluxVidange = pFluxVidange;
    }

    @Override
    public void reset() {
    }

    private void initParametres(String pLibelle, String pLibelleHtml) {
        this.fP = new Parameter(ATTR_P, pLibelle, pLibelleHtml, true, false, TypeInit.DEFAULT, Dimension.P, 0.0, 1.0){

            @Override
            public MessageList validate() {
                MessageList messages = super.validate();
                if (this.getMode() == ModeKarstMod.CALIBRATION) {
                    if (this.getMin() < 0.0) {
                        messages.addError(Messages.getString("LoiDerivation.1"), this.getLabel());
                    }
                    if (this.getMax() > 1.0) {
                        messages.addError(Messages.getString("LoiDerivation.2"), this.getLabel());
                    }
                } else if (this.getValue() > 1.0) {
                    messages.addError(Messages.getString("LoiDerivation.3"), this.getLabel());
                }
                return messages;
            }
        };
        this.fParameters.add(this.fP);
        this.fP.addValidator(new RangeValidator(0.0, true, 1.0, true));
    }

    @Override
    public TypeLoiVidange getType() {
        return TypeLoiVidange.LENTE;
    }

    @Override
    public SensLoiVidange getSens() {
        return SensLoiVidange.ALLER;
    }

    @Override
    public String getName() {
        return Messages.getString("LoiLineaire.5");
    }

    @Override
    public String detail() {
        return this.getName() + "\n  - " + this.getP().getLabel() + " : " + this.fP;
    }

    @Override
    public String getToolTip(String pDe, String pA) {
        return this.fFluxVidange.getHtmlLabel() + " = " + this.fP.getHtmlLabel() + ((IElement)((FlowNode)this.fFluxVidange.getSource()).getSource()).getHtmlLabel();
    }

    public Parameter getP() {
        return this.fP;
    }

    @Override
    public boolean needsAlwaysCompute() {
        return true;
    }
}

