/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.flow;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.ICible;
import fr.geonosis.karstmod.modele.IParametrable;
import fr.geonosis.karstmod.modele.ISource;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.Reservoir;
import fr.geonosis.karstmod.modele.flow.Flow;
import fr.geonosis.karstmod.modele.flow.law.IDischargeLaw;
import fr.geonosis.karstmod.modele.reservoirconfig.ClassicalReservoirConfig;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfigType;

public class ClassicalDischargeFlow
extends Flow
implements IParametrable {
    private static final String VIDANGE = Messages.getString("FluxVidange.0");
    private final IDischargeLaw fDischargeLaw;
    private final boolean fBidirectionnel;
    private final ICible fCible;

    public ClassicalDischargeFlow(ISource pSource, ICible pCible, boolean pBidirectionnel, IDischargeLaw pLoiVidange, String pName, String pLibelleHtml) {
        this(pSource, pCible, pBidirectionnel, pLoiVidange, pName, pLibelleHtml, null);
    }

    public ClassicalDischargeFlow(ISource pSource, ICible pCible, boolean pBidirectionnel, IDischargeLaw pLoiVidange, String pName, String pLibelleHtml, String pPropertyName) {
        this(pSource, pCible, pBidirectionnel, pLoiVidange, pName, pLibelleHtml, pPropertyName, true);
    }

    public ClassicalDischargeFlow(ISource pSource, ICible pCible, boolean pBidirectionnel, IDischargeLaw pLoiVidange, String pName, String pLibelleHtml, String pPropertyName, boolean pActivable) {
        super(pSource, pName, pLibelleHtml, pPropertyName == null ? pName : pPropertyName, pActivable);
        Parameter hMin;
        this.fDischargeLaw = pLoiVidange;
        this.initParametres();
        this.fDischargeLaw.setFluxVidange(this);
        this.fCible = pCible;
        this.fCible.addInput(this);
        this.fBidirectionnel = pBidirectionnel;
        this.tooltipTextproperty().set((Object)this.fDischargeLaw.getToolTip(this.fSource.getHtmlLabel(), this.fCible.getHtmlLabel()));
        this.fSource.htmlLabelProperty().addListener((ob, o, n) -> this.tooltipTextproperty().set((Object)this.fDischargeLaw.getToolTip(this.fSource.getHtmlLabel(), this.fCible.getHtmlLabel())));
        this.fCible.htmlLabelProperty().addListener((ob, o, n) -> this.tooltipTextproperty().set((Object)this.fDischargeLaw.getToolTip(this.fSource.getHtmlLabel(), this.fCible.getHtmlLabel())));
        if (this.fSource instanceof Reservoir && (hMin = ((ClassicalReservoirConfig)((Reservoir)this.fSource).getConfig(ReservoirConfigType.CLASSICAL)).getHmin()) != null) {
            hMin.activeProperty().addListener((ob, o, n) -> this.tooltipTextproperty().set((Object)this.fDischargeLaw.getToolTip(this.fSource.getHtmlLabel(), this.fCible.getHtmlLabel())));
        }
    }

    public ICible getCible() {
        return this.fCible;
    }

    public boolean isBidirectionnel() {
        return this.fBidirectionnel;
    }

    private void initParametres() {
        this.addParameters(this.fDischargeLaw.getParameters());
    }

    public String toString() {
        return VIDANGE + " " + this.getName();
    }

    @Override
    public String toStringHtml() {
        return VIDANGE + " " + this.getHtmlLabel();
    }

    @Override
    public MessageList validate() {
        MessageList messages = super.validate();
        if (this.fDischargeLaw == null) {
            messages.addError(Messages.getString("FluxVidange.4"), this.getName());
        }
        return messages;
    }

    @Override
    public String detail() {
        return super.detail() + "  - " + Messages.getString("FluxVidange.6") + " " + this.fDischargeLaw.detail();
    }

    @Override
    public void disable(int pT) {
    }

    public IDischargeLaw getDischargeLaw() {
        return this.fDischargeLaw;
    }
}

