/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.Messages;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class StageBounds
implements Comparable<StageBounds> {
    private static final String CAR = Messages.getString("Periode.0");
    private static final String LA_PERIODE_FOURNIE_EST_INCORRECTE = Messages.getString("Periode.1");
    private final int fDebut;
    private final int fFin;

    public StageBounds(int pDebut, int pFin) throws IllegalArgumentException {
        if (pDebut > pFin) {
            throw new IllegalArgumentException(LA_PERIODE_FOURNIE_EST_INCORRECTE + " " + CAR + " " + pDebut + " > " + pFin);
        }
        this.fDebut = pDebut;
        this.fFin = pFin;
    }

    public StageBounds(String pPeriode, int pMaxIndex) throws ParseException {
        String sMax;
        String sMin;
        String[] ts = pPeriode.replaceAll("end", String.valueOf(pMaxIndex)).split("-");
        if (ts.length == 1) {
            sMax = sMin = ts[0];
        } else if (ts.length == 2) {
            sMin = ts[0];
            sMax = ts[1];
        } else {
            throw new ParseException(LA_PERIODE_FOURNIE_EST_INCORRECTE + " : " + pPeriode + ". " + Messages.getString("Periode.7"), 0);
        }
        try {
            this.fDebut = Integer.parseInt(sMin.trim());
            this.fFin = Math.min(Integer.parseInt(sMax.trim()), pMaxIndex);
        }
        catch (NumberFormatException ex) {
            throw new ParseException(LA_PERIODE_FOURNIE_EST_INCORRECTE + " (" + pPeriode + ")", 0);
        }
        if (this.fDebut > this.fFin) {
            throw new ParseException(LA_PERIODE_FOURNIE_EST_INCORRECTE + " " + CAR + " " + this.fDebut + " > " + this.fFin, 0);
        }
    }

    public StageBounds(int pWarmupBeginning, List<StageBounds> pCalibrationStages, List<StageBounds> pValidationStages) {
        int debut = Integer.MAX_VALUE;
        int fin = Integer.MIN_VALUE;
        ArrayList<StageBounds> stages = new ArrayList<StageBounds>(pCalibrationStages);
        stages.addAll(pValidationStages);
        for (StageBounds p : stages) {
            if (p.getDebut() < debut) {
                debut = p.getDebut();
            }
            if (p.getFin() <= fin) continue;
            fin = p.getFin();
        }
        this.fDebut = Math.min(pWarmupBeginning, debut);
        this.fFin = fin;
    }

    public int getDebut() {
        return this.fDebut;
    }

    public int getFin() {
        return this.fFin;
    }

    public boolean chevauche(StageBounds pPeriode) {
        return this.fFin >= pPeriode.fDebut && this.fDebut <= pPeriode.fFin;
    }

    public boolean suit(StageBounds pPeriode) {
        return this.fDebut == pPeriode.fFin + 1;
    }

    public String toString() {
        return this.fDebut + "-" + this.fFin;
    }

    public int taille() {
        return this.fFin - this.fDebut + 1;
    }

    @Override
    public int compareTo(StageBounds pPeriode) {
        return this.fDebut - pPeriode.fDebut;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fDebut;
        result = 31 * result + this.fFin;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StageBounds other = (StageBounds)obj;
        if (this.fDebut != other.fDebut) {
            return false;
        }
        return this.fFin == other.fFin;
    }
}

