/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.modele.DefaultParameterValidator;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.ModeKarstMod;
import fr.geonosis.karstmod.modele.Parameter;

public class RangeValidator
extends DefaultParameterValidator {
    private final Double fMax;
    private final Double fMin;
    private final boolean fIncludeMin;
    private final boolean fIncludeMax;
    private String fMinMessage;
    private String fMaxMessage;

    public RangeValidator(Double pMin, boolean pIncludeMin, Double pMax, boolean pIncludeMax) {
        this.fMin = pMin;
        this.fMax = pMax;
        this.fIncludeMin = pIncludeMin;
        this.fIncludeMax = pIncludeMax;
    }

    public RangeValidator(Double pMin, boolean pIncludeMin, Double pMax, boolean pIncludeMax, String pMinMessage, String pMaxMessage) {
        this.fMin = pMin;
        this.fMax = pMax;
        this.fIncludeMin = pIncludeMin;
        this.fIncludeMax = pIncludeMax;
        this.fMinMessage = pMinMessage;
        this.fMaxMessage = pMaxMessage;
    }

    public RangeValidator(Double pMin, boolean pIncludeMin, Double pMax, boolean pIncludeMax, Parameter ... pChainedParameters) {
        super(pChainedParameters);
        this.fMin = pMin;
        this.fMax = pMax;
        this.fIncludeMin = pIncludeMin;
        this.fIncludeMax = pIncludeMax;
    }

    @Override
    public MessageList validate(Parameter pParameter) {
        MessageList list = new MessageList();
        if (pParameter.getMode() == ModeKarstMod.CALIBRATION) {
            if (this.fMin != null && (this.fIncludeMin && (pParameter.getMin() < this.fMin || pParameter.getMax() < this.fMin) || !this.fIncludeMin && (pParameter.getMin() <= this.fMin || pParameter.getMax() <= this.fMin))) {
                list.addError((String)(this.fMinMessage == null ? "Value must be greater than " + (this.fIncludeMin ? "or equal to " : "") + this.fMin : this.fMinMessage), pParameter.getLabel());
            }
            if (this.fMax != null && (this.fIncludeMax && (pParameter.getMin() > this.fMax || pParameter.getMax() > this.fMax) || !this.fIncludeMax && (pParameter.getMax() >= this.fMax || pParameter.getMax() >= this.fMax))) {
                list.addError((String)(this.fMaxMessage == null ? "Values must be lesser than " + (this.fIncludeMax ? "or equal to " : "") + this.fMax : this.fMaxMessage), pParameter.getLabel());
            }
        } else {
            if (this.fMin != null && (this.fIncludeMin && pParameter.getValue() < this.fMin || !this.fIncludeMin && pParameter.getValue() <= this.fMin)) {
                list.addError((String)(this.fMinMessage == null ? "Value must be greater than " + (this.fIncludeMin ? "or equal to " : "") + this.fMin : this.fMinMessage), pParameter.getLabel());
            }
            if (this.fMax != null && (this.fIncludeMax && pParameter.getValue() > this.fMax || !this.fIncludeMax && pParameter.getValue() >= this.fMax)) {
                list.addError((String)(this.fMaxMessage == null ? "Values must be lesser than " + (this.fIncludeMax ? "or equal to " : "") + this.fMax : this.fMaxMessage), pParameter.getLabel());
            }
        }
        return list;
    }
}

