/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.modele.AbstractElement;
import fr.geonosis.karstmod.modele.DefaultParameterValidator;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.IFlowGroupElement;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.RangeValidator;
import fr.geonosis.karstmod.modele.TypeInit;

public class PetRoutine
extends AbstractElement
implements IFlowGroupElement {
    public static final String ATTR_LATITUDE = "latitude";
    public static final String ATTR_K1 = "k1";
    public static final String ATTR_K2 = "k2";
    private Parameter fLatitude;
    private Parameter fK1;
    private Parameter fK2;

    public PetRoutine() {
        super("PET routine", "PET routine", "PET routine");
        this.setAlwaysVisible(true);
        this.initParametres();
        this.tooltipTextproperty().set((Object)("<html>" + this.getHtmlLabel() + "</html>"));
        this.htmlLabelProperty().addListener((ob, o, n) -> this.tooltipTextproperty().set((Object)("<html>" + this.getHtmlLabel() + "</html>")));
    }

    private void initParametres() {
        this.fLatitude = new Parameter(ATTR_LATITUDE, ATTR_LATITUDE, "Latitude", true, false, TypeInit.DEFAULT, Dimension.ANGLE, Double.NaN, Double.NaN);
        this.fLatitude.addValidator(new RangeValidator(-180.0, true, 180.0, true));
        this.fLatitude.setConstant(true);
        this.addParameter(this.fLatitude);
        this.fK1 = new Parameter(ATTR_K1, ATTR_K1, "k<sub>1</sub>", true, false, TypeInit.DEFAULT, Dimension.TEMPERATURE, 100.0, 100.0);
        this.fK1.addValidator(new RangeValidator(0.0, true, (Double)Double.MAX_VALUE, true));
        this.fK1.addValidator(new DefaultParameterValidator(){

            @Override
            public MessageList validate(Parameter pParameter) {
                MessageList list = new MessageList();
                if (pParameter.getMin() < 90.0 || pParameter.getMax() > 110.0) {
                    list.addWarning("Recommended values are between 90 and 110\u00b0C", pParameter.getLabel());
                }
                return list;
            }
        });
        this.addParameter(this.fK1);
        this.fK2 = new Parameter(ATTR_K2, ATTR_K2, "k<sub>2</sub>", true, false, TypeInit.DEFAULT, Dimension.TEMPERATURE, 5.0, 5.0);
        this.fK2.addValidator(new RangeValidator(0.0, false, (Double)Double.MAX_VALUE, false));
        this.fK2.addValidator(new DefaultParameterValidator(){

            @Override
            public MessageList validate(Parameter pParameter) {
                MessageList list = new MessageList();
                if (pParameter.getMax() > 10.0) {
                    list.addWarning("Recommended values are between 0 and 10\u00b0C", pParameter.getLabel());
                }
                return list;
            }
        });
        this.addParameter(this.fK2);
    }

    public String toString() {
        return this.getName();
    }

    public String toStringHtml() {
        return this.getHtmlLabel();
    }

    @Override
    public String detail() {
        return super.detail() + "  - ET routine :   - latitude : " + this.fLatitude + "  - k1 : " + this.fK1 + "  - k2 : " + this.fK2 + "\n";
    }

    @Override
    public String getHtmlFormulaLabel() {
        return this.getHtmlLabel();
    }

    public Parameter getK1() {
        return this.fK1;
    }

    public Parameter getK2() {
        return this.fK2;
    }

    public Parameter getLatitude() {
        return this.fLatitude;
    }
}

