/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterConstraintType;
import fr.geonosis.karstmod.modele.observable.IChild;
import fr.geonosis.karstmod.modele.observable.ParentsHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class ParameterConstraint
implements IChild,
Observable {
    public static final String ATTR_SELECTED = "selected";
    public static final String ATTR_TYPE = "type";
    private final Parameter fParameter;
    private final Parameter fParent;
    private final IntegerProperty fTypeProperty;
    private final BooleanProperty fSelectedProperty;
    private final BooleanProperty fActiveProperty;
    private final ParentsHandler fParentsHandler;
    private final List<InvalidationListener> fListeners = new ArrayList<InvalidationListener>();
    private final BooleanProperty fCalibrateProperty;

    public ParameterConstraint(Parameter pParent, Parameter pParameter) {
        this.fParent = pParent;
        this.fParameter = pParameter;
        this.fSelectedProperty = new SimpleBooleanProperty();
        this.fTypeProperty = new SimpleIntegerProperty();
        this.fActiveProperty = new SimpleBooleanProperty();
        this.fCalibrateProperty = new SimpleBooleanProperty(false);
        this.fSelectedProperty.addListener((pObservable, pOldValue, pNewValue) -> this.fActiveProperty.set(this.isActive()));
        for (Property property : new Property[]{this.fSelectedProperty, this.fTypeProperty}) {
            property.addListener((pObservable, pOldValue, pNewValue) -> this.fireChanged());
        }
        for (Property property : new Property[]{this.fActiveProperty, this.fTypeProperty, this.fParameter.minProperty(), this.fParameter.maxProperty(), this.fParent.minProperty(), this.fParent.maxProperty()}) {
            property.addListener((pObservable, pOldValue, pNewValue) -> this.fCalibrateProperty.set(this.needsCalibration()));
        }
        this.fSelectedProperty.set(false);
        this.fTypeProperty.set(ParameterConstraintType.EQUAL.ordinal());
        this.fParentsHandler = new ParentsHandler(this);
        this.fParentsHandler.addParent(pParameter);
        this.fParent.setConstraint(this);
    }

    public ParameterConstraintType getType() {
        return ParameterConstraintType.values()[this.fTypeProperty.get()];
    }

    public void setType(ParameterConstraintType pType) {
        this.fTypeProperty.set(pType.ordinal());
    }

    public Parameter getParameter() {
        return this.fParameter;
    }

    @Override
    public boolean isSelected() {
        return this.fSelectedProperty.get();
    }

    @Override
    public boolean isActive() {
        return this.fSelectedProperty.get() && this.fParentsHandler.isActive();
    }

    public void setSelected(boolean pSelected) {
        this.fSelectedProperty.set(pSelected);
    }

    public boolean isEnable() {
        return this.fParentsHandler.isActive();
    }

    public void save(Properties pProperties, String pPrefixe, boolean pActiveOnly) {
        if (!pActiveOnly || this.isActive()) {
            pProperties.put(pPrefixe + ATTR_SELECTED, String.valueOf(this.fSelectedProperty.get()));
            pProperties.put(pPrefixe + ATTR_TYPE, String.valueOf((Object)this.getType()));
        }
    }

    public void load(Properties pProperties, String pPrefixe) throws Exception {
        this.setSelected(Boolean.parseBoolean(pProperties.getProperty(pPrefixe + ATTR_SELECTED, "false")));
        this.setType(ParameterConstraintType.valueOf(pProperties.getProperty(pPrefixe + ATTR_TYPE, ParameterConstraintType.EQUAL.toString())));
    }

    public double applyTo(double pValue) {
        switch (this.getType()) {
            case EQUAL: {
                return this.fParameter.getValue();
            }
            case GREATER: {
                return Math.max(pValue, this.fParameter.getValue());
            }
            case LESSER: {
                return Math.min(pValue, this.fParameter.getValue());
            }
        }
        return Double.NaN;
    }

    public boolean needsCalibration() {
        if (!this.isActive()) {
            return false;
        }
        switch (this.getType()) {
            case EQUAL: {
                return false;
            }
            case GREATER: {
                if (this.fParent.getMax() == null || this.fParameter.getMax() == null) {
                    return false;
                }
                return this.fParent.getMax() > this.fParameter.getMax();
            }
            case LESSER: {
                if (this.fParent.getMin() == null || this.fParameter.getMin() == null) {
                    return false;
                }
                return this.fParent.getMin() < this.fParameter.getMin();
            }
        }
        return false;
    }

    @Override
    public ParentsHandler getParentsHandler() {
        return this.fParentsHandler;
    }

    public BooleanProperty selectedProperty() {
        return this.fSelectedProperty;
    }

    @Override
    public BooleanProperty activeProperty() {
        return this.fActiveProperty;
    }

    public IntegerProperty typeProperty() {
        return this.fTypeProperty;
    }

    public void addListener(InvalidationListener pListener) {
        this.fListeners.add(pListener);
    }

    public void removeListener(InvalidationListener pListener) {
        this.fListeners.remove(pListener);
    }

    private void fireChanged() {
        for (InvalidationListener listener : this.fListeners) {
            listener.invalidated((Observable)this);
        }
    }

    public BooleanProperty calibrateProperty() {
        return this.fCalibrateProperty;
    }
}

