/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.dbe.util.commun.ColorUtils;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.DefaultParameterValidator;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.Exterieur;
import fr.geonosis.karstmod.modele.Exutoire;
import fr.geonosis.karstmod.modele.ICible;
import fr.geonosis.karstmod.modele.IElement;
import fr.geonosis.karstmod.modele.ISource;
import fr.geonosis.karstmod.modele.InvertedParent;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.ModeKarstMod;
import fr.geonosis.karstmod.modele.ParamChoiceType;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterConstraint;
import fr.geonosis.karstmod.modele.PetRoutine;
import fr.geonosis.karstmod.modele.RangeValidator;
import fr.geonosis.karstmod.modele.Reservoir;
import fr.geonosis.karstmod.modele.SnowRoutine;
import fr.geonosis.karstmod.modele.TypeInit;
import fr.geonosis.karstmod.modele.flow.ClassicalDischargeFlow;
import fr.geonosis.karstmod.modele.flow.DataFlow;
import fr.geonosis.karstmod.modele.flow.Flow;
import fr.geonosis.karstmod.modele.flow.FlowNode;
import fr.geonosis.karstmod.modele.flow.InfiniteTcDischargeFlow;
import fr.geonosis.karstmod.modele.flow.law.Hysteresis;
import fr.geonosis.karstmod.modele.flow.law.LoiDerivation;
import fr.geonosis.karstmod.modele.flow.law.LoiHauteurRelative;
import fr.geonosis.karstmod.modele.flow.law.LoiHysteresis;
import fr.geonosis.karstmod.modele.flow.law.LoiLineaire;
import fr.geonosis.karstmod.modele.flow.law.LoiSeuil;
import fr.geonosis.karstmod.modele.flow.law.NashFallLaw;
import fr.geonosis.karstmod.modele.obj.parser.Varname;
import fr.geonosis.karstmod.modele.observable.IChild;
import fr.geonosis.karstmod.modele.reservoirconfig.ClassicalReservoirConfig;
import fr.geonosis.karstmod.modele.reservoirconfig.InfiniteTcReservoirConfig;
import fr.geonosis.karstmod.modele.reservoirconfig.NashFallReservoirConfig;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfig;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfigType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;

public class Model
implements Observable {
    public static final String LINKED_RESERVOIRS = "linkedReservoirs";
    public static final String XLOSS = "xLoss";
    public static final String XC = "xc";
    public static final String XEM = "xEM";
    public static final String XEC = "xEC";
    private static final String LOSS_NAME = "loss";
    private static final String PREFIXE = "model.";
    private final List<IElement> fElements;
    private final Exutoire fExutoire;
    private final Reservoir fReservoirE;
    private final Reservoir fReservoirM;
    private final Reservoir fReservoirC;
    private final Reservoir fReservoirL;
    private final DataFlow fFluxRainfall;
    private final DataFlow fFluxET;
    private final DataFlow fFluxQPumpC;
    private final DataFlow fFluxQPumpM;
    private final DataFlow fFluxQPumpL;
    private final DataFlow fFluxQPumpS;
    private final DataFlow fFluxQSinkC;
    private final DataFlow fFluxQSinkM;
    private final DataFlow fFluxQSinkL;
    private final DataFlow fFluxQSinkS;
    private final Exterieur fExterieur;
    private final Exterieur fLoss;
    private final List<InvalidationListener> fListeners = new ArrayList<InvalidationListener>();
    private final ReadOnlyListWrapper<Reservoir> fActiveReservoirList = new ReadOnlyListWrapper(FXCollections.observableArrayList());
    private final ClassicalReservoirConfig fConfigEClassical;
    private final ClassicalDischargeFlow fQloss;
    private final ClassicalDischargeFlow fQES;
    private final ClassicalDischargeFlow fQE;
    private final ClassicalDischargeFlow fQEM;
    private final ClassicalDischargeFlow fQEC;
    private final ClassicalDischargeFlow fQEL;
    private final ClassicalDischargeFlow fQhy;
    private final ClassicalDischargeFlow fQhyES;
    private final ClassicalDischargeFlow fQhyEC;
    private final ReservoirConfig fConfigEInf;
    private final InfiniteTcDischargeFlow fQbE;
    private final InfiniteTcDischargeFlow fQrE;
    private final ReservoirConfig fConfigENF;
    private final ClassicalDischargeFlow fQESNashFall;
    private final ClassicalReservoirConfig fConfigCClassical;
    private final ClassicalDischargeFlow fQCS;
    private final InfiniteTcReservoirConfig fConfigCInf;
    private final InfiniteTcDischargeFlow fQbC;
    private final InfiniteTcDischargeFlow fQrC;
    private final ClassicalReservoirConfig fConfigMClassical;
    private final ClassicalDischargeFlow fQMS;
    private final ClassicalDischargeFlow fQMC;
    private final InfiniteTcReservoirConfig fConfigMInf;
    private final InfiniteTcDischargeFlow fQbM;
    private final InfiniteTcDischargeFlow fQrM;
    private final ReservoirConfig fConfigMNF;
    private final ClassicalDischargeFlow fQMSNashFall;
    private final ClassicalReservoirConfig fConfigLClassical;
    private final ClassicalDischargeFlow fQLS;
    private final InfiniteTcReservoirConfig fConfigLInf;
    private final InfiniteTcDischargeFlow fQbL;
    private final InfiniteTcDischargeFlow fQrL;
    private final ReservoirConfig fConfigLNF;
    private final ClassicalDischargeFlow fQLSNashFall;
    private final ReadOnlyListWrapper<Parameter> fParameters = new ReadOnlyListWrapper(FXCollections.observableArrayList());
    private final ReadOnlyListWrapper<Parameter> fActiveParameters = new ReadOnlyListWrapper(FXCollections.observableArrayList());
    private final ReadOnlyListWrapper<Parameter> fCalibrateParameters = new ReadOnlyListWrapper(FXCollections.observableArrayList());
    private final InvalidationListener fCBottomlessListener;
    private final InvalidationListener fMBottomlessListener;
    private final ChangeListener<Boolean> fQMSListener;
    private final PetRoutine fPetRoutine;
    private final SnowRoutine fSnowRoutine;

    public Model() {
        this.fExterieur = new Exterieur();
        this.fLoss = new Exterieur(LOSS_NAME);
        this.fExutoire = new Exutoire(0.0, Messages.getString("S.name"), Messages.getString("S.htmlName"));
        this.fExutoire.activableProperty().set(false);
        this.fReservoirE = new Reservoir(Messages.getString("E.name"), Messages.getString("E.htmlName"), false);
        this.fReservoirE.setSelected(true);
        this.fReservoirE.setInputRequired(false);
        this.fReservoirM = new Reservoir(Messages.getString("M.name"), Messages.getString("M.htmlName"), true);
        this.fReservoirC = new Reservoir(Messages.getString("C.name"), Messages.getString("C.htmlName"), true);
        this.fReservoirL = new Reservoir(Messages.getString("L.name"), Messages.getString("L.htmlName"), true);
        for (Reservoir res : this.getReservoirs()) {
            if (res.isActive()) {
                this.fActiveReservoirList.add((Object)res);
            }
            res.activeProperty().addListener((pObservable, pOldValue, pNewValue) -> {
                if (pNewValue.booleanValue()) {
                    this.fActiveReservoirList.add((Object)res);
                } else {
                    this.fActiveReservoirList.remove((Object)res);
                }
            });
        }
        this.fFluxRainfall = new DataFlow((ISource)this.fExterieur, this.fReservoirE, Messages.getString("pluie.name"), Messages.getString("pluie.htmlName"));
        this.fFluxRainfall.tooltipTextproperty().set((Object)"Rainfall");
        this.fFluxET = new DataFlow((ISource)this.fReservoirE, this.fExterieur, Messages.getString("evapotranspiration.name"), Messages.getString("evapotranspiration.htmlName"));
        this.fFluxET.tooltipTextproperty().set((Object)"Evapotranspiration");
        this.fFluxQPumpC = new DataFlow((ISource)this.fReservoirC, this.fExterieur, Messages.getString("QpumpC.name"), Messages.getString("QpumpC.htmlName"));
        this.fFluxQPumpC.tooltipTextproperty().set((Object)Messages.getString("QpumpC.tooltip"));
        this.fFluxQPumpC.setShowLabel(false);
        this.fFluxQPumpM = new DataFlow((ISource)this.fReservoirM, this.fExterieur, Messages.getString("QpumpM.name"), Messages.getString("QpumpM.htmlName"));
        this.fFluxQPumpM.tooltipTextproperty().set((Object)Messages.getString("QpumpM.tooltip"));
        this.fFluxQPumpM.setShowLabel(false);
        this.fFluxQPumpL = new DataFlow((ISource)this.fReservoirL, this.fExterieur, Messages.getString("QpumpL.name"), Messages.getString("QpumpL.htmlName"));
        this.fFluxQPumpL.tooltipTextproperty().set((Object)Messages.getString("QpumpL.tooltip"));
        this.fFluxQPumpL.setShowLabel(false);
        this.fFluxQPumpS = new DataFlow(this.fExutoire, this.fExterieur, Messages.getString("QpumpS.name"), Messages.getString("QpumpS.htmlName")){

            @Override
            public String getHtmlFormulaLabel() {
                return "Q<sup>S</sup><sub>pump</sub>";
            }
        };
        this.fFluxQPumpS.tooltipTextproperty().set((Object)Messages.getString("QpumpS.tooltip"));
        this.fFluxQPumpS.setShowLabel(false);
        this.fFluxQSinkC = new DataFlow((ISource)this.fExterieur, this.fReservoirC, Messages.getString("QsinkC.name"), Messages.getString("QsinkC.htmlName"));
        this.fFluxQSinkC.tooltipTextproperty().set((Object)Messages.getString("QsinkC.tooltip"));
        this.fFluxQSinkC.setShowLabel(false);
        this.fFluxQSinkM = new DataFlow((ISource)this.fExterieur, this.fReservoirM, Messages.getString("QsinkM.name"), Messages.getString("QsinkM.htmlName"));
        this.fFluxQSinkM.tooltipTextproperty().set((Object)Messages.getString("QsinkM.tooltip"));
        this.fFluxQSinkM.setShowLabel(false);
        this.fFluxQSinkL = new DataFlow((ISource)this.fExterieur, this.fReservoirL, Messages.getString("QsinkL.name"), Messages.getString("QsinkL.htmlName"));
        this.fFluxQSinkL.tooltipTextproperty().set((Object)Messages.getString("QsinkL.tooltip"));
        this.fFluxQSinkL.setShowLabel(false);
        this.fFluxQSinkS = new DataFlow(this.fExterieur, this.fExutoire, Messages.getString("QsinkS.name"), Messages.getString("QsinkS.htmlName")){

            @Override
            public String getHtmlFormulaLabel() {
                return "Q<sup>S</sup><sub>sink</sub>";
            }
        };
        this.fFluxQSinkS.tooltipTextproperty().set((Object)Messages.getString("QsinkS.tooltip"));
        this.fFluxQSinkS.setShowLabel(false);
        this.fConfigEClassical = new ClassicalReservoirConfig(this.fReservoirE, true, false);
        this.fReservoirE.getConfigs().add(this.fConfigEClassical);
        this.fQloss = new ClassicalDischargeFlow(this.fReservoirE, this.fLoss, false, new LoiSeuil(0.1, 0.0, false), Messages.getString("Qloss.name"), Messages.getString("Qloss.htmlName"));
        this.fQloss.getDischargeLaw().getParameter("threshold").setActivable(true);
        this.fQES = new ClassicalDischargeFlow(this.fReservoirE, this.fExutoire, false, new LoiLineaire(0.1, 0.0), Messages.getString("QES.name"), Messages.getString("QES.htmlName"));
        FlowNode eNode = new FlowNode("ENode", "ENode");
        this.fQE = new ClassicalDischargeFlow(this.fReservoirE, eNode, false, new LoiLineaire(0.1, 0.0), Messages.getString("QE.name"), Messages.getString("QE.htmlName"));
        this.fQE.activableProperty().set(false);
        this.fQE.activeProperty().set(true);
        this.fQE.setSelected(true);
        this.fQEC = new ClassicalDischargeFlow(this.fReservoirE, this.fReservoirC, false, new LoiLineaire(0.1, 0.0), Messages.getString("QEC.name"), Messages.getString("QEC.htmlName"));
        this.fQEL = new ClassicalDischargeFlow(this.fReservoirE, this.fReservoirL, false, new LoiLineaire(0.1, 0.0), Messages.getString("QEL.name"), Messages.getString("QEL.htmlName"));
        this.fQEM = new ClassicalDischargeFlow(this.fReservoirE, this.fReservoirM, false, new LoiLineaire(0.1, 0.0), Messages.getString("QEM.name"), Messages.getString("QEM.htmlName"));
        FlowNode fhyNode = new FlowNode("hyNode", "hyNode");
        this.fQhy = new ClassicalDischargeFlow(this.fReservoirE, fhyNode, false, new LoiHysteresis(0.1, new Hysteresis(0.0, 0.0, 1.0, false)), Messages.getString("Qhy.name"), Messages.getString("Qhy.htmlName"));
        this.fQhy.setSelected(true);
        LoiDerivation ld = new LoiDerivation(1.0, "xhy", "<i>x</i><sub>hy</sub>");
        String labLd1 = "(1 - <i>x</i><sub>hy</sub>) ";
        String labLd0 = "<i>x</i><sub>hy</sub>";
        LoiDerivation ld0 = new LoiDerivation(1.0, "xhy", "<i>x</i><sub>hy</sub>");
        ld0.getParameters().remove(ld0.getP());
        LoiDerivation ld1 = new LoiDerivation(1.0, "xhy", "(1 - <i>x</i><sub>hy</sub>) ");
        ld1.getParameters().remove(ld1.getP());
        this.fQhyES = new ClassicalDischargeFlow(fhyNode, this.fExutoire, false, ld1, Messages.getString("QhyES.name"), Messages.getString("QhyES.htmlName"));
        this.fQhyEC = new ClassicalDischargeFlow(fhyNode, this.fReservoirC, false, ld0, Messages.getString("QhyEC.name"), Messages.getString("QhyEC.htmlName"));
        this.fQhyEC.addParameter(ld.getP());
        this.fConfigEClassical.addFlow(this.fQloss);
        this.fConfigEClassical.addFlow(this.fQhy);
        this.fConfigEClassical.addFlow(this.fQhyEC);
        this.fConfigEClassical.addFlow(this.fQES);
        this.fConfigEClassical.addFlow(this.fQEL);
        this.fConfigEClassical.addFlow(this.fQEM);
        this.fConfigEClassical.addFlow(this.fQEC);
        this.fQhyES.getParentsHandler().addParent(this.fConfigEClassical);
        this.fQhy.getParentsHandler().addParents(() -> this.fQhyEC.isActive() || this.fQhyES.isActive(), this.fQhyES, this.fQhyEC);
        ChangeListener lishy = (pObservable, pOldValue, pNewValue) -> this.fQhy.setSelected(this.fQhyEC.isActive() || this.fQhyES.isActive());
        this.fQhyEC.activeProperty().addListener(lishy);
        this.fQhyES.activeProperty().addListener(lishy);
        this.fQhy.selectedProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            if (!pNewValue.booleanValue()) {
                this.fQhyEC.setSelected(false);
                this.fQhyES.setSelected(false);
            }
        });
        ld.getP().getParentsHandler().addParent(this.fQhyEC);
        ld.getP().getParentsHandler().addParent(this.fQhyES);
        ld.getP().activeProperty().set(false);
        ChangeListener QhyListener = (pObservable, pOldValue, pNewValue) -> {
            if (this.fQhyES.isSelected() && !this.fQhyEC.isSelected()) {
                ld.getP().setValue(0.0);
            } else if (this.fQhyEC.isSelected() && !this.fQhyES.isSelected()) {
                ld.getP().setValue(1.0);
            }
        };
        this.fQhyEC.activeProperty().addListener(QhyListener);
        this.fQhyES.activeProperty().addListener(QhyListener);
        this.fConfigEClassical.getH0().addValidator(new DefaultParameterValidator(){

            @Override
            public MessageList validate(Parameter pParameter) {
                if (Model.this.fConfigEClassical.getHmin().isActive() && (pParameter.getMode() == ModeKarstMod.RUN || pParameter.getMode() == ModeKarstMod.CALIBRATION && !Model.this.fConfigEClassical.getHmin().needsCalibration())) {
                    return new RangeValidator(pParameter.getMode() == ModeKarstMod.CALIBRATION ? Model.this.fConfigEClassical.getHmin().getMin() : Model.this.fConfigEClassical.getHmin().getValue(), true, null, false, "Value must be greater than or equal to " + Model.this.fConfigEClassical.getHmin().getHtmlLabel(), null).validate(pParameter);
                }
                if (Model.this.fConfigEClassical.getHmin().isActive() && pParameter.getMode() == ModeKarstMod.CALIBRATION && !Model.this.fConfigEClassical.getH0().needsCalibration() && Model.this.fConfigEClassical.getHmin().needsCalibration()) {
                    return new RangeValidator(Model.this.fConfigEClassical.getHmin().getMax(), true, null, false, "Value must be greater than or equal to " + Model.this.fConfigEClassical.getHmin().getHtmlLabel() + "max", null).validate(pParameter);
                }
                if (Model.this.fConfigEClassical.getHmin().isActive() && pParameter.getMode() == ModeKarstMod.CALIBRATION && Model.this.fConfigEClassical.getH0().needsCalibration() && Model.this.fConfigEClassical.getHmin().needsCalibration()) {
                    MessageList res = new RangeValidator(Model.this.fConfigEClassical.getHmin().getMin(), true, null, false, "Value must be greater than or equal to " + Model.this.fConfigEClassical.getHmin().getHtmlLabel() + "min", null).validate(pParameter);
                    if (pParameter.getMin() < Model.this.fConfigEClassical.getHmin().getMax()) {
                        res.addWarning("During calibration, " + pParameter.getHtmlLabel() + " will always be greater than or equal to " + Model.this.fConfigEClassical.getHmin().getHtmlLabel(), pParameter.getLabel());
                    }
                    return res;
                }
                if (!Model.this.fConfigEClassical.getHmin().isActive()) {
                    return new RangeValidator(0.0, true, null, false).validate(pParameter);
                }
                return super.validate(pParameter);
            }
        });
        this.fConfigEClassical.getHmin().addValidator(new DefaultParameterValidator(this.fConfigEClassical.getH0()));
        String label = "Linked Q<sub>EM</sub>, Q<sub>EL</sub>, Q<sub>EC</sub>";
        Parameter linkedReservoirs = new Parameter(LINKED_RESERVOIRS, "Linked QEM, QEL, QEC", "Linked Q<sub>EM</sub>, Q<sub>EL</sub>, Q<sub>EC</sub>", false);
        linkedReservoirs.getParentsHandler().addParents(() -> {
            String newLabel = "Linked Q<sub>EM</sub>, Q<sub>EL</sub>, Q<sub>EC</sub>";
            if (!this.fQEM.isActive()) {
                newLabel = "Linked Q<sub>EM</sub>, Q<sub>EL</sub>, Q<sub>EC</sub>".replaceAll("Q<sub>EM</sub>, ", "");
            }
            if (!this.fQEL.isActive()) {
                newLabel = "Linked Q<sub>EM</sub>, Q<sub>EL</sub>, Q<sub>EC</sub>".replaceAll("Q<sub>EL</sub>, ", "");
            }
            linkedReservoirs.setLibelleHtml(newLabel);
            linkedReservoirs.setLabel(newLabel);
            return this.fQEC.isActive() && (this.fQEL.isActive() || this.fQEM.isActive());
        }, this.fQEC, this.fQEM, this.fQEL);
        this.fConfigEClassical.getParameters().add(linkedReservoirs);
        Parameter xEC = new Parameter(XEC, XEC, "<i>x</i><sub>EC</sub>", true, false, TypeInit.DEFAULT, Dimension.NONE, 0.0, 1.0);
        xEC.setValue(0.5);
        this.fConfigEClassical.getParameters().add(xEC);
        xEC.getParentsHandler().addParent(linkedReservoirs);
        xEC.setLevel(2);
        Parameter xEM = new Parameter(XEM, XEM, "<i>x</i><sub>EM</sub>", true, false, TypeInit.DEFAULT, Dimension.NONE, 0.0, 1.0);
        xEM.setValue(0.5);
        this.fConfigEClassical.getParameters().add(xEM);
        xEM.getParentsHandler().addParent(linkedReservoirs);
        xEM.getParentsHandler().addParents(() -> this.fQEM.isActive() && this.fQEL.isActive(), this.fQEM, this.fQEL);
        xEM.setLevel(2);
        this.fQE.getParentsHandler().addParent(linkedReservoirs);
        linkedReservoirs.activeProperty().addListener((pObservable, pOldValue, pNewValue) -> this.fQE.selectedProperty().set(pNewValue.booleanValue()));
        for (Flow flow : new Flow[]{this.fQEC, this.fQEM, this.fQEL}) {
            for (Parameter param : flow.getParameters()) {
                param.getParentsHandler().addParent(new InvertedParent(linkedReservoirs));
            }
        }
        for (Parameter p : this.fQE.getParameters()) {
            p.setLevel(2);
            p.setTop(false);
        }
        this.fConfigEClassical.getParameters().addAll(this.fQE.getParameters());
        this.fQE.getParameters().clear();
        linkedReservoirs.setTop(false);
        xEC.setTop(false);
        xEM.setTop(false);
        this.fQbE = new InfiniteTcDischargeFlow(this.fReservoirE, "QbE", "Q<sub>b</sub><sub>E</sub>", "QbE", new ICible[]{this.fReservoirC, this.fReservoirM, this.fReservoirL, this.fExutoire}, ParamChoiceType.RADIO);
        this.fQrE = new InfiniteTcDischargeFlow(this.fReservoirE, "QrE", "Q<sub>r</sub><sub>E</sub>", "QrE", new ICible[]{this.fLoss, this.fReservoirC, this.fExutoire}, ParamChoiceType.CHECK);
        this.fQbE.getParameter("to " + this.fExutoire.getName()).setSelected(true);
        this.fQrE.getParameter("to " + this.fLoss.getName()).setSelected(true);
        this.fQbE.setSelected(true);
        this.fQrE.setSelected(true);
        this.fConfigEInf = new InfiniteTcReservoirConfig(this.fReservoirE, this.fQbE, this.fQrE, true);
        this.fConfigEInf.addFlow(this.fQbE);
        this.fConfigEInf.addFlow(this.fQrE);
        this.fReservoirE.getConfigs().add(this.fConfigEInf);
        Parameter xC = new Parameter(XC, XC, "<i>x</i><sub>C</sub>", true, false, TypeInit.DEFAULT, Dimension.NONE, 0.0, 1.0);
        this.fQrE.getParameters().add(xC);
        xC.getParentsHandler().addParent(this.fQrE.getParameter("to " + this.fReservoirC.getName()));
        xC.getParentsHandler().addParent(this.fQrE.getParameter("to " + this.fExutoire.getName()));
        Parameter xLoss = new Parameter(XLOSS, XLOSS, "<i>x</i><sub>loss</sub>", true, false, TypeInit.DEFAULT, Dimension.NONE, 0.0, 1.0);
        this.fQrE.getParameters().add(xLoss);
        xLoss.getParentsHandler().addParent(this.fQrE.getParameter("to loss"));
        xLoss.getParentsHandler().addParents(() -> this.fQrE.getParameter("to " + this.fReservoirC.getName()).isActive() || this.fQrE.getParameter("to " + this.fExutoire.getName()).isActive(), this.fQrE.getParameter("to " + this.fReservoirC.getName()), this.fQrE.getParameter("to " + this.fExutoire.getName()));
        ChangeListener qbeLis = (pObservable, pOldValue, pNewValue) -> {
            if (!pNewValue.booleanValue()) {
                block0: for (Parameter p : this.fQbE.getParameters()) {
                    if (!p.isSelected() || p.getParentsHandler().isActive()) continue;
                    for (Parameter p2 : this.fQbE.getParameters()) {
                        if (!p2.getParentsHandler().isActive()) continue;
                        p2.setSelected(true);
                        break block0;
                    }
                }
            }
        };
        for (Parameter p : this.fQbE.getParameters()) {
            p.activeProperty().addListener(qbeLis);
        }
        this.fConfigENF = new NashFallReservoirConfig(this.fReservoirE);
        this.fQESNashFall = new ClassicalDischargeFlow(this.fReservoirE, this.fExutoire, false, new NashFallLaw(), "QES_NF", "Q<sub>ES</sub>", "QES_NF", false);
        this.fQESNashFall.setSelected(true);
        this.fQESNashFall.setShowLabel(false);
        this.fConfigENF.addFlow(this.fQESNashFall);
        this.fConfigENF.getParentsHandler().addParents(() -> !this.fReservoirC.isActive() && !this.fReservoirM.isActive() && !this.fReservoirL.isActive(), this.fReservoirC, this.fReservoirM, this.fReservoirL);
        this.fConfigCClassical = new ClassicalReservoirConfig(this.fReservoirC, false, true);
        this.fReservoirC.getConfigs().add(this.fConfigCClassical);
        this.fQCS = new ClassicalDischargeFlow(this.fReservoirC, this.fExutoire, false, new LoiLineaire(0.1, 0.0), Messages.getString("QCS.name"), Messages.getString("QCS.htmlName"), null, false);
        this.fQCS.setSelected(true);
        new ParameterConstraint(this.fQCS.getDischargeLaw().getParameter("k"), this.fQEC.getDischargeLaw().getParameter("k"));
        this.fConfigCClassical.addFlow(this.fQCS);
        this.fConfigCClassical.getH0().addValidator(new RangeValidator(0.0, true, null, false){

            @Override
            public MessageList validate(Parameter pParameter) {
                if (!Model.this.fConfigCClassical.getBottomless().isSelected()) {
                    return super.validate(pParameter);
                }
                return new MessageList();
            }
        });
        this.fConfigCClassical.getBottomless().addValidator(new DefaultParameterValidator(this.fConfigCClassical.getH0()));
        this.fQbC = new InfiniteTcDischargeFlow(this.fReservoirC, "QbC", "Q<sub>b</sub><sub>C</sub>", "QbC", new ICible[]{this.fExutoire}, ParamChoiceType.RADIO);
        this.fQbC.getParameter("to " + this.fExutoire.getName()).setSelected(true);
        this.fQbC.getParameter("to " + this.fExutoire.getName()).setActivable(false);
        this.fQrC = new InfiniteTcDischargeFlow(this.fReservoirC, "QrC", "Q<sub>r</sub><sub>C</sub>", "QrC", new ICible[]{this.fLoss, this.fExutoire}, ParamChoiceType.RADIO);
        this.fQrC.getParameter("to " + this.fLoss.getName()).setSelected(true);
        this.fQbC.setSelected(true);
        this.fQrC.setSelected(true);
        this.fConfigCInf = new InfiniteTcReservoirConfig(this.fReservoirC, this.fQbC, this.fQrC, false);
        this.fConfigCInf.addFlow(this.fQbC);
        this.fConfigCInf.addFlow(this.fQrC);
        this.fReservoirC.getConfigs().add(this.fConfigCInf);
        this.fConfigMClassical = new ClassicalReservoirConfig(this.fReservoirM, false, true);
        this.fReservoirM.getConfigs().add(this.fConfigMClassical);
        this.fQMS = new ClassicalDischargeFlow(this.fReservoirM, this.fExutoire, false, new LoiLineaire(0.1, 0.0), Messages.getString("QMS.name"), Messages.getString("QMS.htmlName"));
        this.fQMC = new ClassicalDischargeFlow(this.fReservoirM, this.fReservoirC, true, new LoiHauteurRelative(0.0), Messages.getString("QMC.name"), Messages.getString("QMC.htmlName"));
        this.fQMC.getParameter(LoiHauteurRelative.ALPHA).setSelected(false);
        this.fQMC.getParameter(LoiHauteurRelative.ALPHA).setActivable(true);
        this.fConfigMClassical.addFlow(this.fQMS);
        this.fConfigMClassical.addFlow(this.fQMC);
        this.fQMC.getParentsHandler().addParents(() -> this.fConfigMClassical.getBottomless().isActive() == this.fConfigCClassical.getBottomless().isActive(), this.fConfigMClassical.getBottomless(), this.fConfigCClassical.getBottomless());
        this.fQMC.getParentsHandler().addParents(() -> this.fConfigCClassical.isActive() && this.fConfigMClassical.isActive(), this.fConfigCClassical, this.fConfigMClassical);
        this.fConfigMClassical.getH0().addValidator(new RangeValidator(0.0, true, null, false){

            @Override
            public MessageList validate(Parameter pParameter) {
                if (!Model.this.fConfigMClassical.getBottomless().isSelected()) {
                    return super.validate(pParameter);
                }
                return new MessageList();
            }
        });
        this.fConfigMClassical.getBottomless().addValidator(new DefaultParameterValidator(this.fConfigMClassical.getH0()));
        this.fQbM = new InfiniteTcDischargeFlow(this.fReservoirM, "QbM", "Q<sub>b</sub><sub>M</sub>", "QbM", new ICible[]{this.fExutoire}, ParamChoiceType.RADIO);
        this.fQbM.getParameter("to " + this.fExutoire.getName()).setSelected(true);
        this.fQbM.getParameter("to " + this.fExutoire.getName()).setActivable(false);
        this.fQrM = new InfiniteTcDischargeFlow(this.fReservoirM, "QrM", "Q<sub>r</sub><sub>M</sub>", "QrM", new ICible[]{this.fLoss, this.fExutoire}, ParamChoiceType.RADIO);
        this.fQrM.getParameter("to " + this.fLoss.getName()).setSelected(true);
        this.fQbM.setSelected(true);
        this.fQrM.setSelected(true);
        this.fConfigMInf = new InfiniteTcReservoirConfig(this.fReservoirM, this.fQbM, this.fQrM, false);
        this.fConfigMInf.addFlow(this.fQbM);
        this.fConfigMInf.addFlow(this.fQrM);
        this.fReservoirM.getConfigs().add(this.fConfigMInf);
        this.fConfigMNF = new NashFallReservoirConfig(this.fReservoirM);
        this.fQMSNashFall = new ClassicalDischargeFlow(this.fReservoirM, this.fExutoire, false, new NashFallLaw(), "QMS_NF", "Q<sub>MS</sub>", "QMS_NF");
        this.fQMSNashFall.setSelected(true);
        this.fQMSNashFall.setShowLabel(false);
        this.fConfigMNF.addFlow(this.fQMSNashFall);
        this.fConfigLClassical = new ClassicalReservoirConfig(this.fReservoirL, false, false);
        this.fReservoirL.getConfigs().add(this.fConfigLClassical);
        this.fQLS = new ClassicalDischargeFlow(this.fReservoirL, this.fExutoire, false, new LoiLineaire(0.1, 0.0), Messages.getString("QLS.name"), Messages.getString("QLS.htmlName"), null, false);
        this.fQLS.setSelected(true);
        new ParameterConstraint(this.fQLS.getDischargeLaw().getParameter("k"), this.fQEL.getDischargeLaw().getParameter("k"));
        this.fConfigLClassical.addFlow(this.fQLS);
        this.fQLS.setSelected(true);
        this.fConfigLClassical.getH0().addValidator(new RangeValidator(0.0, true, null, false));
        this.fQbL = new InfiniteTcDischargeFlow(this.fReservoirL, "QbL", "Q<sub>b</sub><sub>L</sub>", "QbL", new ICible[]{this.fExutoire}, ParamChoiceType.RADIO);
        this.fQbL.getParameter("to " + this.fExutoire.getName()).setSelected(true);
        this.fQbL.getParameter("to " + this.fExutoire.getName()).setActivable(false);
        this.fQrL = new InfiniteTcDischargeFlow(this.fReservoirL, "QrL", "Q<sub>r</sub><sub>L</sub>", "QrL", new ICible[]{this.fLoss, this.fExutoire}, ParamChoiceType.RADIO);
        this.fQrL.getParameter("to " + this.fLoss.getName()).setSelected(true);
        this.fQbL.setSelected(true);
        this.fQrL.setSelected(true);
        this.fConfigLInf = new InfiniteTcReservoirConfig(this.fReservoirL, this.fQbL, this.fQrL, false);
        this.fConfigLInf.addFlow(this.fQbL);
        this.fConfigLInf.addFlow(this.fQrL);
        this.fReservoirL.getConfigs().add(this.fConfigLInf);
        this.fConfigLNF = new NashFallReservoirConfig(this.fReservoirL);
        this.fQLSNashFall = new ClassicalDischargeFlow(this.fReservoirL, this.fExutoire, false, new NashFallLaw(), "QLS_NF", "Q<sub>LS</sub>", "QLS_NF", false);
        this.fQLSNashFall.setSelected(true);
        this.fQLSNashFall.setShowLabel(false);
        this.fConfigLNF.addFlow(this.fQLSNashFall);
        for (Reservoir reservoir : this.getReservoirs()) {
            if (reservoir.getConfigs().size() != 1) continue;
            reservoir.getConfigs().get(0).setSelected(true);
        }
        this.fCBottomlessListener = pObservable -> {
            if (this.fQMC.isSelected()) {
                this.fConfigMClassical.getBottomless().selectedProperty().set(this.fConfigCClassical.getBottomless().isSelected());
            }
        };
        this.fMBottomlessListener = pObservable -> {
            if (this.fQMC.isSelected()) {
                this.fConfigCClassical.getBottomless().selectedProperty().set(this.fConfigMClassical.getBottomless().isSelected());
            }
        };
        this.fQMSListener = (pObservable, pOldValue, pNewValue) -> {
            if (this.fConfigMClassical.isActive() && this.fConfigCClassical.isActive()) {
                this.fQMS.activableProperty().set(true);
            } else {
                this.fQMS.setSelected(true);
                this.fQMS.activableProperty().set(false);
            }
        };
        this.addTransversalListeners();
        for (Reservoir r2 : this.getReservoirs()) {
            r2.getConfig(ReservoirConfigType.CLASSICAL).getH0().valueProperty().bindBidirectional(r2.getConfig(ReservoirConfigType.INFINITE_TC).getH0().valueProperty());
            r2.getConfig(ReservoirConfigType.CLASSICAL).getH0().minProperty().bindBidirectional(r2.getConfig(ReservoirConfigType.INFINITE_TC).getH0().minProperty());
            r2.getConfig(ReservoirConfigType.CLASSICAL).getH0().maxProperty().bindBidirectional(r2.getConfig(ReservoirConfigType.INFINITE_TC).getH0().maxProperty());
        }
        this.fPetRoutine = new PetRoutine();
        this.fPetRoutine.setSelected(false);
        this.fPetRoutine.activeProperty().addListener((r, o, n) -> {
            if (n.booleanValue()) {
                this.fFluxET.setSelected(false);
            }
        });
        this.fFluxET.activeProperty().addListener((r, o, n) -> {
            if (n.booleanValue()) {
                this.fPetRoutine.setSelected(false);
            }
        });
        this.fSnowRoutine = new SnowRoutine();
        this.fSnowRoutine.getParentsHandler().addParent(this.fFluxRainfall);
        for (Reservoir reservoir : this.getReservoirs()) {
            ChangeListener listenerFlows = (observable, oldValue, newValue) -> {
                StringBuilder cplt = new StringBuilder();
                for (IChild iChild : reservoir.getInputFlows()) {
                    if (!(iChild instanceof DataFlow) || !iChild.isActive()) continue;
                    cplt.append(((DataFlow)iChild).getHtmlLabel()).append(", ");
                }
                for (Flow flow : reservoir.getOutputFlows()) {
                    if (!flow.isActive()) continue;
                    cplt.append(flow.getHtmlLabel()).append(", ");
                }
                if (reservoir == this.fReservoirE) {
                    if (this.fQhyEC.isActive()) {
                        cplt.append(this.fQhyEC.getHtmlLabel()).append(", ");
                    }
                    if (this.fPetRoutine.isActive()) {
                        cplt.append(this.fPetRoutine.getHtmlLabel()).append(", ");
                    }
                }
                String s = cplt.length() == 0 ? null : " (" + cplt.substring(0, cplt.length() - 2) + ")";
                reservoir.setHtmlLabelCplt(s);
            };
            for (Flow flow : reservoir.getOutputFlows()) {
                flow.activeProperty().addListener(listenerFlows);
            }
            this.fQhyEC.activeProperty().addListener(listenerFlows);
            for (IChild iChild : reservoir.getInputFlows()) {
                if (!(iChild instanceof DataFlow)) continue;
                iChild.activeProperty().addListener(listenerFlows);
            }
            this.fPetRoutine.activeProperty().addListener(listenerFlows);
            listenerFlows.changed(null, null, null);
        }
        this.fElements = new ArrayList<IElement>();
        this.fElements.add(this.fExutoire);
        this.fElements.add(this.fReservoirL);
        this.fElements.add(this.fReservoirE);
        this.fElements.add(this.fReservoirM);
        this.fElements.add(this.fReservoirC);
        this.fElements.add(this.fFluxRainfall);
        this.fElements.add(this.fFluxET);
        this.fElements.add(this.fFluxQPumpL);
        this.fElements.add(this.fFluxQPumpC);
        this.fElements.add(this.fFluxQPumpM);
        this.fElements.add(this.fFluxQPumpS);
        this.fElements.add(this.fFluxQSinkL);
        this.fElements.add(this.fFluxQSinkC);
        this.fElements.add(this.fFluxQSinkM);
        this.fElements.add(this.fFluxQSinkS);
        this.fElements.add(this.fQloss);
        this.fElements.add(this.fQES);
        this.fElements.add(this.fQEL);
        this.fElements.add(this.fQE);
        this.fElements.add(this.fQEC);
        this.fElements.add(this.fQEM);
        this.fElements.add(fhyNode);
        this.fElements.add(this.fQhy);
        this.fElements.add(this.fQhyEC);
        this.fElements.add(this.fQhyES);
        this.fElements.add(this.fQrE);
        this.fElements.add(this.fQbE);
        this.fElements.add(this.fQESNashFall);
        this.fElements.add(this.fQCS);
        this.fElements.add(this.fQbC);
        this.fElements.add(this.fQrC);
        this.fElements.add(this.fQMS);
        this.fElements.add(this.fQMC);
        this.fElements.add(this.fQbM);
        this.fElements.add(this.fQrM);
        this.fElements.add(this.fQMSNashFall);
        this.fElements.add(this.fQLS);
        this.fElements.add(this.fQbL);
        this.fElements.add(this.fQrL);
        this.fElements.add(this.fQLSNashFall);
        this.fElements.add(this.fPetRoutine);
        this.fElements.add(this.fSnowRoutine);
        InvalidationListener invalidationListener = pObservable -> this.fireChanged();
        for (IElement element : this.fElements) {
            if (element == this.fQhyES) continue;
            element.addListener(invalidationListener);
            for (Parameter parameter : element.getParameters()) {
                if (!parameter.getAttrName().startsWith("to ") && this.fParameters.contains((Object)parameter)) {
                    throw new RuntimeException("Duplicate parameter " + parameter.getLabel());
                }
                this.fParameters.add((Object)parameter);
            }
        }
        for (Reservoir reservoir : this.getReservoirs()) {
            for (ReservoirConfig reservoirConfig : reservoir.getConfigs()) {
                reservoirConfig.addListener(invalidationListener);
                for (Parameter parameter : reservoirConfig.getParameters()) {
                    parameter.addListener(invalidationListener);
                    this.fParameters.add((Object)parameter);
                }
            }
        }
        Color[] colors = ColorUtils.genHSB(this.fParameters.size());
        int i = 0;
        for (Parameter parameter : this.fParameters) {
            parameter.setColor(colors[i++]);
        }
        for (Parameter p : this.fParameters) {
            p.activeProperty().addListener((pObservable, pOldValue, pNewValue) -> {
                if (pNewValue.booleanValue()) {
                    this.fActiveParameters.add((Object)p);
                } else {
                    this.fActiveParameters.remove((Object)p);
                }
            });
            if (!p.isActive()) continue;
            this.fActiveParameters.add((Object)p);
        }
        for (Parameter p : this.fParameters) {
            p.calibrateProperty().addListener((pObservable, pOldValue, pNewValue) -> {
                if (pNewValue.booleanValue()) {
                    this.fCalibrateParameters.add((Object)p);
                } else {
                    this.fCalibrateParameters.remove((Object)p);
                }
            });
            if (!p.needsCalibration()) continue;
            this.fCalibrateParameters.add((Object)p);
        }
    }

    private void addTransversalListeners() {
        this.fConfigCClassical.getBottomless().selectedProperty().addListener(this.fCBottomlessListener);
        this.fConfigMClassical.getBottomless().selectedProperty().addListener(this.fMBottomlessListener);
        this.fConfigMClassical.activeProperty().addListener(this.fQMSListener);
        this.fConfigCInf.activeProperty().addListener(this.fQMSListener);
        this.fConfigCClassical.activeProperty().addListener(this.fQMSListener);
    }

    private void removeTransversalListeners() {
        this.fConfigCClassical.getBottomless().selectedProperty().removeListener(this.fCBottomlessListener);
        this.fConfigMClassical.getBottomless().selectedProperty().removeListener(this.fMBottomlessListener);
        this.fConfigMClassical.activeProperty().removeListener(this.fQMSListener);
        this.fConfigCInf.activeProperty().removeListener(this.fQMSListener);
        this.fConfigCClassical.activeProperty().removeListener(this.fQMSListener);
    }

    public void save(Properties pProperties, boolean pActiveOnly) {
        for (IElement element : this.fElements) {
            element.save(pProperties, PREFIXE, pActiveOnly);
        }
    }

    public void load(Properties pProperties) throws Exception {
        this.removeTransversalListeners();
        for (IElement element : this.fElements) {
            element.load(pProperties, PREFIXE);
        }
        this.addTransversalListeners();
    }

    public MessageList validate() {
        MessageList messages = new MessageList();
        for (IElement element : this.fElements) {
            if (!element.isActive()) continue;
            messages.addAll(element.validate());
        }
        return messages;
    }

    public String detail(boolean pTous) {
        StringBuilder sb = new StringBuilder(10000);
        for (IElement element : this.fElements) {
            if (!pTous && !element.isActive()) continue;
            sb.append(element.detail()).append("\n");
        }
        return sb.toString();
    }

    public void raz() {
        for (IElement elt : this.fElements) {
            elt.raz();
        }
        for (Reservoir reservoir : this.getReservoirs()) {
            for (ReservoirConfig config : reservoir.getConfigs()) {
                for (Parameter parameter : config.getParameters()) {
                    parameter.raz();
                }
            }
        }
    }

    public boolean isSymetric() {
        return this.fReservoirC.isActive() && this.fReservoirM.isActive() && this.fQMS.isActive() && this.fQCS.isActive() && this.fQEC.isActive() && this.fQEM.isActive() && !this.fFluxQPumpC.isActive() && !this.fFluxQPumpM.isActive() && !this.fQhy.isActive();
    }

    public ReadOnlyListProperty<Parameter> getCalibrateParameters() {
        return this.fCalibrateParameters.getReadOnlyProperty();
    }

    public ReadOnlyListProperty<Parameter> getActiveParameters() {
        return this.fActiveParameters.getReadOnlyProperty();
    }

    public ReadOnlyListProperty<Parameter> getParameters() {
        return this.fParameters.getReadOnlyProperty();
    }

    public void addListener(InvalidationListener pListener) {
        this.fListeners.add(pListener);
    }

    public void removeListener(InvalidationListener pListener) {
        this.fListeners.remove(pListener);
    }

    private void fireChanged() {
        for (InvalidationListener listener : this.fListeners) {
            listener.invalidated((Observable)this);
        }
    }

    public Reservoir[] getReservoirs() {
        return new Reservoir[]{this.fReservoirE, this.fReservoirC, this.fReservoirM, this.fReservoirL};
    }

    public ReadOnlyListProperty<Reservoir> getActiveReservoirList() {
        return this.fActiveReservoirList.getReadOnlyProperty();
    }

    public Reservoir getReservoirE() {
        return this.fReservoirE;
    }

    public Reservoir getReservoirM() {
        return this.fReservoirM;
    }

    public Reservoir getReservoirC() {
        return this.fReservoirC;
    }

    public Reservoir getReservoirL() {
        return this.fReservoirL;
    }

    public Exutoire getExutoire() {
        return this.fExutoire;
    }

    public DataFlow getFluxRainfall() {
        return this.fFluxRainfall;
    }

    public DataFlow getFluxET() {
        return this.fFluxET;
    }

    public DataFlow getFluxQPumpC() {
        return this.fFluxQPumpC;
    }

    public DataFlow getFluxQPumpL() {
        return this.fFluxQPumpL;
    }

    public DataFlow getFluxQPumpM() {
        return this.fFluxQPumpM;
    }

    public DataFlow getFluxQPumpS() {
        return this.fFluxQPumpS;
    }

    public DataFlow getFluxQSinkC() {
        return this.fFluxQSinkC;
    }

    public DataFlow getFluxQSinkL() {
        return this.fFluxQSinkL;
    }

    public DataFlow getFluxQSinkM() {
        return this.fFluxQSinkM;
    }

    public DataFlow getFluxQSinkS() {
        return this.fFluxQSinkS;
    }

    public ClassicalDischargeFlow getQloss() {
        return this.fQloss;
    }

    public ClassicalDischargeFlow getQES() {
        return this.fQES;
    }

    public ClassicalDischargeFlow getQEM() {
        return this.fQEM;
    }

    public ClassicalDischargeFlow getQE() {
        return this.fQE;
    }

    public ClassicalDischargeFlow getQEC() {
        return this.fQEC;
    }

    public ClassicalDischargeFlow getQEL() {
        return this.fQEL;
    }

    public ClassicalDischargeFlow getQMS() {
        return this.fQMS;
    }

    public ClassicalDischargeFlow getQMC() {
        return this.fQMC;
    }

    public ClassicalDischargeFlow getQCS() {
        return this.fQCS;
    }

    public ClassicalDischargeFlow getQLS() {
        return this.fQLS;
    }

    public ClassicalDischargeFlow getQhy() {
        return this.fQhy;
    }

    public ClassicalDischargeFlow getQhyEC() {
        return this.fQhyEC;
    }

    public ClassicalDischargeFlow getQhyES() {
        return this.fQhyES;
    }

    public ClassicalDischargeFlow getQLSNashFall() {
        return this.fQLSNashFall;
    }

    public ClassicalDischargeFlow getQMSNashFall() {
        return this.fQMSNashFall;
    }

    public ClassicalDischargeFlow getQESNashFall() {
        return this.fQESNashFall;
    }

    public InfiniteTcDischargeFlow getQbE() {
        return this.fQbE;
    }

    public InfiniteTcDischargeFlow getQrE() {
        return this.fQrE;
    }

    public InfiniteTcDischargeFlow getQbC() {
        return this.fQbC;
    }

    public InfiniteTcDischargeFlow getQrC() {
        return this.fQrC;
    }

    public InfiniteTcDischargeFlow getQbL() {
        return this.fQbL;
    }

    public InfiniteTcDischargeFlow getQrL() {
        return this.fQrL;
    }

    public InfiniteTcDischargeFlow getQbM() {
        return this.fQbM;
    }

    public InfiniteTcDischargeFlow getQrM() {
        return this.fQrM;
    }

    public Exterieur getLoss() {
        return this.fLoss;
    }

    public ReservoirConfig getConfigEClassical() {
        return this.fConfigEClassical;
    }

    public PetRoutine getPetRoutine() {
        return this.fPetRoutine;
    }

    public SnowRoutine getSnowRoutine() {
        return this.fSnowRoutine;
    }

    public boolean useVar(Varname pVarname) {
        switch (pVarname) {
            case QS: {
                return true;
            }
            case QLOSS: {
                return this.fQloss.isActive();
            }
            case ZE: {
                return this.fReservoirE.getPiezo().isActive();
            }
            case ZL: {
                return this.fReservoirL.getPiezo().isActive();
            }
            case ZM: {
                return this.fReservoirM.getPiezo().isActive();
            }
            case ZC: {
                return this.fReservoirC.getPiezo().isActive();
            }
        }
        return false;
    }

    public List<Varname> usedVars() {
        ArrayList<Varname> varnames = new ArrayList<Varname>();
        for (Varname varname : Varname.values()) {
            if (!this.useVar(varname)) continue;
            varnames.add(varname);
        }
        return varnames;
    }
}

