/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.ColumnName;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.MessageType;
import fr.geonosis.karstmod.utils.csv.IntRange;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunctionLagrangeForm;

public class Interpolator {
    public static final String NOINTERP = "NOINTERP";
    public static final String INTERP = "INTERP";
    private final ColumnName fColumnName;
    private final double fMinValue;
    private final double[] fOriginalValues;
    private final List<IntRange> fGaps;
    private final IntegerProperty fInterpolableGapSizeProperty;
    private final BooleanProperty fActiveProperty;
    private final BooleanProperty fFillGapsWith0Property;
    private double[] fValues;
    private int fMaxGapLength;
    private int fOrder;
    private String fDetail;

    public Interpolator(ColumnName pColumnName, double[] pOriginalValues, List<IntRange> pGaps) {
        this(pColumnName, pOriginalValues, pGaps, 0.0);
    }

    public Interpolator(ColumnName pColumnName, double[] pOriginalValues, List<IntRange> pGaps, double pMinValue) {
        this.fColumnName = pColumnName;
        this.fOriginalValues = pOriginalValues;
        this.fMinValue = pMinValue;
        this.fGaps = pGaps;
        this.updateDetail();
        this.fInterpolableGapSizeProperty = new SimpleIntegerProperty(this.fMaxGapLength);
        this.fActiveProperty = new SimpleBooleanProperty(true);
        this.fFillGapsWith0Property = new SimpleBooleanProperty(false);
        this.fOrder = 1;
    }

    private void updateDetail() {
        this.fMaxGapLength = 0;
        StringBuilder sb = new StringBuilder();
        for (IntRange range : this.fGaps) {
            int len = range.length();
            if (len > this.fMaxGapLength) {
                this.fMaxGapLength = len;
            }
            if (len == 1) {
                sb.append(String.format("row index %d (1 missing value)<br></br>", range.min()));
                continue;
            }
            sb.append(String.format("row indexes %d to %d (%d missing values)<br></br>", range.min(), range.max(), len));
        }
        this.fDetail = sb.toString();
    }

    public int getMaxGapLength() {
        return this.fMaxGapLength;
    }

    public MessageList interpolate() {
        int maxLength;
        this.fValues = (double[])this.fOriginalValues.clone();
        MessageList msgs = new MessageList();
        int i0 = 0;
        int nGaps = this.fGaps.size();
        int nbValues = this.fOrder + 1;
        int nb0 = nbValues - nbValues / 2;
        int n = maxLength = this.getInterpolableGapSize() == null ? Integer.MAX_VALUE : this.getInterpolableGapSize();
        if (this.isActive() && this.fFillGapsWith0Property.get()) {
            Iterator<IntRange> iterator = this.fGaps.iterator();
            while (iterator.hasNext()) {
                IntRange pGap;
                IntRange range = pGap = iterator.next();
                for (int j = range.min(); j <= range.max(); ++j) {
                    this.fValues[j] = 0.0;
                }
            }
        } else {
            for (int i = 0; i < nGaps; ++i) {
                int j;
                IntRange range = this.fGaps.get(i);
                if (this.isActive()) {
                    if (range.length() <= maxLength) {
                        int i1;
                        int n2 = i1 = i + 1 < nGaps ? this.fGaps.get(i + 1).min() - 1 : this.fValues.length - 1;
                        if (range.min() - i0 + i1 - range.max() < nbValues) {
                            msgs.add(MessageType.ERROR, String.format("%s : not enough values for interpolation (indices %d to %d)", this, range.min(), range.max()));
                        } else {
                            int k;
                            int nbe = Math.min(nbValues, range.min() - i0);
                            int nae = Math.min(nbValues, i1 - range.max());
                            for (k = 1; k <= nbe; ++k) {
                                if (!Double.isNaN(this.fValues[range.min() - k])) continue;
                                nbe = k - 1;
                                break;
                            }
                            for (k = 1; k <= nae; ++k) {
                                if (!Double.isNaN(this.fValues[range.max() + k])) continue;
                                nae = k - 1;
                                break;
                            }
                            if (nae + nbe < nbValues) {
                                msgs.add(MessageType.ERROR, String.format("%s : not enough values for interpolation (indices %d to %d)", this, range.min(), range.max()));
                            } else {
                                int j2;
                                int nb = Math.min(Math.max(nb0, nbValues - nae), range.min() - i0);
                                int na = Math.min(nbValues - nb, i1 - range.max());
                                double[] x = new double[nbValues];
                                double[] y = new double[nbValues];
                                k = 0;
                                for (j2 = range.min() - nb; j2 < range.min(); ++j2) {
                                    x[k] = j2;
                                    y[k] = this.fValues[j2];
                                    ++k;
                                }
                                for (j2 = range.max() + 1; j2 <= range.max() + na; ++j2) {
                                    x[k] = j2;
                                    y[k] = this.fValues[j2];
                                    ++k;
                                }
                                PolynomialFunctionLagrangeForm pfl = new PolynomialFunctionLagrangeForm(x, y);
                                for (j2 = range.min(); j2 <= range.max(); ++j2) {
                                    this.fValues[j2] = Math.max(this.fMinValue, pfl.value(j2));
                                }
                            }
                        }
                    } else {
                        msgs.add(MessageType.INFO, String.format("%s : gap too long (indices %d to %d) : values will be ignored", this, range.min(), range.max()));
                        for (j = range.min(); j <= range.max(); ++j) {
                            this.fValues[j] = this.fColumnName.getNoInterpValue();
                        }
                    }
                } else {
                    for (j = range.min(); j <= range.max(); ++j) {
                        this.fValues[j] = this.fColumnName.getNoInterpValue();
                    }
                }
                i0 = range.max() + 1;
            }
        }
        return msgs;
    }

    public String getHtmlLabel() {
        return Messages.getHtmlString(this.fColumnName.getLabel() + ".htmlLongName");
    }

    public String toString() {
        return this.getHtmlLabel().replaceAll("<[^>]*>", "").replaceAll("</[^>]*>", "");
    }

    public void setMaxInterpolableGapSize(Integer pSize) {
        this.fInterpolableGapSizeProperty.setValue((Number)pSize);
    }

    public Integer getInterpolableGapSize() {
        return this.fInterpolableGapSizeProperty.get();
    }

    public String detail() {
        return this.fDetail;
    }

    public boolean isActive() {
        return this.fActiveProperty.get();
    }

    public void setActive(boolean pActive) {
        this.fActiveProperty.set(pActive);
    }

    public BooleanProperty activeProperty() {
        return this.fActiveProperty;
    }

    public BooleanProperty fillGapsWith0Property() {
        return this.fFillGapsWith0Property;
    }

    public int getOrder() {
        return this.fOrder;
    }

    public void setOrder(int pOrder) {
        this.fOrder = pOrder;
    }

    public double[] getValues() {
        return this.fValues;
    }

    public ColumnName getColumnName() {
        return this.fColumnName;
    }
}

