/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.modele.Parameter;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrentParameterValueSet {
    private final Map<Parameter, double[]> fParamValueMap;
    private final AtomicInteger fCurrent;
    private int fSize;

    public ConcurrentParameterValueSet(Map<Parameter, double[]> pParamValueMap) {
        this.fParamValueMap = pParamValueMap;
        this.fCurrent = new AtomicInteger(0);
        this.reset();
    }

    public void reset() {
        this.fCurrent.set(0);
        this.fSize = this.fParamValueMap.values().iterator().next().length;
    }

    public boolean hasNext() {
        return this.fCurrent.get() < this.fSize - 1;
    }

    public int next() {
        int res = this.fCurrent.getAndIncrement();
        if (res > this.fSize - 1) {
            return -1;
        }
        return res;
    }

    public int size() {
        return this.fSize;
    }

    public Map<Parameter, double[]> getParamValueMap() {
        return this.fParamValueMap;
    }
}

