/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.utils.csv.Column;
import fr.geonosis.karstmod.utils.csv.parser.DoubleType;
import fr.geonosis.karstmod.utils.csv.parser.IColumnType;
import fr.geonosis.karstmod.utils.csv.parser.StringType;
import fr.geonosis.karstmod.utils.csv.parser.UtcDateTimeType;
import java.util.Set;

public enum ColumnName {
    DATE("DATE", new UtcDateTimeType("yyyyMMdd HH:mm", "yyyyMMdd"), true, false, false),
    P("Rainfall", DoubleType.getInstance(), true, true, true),
    QOBSS("QOBSS", DoubleType.getInstance(), true, false, false),
    COMMENT("COMMENT", StringType.getInstance(), false, false, false),
    ET("Evapotranspiration", DoubleType.getInstance(), false, true, true),
    QPUMPL("QpumpL", DoubleType.getInstance(), false, true, true),
    QPUMPM("QpumpM", DoubleType.getInstance(), false, true, true),
    QPUMPC("QpumpC", DoubleType.getInstance(), false, true, true),
    QPUMPS("QpumpS", DoubleType.getInstance(), false, true, true),
    ZOBSE("Piezometer E", DoubleType.getInstance(), false, false, false),
    ZOBSL("Piezometer L", DoubleType.getInstance(), false, false, false),
    ZOBSM("Piezometer M", DoubleType.getInstance(), false, false, false),
    ZOBSC("Piezometer C", DoubleType.getInstance(), false, false, false),
    QLOSS("Qloss", DoubleType.getInstance(), false, false, false),
    T("Temperature", DoubleType.getInstance(), false, true, false),
    QSINKL("QsinkL", DoubleType.getInstance(), false, true, true),
    QSINKM("QsinkM", DoubleType.getInstance(), false, true, true),
    QSINKC("QsinkC", DoubleType.getInstance(), false, true, true),
    QSINKS("QsinkS", DoubleType.getInstance(), false, true, true),
    SRAD("Srad", DoubleType.getInstance(), false, true, true);

    private final Column fColumn;
    private final String fLabel;
    private final boolean fRequired;
    private final boolean fInterpRequired;
    private final boolean fZeroValue;

    private <T> ColumnName(String pLabel, IColumnType<T> pType, boolean pRequired, boolean pInterpRequired, boolean pZeroValue) {
        this.fLabel = pLabel;
        this.fColumn = new Column<T>(this.name(), pType, pType instanceof DoubleType ? Set.of("INTERP", "NOINTERP") : Set.of());
        this.fRequired = pRequired;
        this.fInterpRequired = pInterpRequired;
        this.fZeroValue = pZeroValue;
    }

    public Column getColumn() {
        return this.fColumn;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public boolean isRequired() {
        return this.fRequired;
    }

    public boolean isInterpRequired() {
        return this.fInterpRequired;
    }

    public double getNoInterpValue() {
        return this.fZeroValue ? 0.0 : Double.NaN;
    }

    public boolean isZeroValue() {
        return this.fZeroValue;
    }
}

