/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs.ssi;

import fr.dbe.util.ihm.JTable2ExcelAdapter;
import fr.dbe.util.ihm.TableColumnAdjuster;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.ihm.Styles;
import fr.geonosis.karstmod.ihm.graphs.ssi.JTableauSSIModel;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.SensitivityIndexes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;

public class JTableauSSI
extends JPanel {
    private final JLabel fTitre = new JLabel(Messages.getString("JTableauSSI.title"));
    private final JTable fTable = new JTable();
    private final TableColumnAdjuster fAdjuster;

    public JTableauSSI() {
        super(new GridBagLayout());
        JScrollPane sp = new JScrollPane(this.fTable);
        sp.getVerticalScrollBar().setUnitIncrement(16);
        sp.getViewport().setPreferredSize(new Dimension(0, 0));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.anchor = 23;
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.ipadx = 0;
        constraints.ipady = 10;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.fTitre, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.anchor = 23;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.ipadx = 0;
        constraints.ipady = 10;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)sp, constraints);
        this.fTitre.setFont(Styles.FONT_DEFAUT);
        this.fTable.setFont(Styles.FONT_DEFAUT);
        this.fTable.setAutoResizeMode(0);
        this.fTable.setRowHeight(20);
        final Color couleur = new Color(240, 240, 240);
        this.fTable.getTableHeader().setOpaque(false);
        this.fTable.getTableHeader().setBackground(Color.BLACK);
        this.fTable.getTableHeader().setForeground(Color.WHITE);
        this.fTable.setModel(new JTableauSSIModel());
        this.fTable.setDefaultRenderer(Double.TYPE, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(final JTable pTable, Object pValue, boolean pIsSelected, boolean pHasFocus, final int pRow, final int pColumn) {
                String value = this.format((Double)pValue);
                Component label = super.getTableCellRendererComponent(pTable, value, pIsSelected, pHasFocus, pRow, pColumn);
                JPanel p = new JPanel(new GridLayout(1, 1)){

                    @Override
                    public void paint(Graphics g) {
                        double rank;
                        switch (pColumn) {
                            case 1: {
                                rank = ((JTableauSSIModel)pTable.getModel()).getIndex(pTable.convertRowIndexToModel(pRow)).getFirstOrderRank();
                                break;
                            }
                            case 2: {
                                rank = ((JTableauSSIModel)pTable.getModel()).getIndex(pTable.convertRowIndexToModel(pRow)).getTotalEffectRank();
                                break;
                            }
                            default: {
                                rank = 0.0;
                            }
                        }
                        int w = (int)(rank * (double)this.getWidth());
                        g.setColor(this.getBackground());
                        g.fillRect(0, 0, this.getWidth() - w, this.getHeight());
                        g.setColor(Styles.COULEUR_FOND_RESERVOIR);
                        g.fillRect(this.getWidth() - w, 0, w, this.getHeight());
                        super.paint(g);
                    }
                };
                p.setOpaque(false);
                ((JLabel)label).setOpaque(false);
                p.setBackground(pRow % 2 == 0 ? Color.WHITE : couleur);
                if (value.startsWith("-")) {
                    label.setForeground(Color.red);
                } else {
                    label.setForeground(Color.BLACK);
                }
                p.add(label, "North");
                return p;
            }

            private String format(double pValue) {
                String pattern = Math.abs(pValue) > 0.001 || pValue == 0.0 ? "#.###" : "0.###E0";
                DecimalFormat format = new DecimalFormat(pattern);
                DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                dfs.setNaN("NaN");
                format.setDecimalFormatSymbols(dfs);
                return format.format(pValue);
            }
        });
        this.fTable.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable pTable, Object pValue, boolean pIsSelected, boolean pHasFocus, int pRow, int pColumn) {
                Component c = super.getTableCellRendererComponent(pTable, pValue, pIsSelected, pHasFocus, pRow, pColumn);
                JTableauSSIModel model = (JTableauSSIModel)pTable.getModel();
                this.setForeground(model.getParameter(pRow).getColor());
                if (pIsSelected) {
                    this.setBackground(Styles.COULEUR_FOND_SELECTION_SSI);
                } else {
                    this.setBackground(pRow % 2 == 0 ? Color.WHITE : couleur);
                }
                return c;
            }
        });
        this.fAdjuster = new TableColumnAdjuster(this.fTable, 5);
        JTable2ExcelAdapter t2ea = new JTable2ExcelAdapter(this.fTable);
        t2ea.enableCopy();
        this.fTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent pE) {
                if (pE.getClickCount() == 2) {
                    int i;
                    int px = pE.getPoint().x;
                    int x = 0;
                    for (i = 0; i < JTableauSSI.this.fTable.getColumnCount(); ++i) {
                        if (Math.abs(px - x) <= 3) {
                            if (pE.isShiftDown()) {
                                JTableauSSI.this.fAdjuster.adjustColumns();
                            } else {
                                JTableauSSI.this.fAdjuster.adjustColumn(i - 1);
                            }
                            return;
                        }
                        x += JTableauSSI.this.fTable.getColumnModel().getColumn(i).getWidth();
                    }
                    if (Math.abs(px - x) <= 3) {
                        if (pE.isShiftDown()) {
                            JTableauSSI.this.fAdjuster.adjustColumns();
                        } else {
                            JTableauSSI.this.fAdjuster.adjustColumn(i - 1);
                        }
                    }
                }
            }
        });
        JTableauSSIModel model = (JTableauSSIModel)this.fTable.getModel();
        TableRowSorter<JTableauSSIModel> sorter = new TableRowSorter<JTableauSSIModel>(model);
        this.fTable.setRowSorter(sorter);
        Comparator comparator = Comparator.naturalOrder();
        sorter.setComparator(1, comparator);
        sorter.setComparator(2, comparator);
        this.fAdjuster.adjustColumns();
    }

    public void setTitre(String pTitre) {
        this.fTitre.setText(pTitre);
    }

    public void setValues(Map<Parameter, SensitivityIndexes> pValues) {
        JTableauSSIModel model = (JTableauSSIModel)this.fTable.getModel();
        model.setIndexes(pValues);
        TableRowSorter sorter = (TableRowSorter)this.fTable.getRowSorter();
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        int columnIndexToSort = 2;
        sortKeys.add(new RowSorter.SortKey(columnIndexToSort, SortOrder.DESCENDING));
        sorter.setSortKeys(sortKeys);
        sorter.sort();
        this.fAdjuster.adjustColumns();
    }
}

