/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.util.ihm.JTable2ExcelAdapter;
import fr.dbe.util.ihm.TableColumnAdjuster;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.Utils;
import fr.geonosis.karstmod.ihm.Styles;
import fr.geonosis.karstmod.modele.obj.BE;
import fr.geonosis.karstmod.modele.obj.GlobalObjectiveFunction;
import fr.geonosis.karstmod.modele.obj.KGE;
import fr.geonosis.karstmod.modele.obj.KGENP;
import fr.geonosis.karstmod.modele.obj.NSE;
import fr.geonosis.karstmod.modele.obj.ObjectiveFunctionDescriptor;
import fr.geonosis.karstmod.modele.obj.RPearson;
import fr.geonosis.karstmod.modele.obj.RSpearman;
import fr.geonosis.karstmod.modele.obj.VE;
import fr.geonosis.karstmod.modele.obj.WobjRunResults;
import fr.geonosis.karstmod.modele.obj.parser.Part;
import fr.geonosis.karstmod.run.RunMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class JTableauWObj
extends JPanel {
    private static final Border COLUMN_BORDER = BorderFactory.createEmptyBorder(0, 2, 0, 2);
    private final JLabel fTitre = new JLabel(Messages.getString("JTableauWObj.1"));
    private final JTable fTable = new JTable();
    private final TableColumnAdjuster fAdjuster;
    private int fNbFct;

    public JTableauWObj() {
        super(new GridBagLayout());
        JScrollPane sp = new JScrollPane(this.fTable);
        sp.getVerticalScrollBar().setUnitIncrement(16);
        sp.getViewport().setPreferredSize(new Dimension(0, 0));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.anchor = 23;
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.ipadx = 0;
        constraints.ipady = 10;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.fTitre, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.anchor = 23;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.ipadx = 0;
        constraints.ipady = 10;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)sp, constraints);
        this.fTitre.setFont(Styles.FONT_DEFAUT);
        this.fTable.setFont(Styles.FONT_DEFAUT);
        this.fTable.setAutoResizeMode(0);
        this.fTable.setRowHeight(20);
        JTableHeader th = new JTableHeader();
        th.setDefaultRenderer((table, value, isSelected, hasFocus, row, column) -> {
            JLabel c = new JLabel();
            ((Component)c).setBackground(Color.WHITE);
            return c;
        });
        this.fTable.setTableHeader(th);
        this.fTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable pTable, Object pValue, boolean pIsSelected, boolean pHasFocus, int pRow, int pColumn) {
                Component c = super.getTableCellRendererComponent(pTable, pValue, pIsSelected, pHasFocus, pRow, pColumn);
                try {
                    if (pRow == 0) {
                        c.setFont(Styles.FONT_BOLD);
                        c.setBackground(Styles.WOBJ_TAB_BACKGROUND);
                    } else if (pRow == 1) {
                        c.setFont(Styles.FONT_BOLD);
                        c.setBackground(Color.WHITE);
                    } else {
                        c.setBackground(Color.WHITE);
                    }
                    if (pIsSelected && pRow > 0) {
                        this.setBackground(Styles.WOBJ_TAB_BACKGROUND_SELECTED);
                    }
                    if (pColumn >= 1) {
                        ((JLabel)c).setHorizontalAlignment(4);
                    } else {
                        ((JLabel)c).setHorizontalAlignment(2);
                    }
                    if (pRow >= JTableauWObj.this.fNbFct + 2) {
                        c.setFont(Styles.FONT_ITALIC);
                        c.setForeground(Styles.WOBJ_TAB_TEXT_COLOR_OTHER);
                    } else {
                        c.setForeground(Color.BLACK);
                    }
                    ((JComponent)c).setBorder(COLUMN_BORDER);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return c;
            }
        });
        this.fAdjuster = new TableColumnAdjuster(this.fTable, 5);
        this.fAdjuster.setOnlyAdjustLarger(false);
        JTable2ExcelAdapter t2ea = new JTable2ExcelAdapter(this.fTable);
        t2ea.enableCopy();
        this.fTable.setModel(new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int pRow, int pColumn) {
                return false;
            }
        });
        this.fTable.setColumnModel(new DefaultTableColumnModel(){

            @Override
            public TableColumn getColumn(int pColumnIndex) {
                try {
                    return super.getColumn(pColumnIndex);
                }
                catch (Exception ex) {
                    throw new RuntimeException();
                }
            }
        });
        this.fTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent pE) {
                if (pE.getClickCount() == 2) {
                    int i;
                    int px = pE.getPoint().x;
                    int x = 0;
                    for (i = 0; i < JTableauWObj.this.fTable.getColumnCount(); ++i) {
                        if (Math.abs(px - x) <= 3) {
                            if (pE.isShiftDown()) {
                                JTableauWObj.this.fAdjuster.adjustColumns();
                            } else {
                                JTableauWObj.this.fAdjuster.adjustColumn(i - 1);
                            }
                            return;
                        }
                        x += JTableauWObj.this.fTable.getColumnModel().getColumn(i).getWidth();
                    }
                    if (Math.abs(px - x) <= 3) {
                        if (pE.isShiftDown()) {
                            JTableauWObj.this.fAdjuster.adjustColumns();
                        } else {
                            JTableauWObj.this.fAdjuster.adjustColumn(i - 1);
                        }
                    }
                }
            }
        });
    }

    public void setResults(WobjRunResults pResults, RunMonitor pRunMonitor) {
        this.fNbFct = pResults.getGlobalObjectiveFunction().getActivePartNumber();
        double coefSum = pResults.getGlobalObjectiveFunction().getCoefSum();
        this.setVisible(this.fNbFct > 0);
        List<Class<VE>> classList = List.of(BE.class, KGE.class, KGENP.class, NSE.class, RPearson.class, RSpearman.class, VE.class);
        ArrayList<ObjectiveFunctionDescriptor> descs = new ArrayList<ObjectiveFunctionDescriptor>();
        for (ObjectiveFunctionDescriptor desc : pRunMonitor.getWobj().getDescriptors()) {
            if (desc.getWeight() == 0.0) continue;
            boolean exists = false;
            for (ObjectiveFunctionDescriptor desc2 : descs) {
                if (desc2.getVarname() != desc.getVarname() || desc2.getConverter() != desc.getConverter() || !desc2.getRange().equals(desc.getRange())) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            descs.add(desc);
        }
        this.fTitre.setText(Utils.addHtmlTag(Messages.getString("WOBJ.name") + " = " + pResults.getGlobalFctLabel()));
        Object[] titles = new String[]{"", Messages.getString("JTableauWObj.2"), Messages.getString("JTableauWObj.3")};
        Object[][] values = new String[2 + this.fNbFct + classList.size() * descs.size()][3];
        int lig = 0;
        values[lig][0] = "Function";
        values[lig][1] = Messages.getString("JWobjs.4");
        values[lig][2] = Messages.getString("JWobjs.5");
        values[++lig][0] = Messages.getString("WOBJ.name");
        values[lig][1] = this.format(pResults.getWobjCalibrationBest().getRes());
        values[lig][2] = this.format(pResults.getWobjValidationForCalibrationBest().getRes());
        ++lig;
        for (int i = 0; i < this.fNbFct; ++i) {
            values[lig][0] = "  " + pResults.functionLabel(i);
            values[lig][1] = this.format(pResults.getWobjCalibrationBest().getObjs()[i] / pResults.getWeight(i) * coefSum);
            values[lig][2] = this.format(pResults.getWobjValidationForCalibrationBest().getObjs()[i] / pResults.getWeight(i) * coefSum);
            ++lig;
        }
        for (Class<VE> c : classList) {
            for (ObjectiveFunctionDescriptor desc : descs) {
                GlobalObjectiveFunction wObj = new GlobalObjectiveFunction();
                Part part = new Part(1.0, c, desc.getConverter(), desc.getVarname(), desc.getRange(), desc.getParameters());
                wObj.addPart(new ObjectiveFunctionDescriptor(part));
                WobjRunResults results = pRunMonitor.doRun(wObj);
                values[lig][0] = "  " + wObj.getDescriptors().get(0).toStringWithoutWeight();
                values[lig][1] = this.format(results.getWobjCalibrationBest().getRes());
                values[lig][2] = this.format(results.getWobjValidationForCalibrationBest().getRes());
                ++lig;
            }
        }
        ((DefaultTableModel)this.fTable.getModel()).setDataVector(values, titles);
        SwingUtilities.invokeLater(this.fAdjuster::adjustColumns);
    }

    private String format(double pValue) {
        if (Math.abs(pValue) >= 0.01 || pValue == 0.0) {
            return new DecimalFormat("0.00").format(pValue);
        }
        return new DecimalFormat("0.##E0").format(pValue);
    }
}

