/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.graphique.Busyable;
import fr.dbe.graphique.CourbeRadar;
import fr.dbe.graphique.GraphiqueRadar;
import fr.dbe.graphique.Marges;
import fr.dbe.graphique.NuageDePoint;
import fr.dbe.graphique.PointGraphique;
import fr.dbe.graphique.Repere;
import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.Utils;
import fr.geonosis.karstmod.KarstModException;
import fr.geonosis.karstmod.compute.DiagnosticEfficiency;
import fr.geonosis.karstmod.ihm.Styles;
import fr.geonosis.karstmod.ihm.graphs.KgeChart;
import fr.geonosis.karstmod.ihm.graphs.de.DEChart;
import fr.geonosis.karstmod.ihm.graphs.de.KGEChart;
import fr.geonosis.karstmod.modele.RunParameters;
import fr.geonosis.karstmod.modele.StageBounds;
import fr.geonosis.karstmod.modele.obj.AbstractObjectiveFunction;
import fr.geonosis.karstmod.modele.obj.GlobalObjectiveFunction;
import fr.geonosis.karstmod.modele.obj.KGE;
import fr.geonosis.karstmod.modele.obj.KGENP;
import fr.geonosis.karstmod.modele.obj.ObjectiveFunctionDescriptor;
import fr.geonosis.karstmod.modele.obj.WobjDataConverter;
import fr.geonosis.karstmod.modele.obj.WobjResult;
import fr.geonosis.karstmod.modele.obj.WobjVar;
import fr.geonosis.karstmod.modele.obj.parser.Varname;
import fr.geonosis.karstmod.run.RunMonitor;
import fr.geonosis.karstmod.run.model.RunResult;
import fr.geonosis.karstmod.viewfx.ResultsPaneController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.beans.property.ReadOnlyListProperty;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class JPanelModelEvaluation
extends JPanel
implements Busyable {
    private final Box fBox = Box.createVerticalBox();
    private final JLabel fWarning;

    public JPanelModelEvaluation() {
        super(new BorderLayout());
        ImageIcon warningImg = new ImageIcon(Objects.requireNonNull(ResultsPaneController.class.getResource("resources/orange-error-24.png")));
        this.fWarning = new JLabel("The criteria are calculated based on the entire chronicle and do not take into account the thresholds and variable transformations entered for the calculation of WOBJ.", new ImageIcon(warningImg.getImage().getScaledInstance(16, 16, 4)), 2);
        this.fWarning.setFont(Styles.FONT_DEFAUT);
        this.setReady();
    }

    public void clear() {
        this.fBox.removeAll();
        this.updateUI();
    }

    public void update(RunMonitor pRunMonitor, RunParameters pRunParameters, int pIOShift) {
        this.clear();
        pRunMonitor.getBestRunModel().resetRoutines();
        RunResult result = pRunMonitor.getBestRunModel().run(pRunMonitor.getGlobalStage().getDebut(), pRunMonitor.getGlobalStage().getFin());
        for (Varname varname : pRunParameters.getWobjFunction().getUsedVarnames()) {
            GlobalObjectiveFunction gof = new GlobalObjectiveFunction();
            String[] objLabels = new String[varname.getAllowedFunc().length];
            int p = 0;
            for (Class<? extends AbstractObjectiveFunction> fctClass : varname.getAllowedFunc()) {
                ObjectiveFunctionDescriptor desc = new ObjectiveFunctionDescriptor(1.0, fctClass, varname, WobjDataConverter.IDENTITY, null, null);
                gof.addPart(desc);
                objLabels[p++] = desc.getFunctionName();
            }
            JPanel hBox = new JPanel(new GridBagLayout());
            this.fBox.getInsets().set(0, 0, 0, 0);
            this.fBox.add(hBox);
            String strCalibration = "Calibration";
            String strValidation = "Validation";
            Map<String, Color> mapCouleur = Map.of(strCalibration, Color.BLACK, strValidation, Color.RED);
            HashMap<String, CourbeRadar> courbes = new HashMap<String, CourbeRadar>();
            courbes.put(strCalibration, new CourbeRadar(strCalibration, Color.BLUE));
            courbes.put(strValidation, new CourbeRadar(strValidation, Color.RED));
            for (Map.Entry entry : courbes.entrySet()) {
                ((CourbeRadar)entry.getValue()).setCouleur(mapCouleur.get(entry.getKey()));
            }
            HashMap<String, NuageDePoint> courbesKgeAlphaR = new HashMap<String, NuageDePoint>();
            courbesKgeAlphaR.put(strCalibration, new NuageDePoint("KGE - Alpha vs Correlation " + strCalibration));
            courbesKgeAlphaR.put(strValidation, new NuageDePoint("KGE - Alpha vs Correlation " + strValidation));
            HashMap<String, NuageDePoint> courbesKgeAlphaBeta = new HashMap<String, NuageDePoint>();
            courbesKgeAlphaBeta.put(strCalibration, new NuageDePoint("KGE - Alpha vs Beta " + strCalibration));
            courbesKgeAlphaBeta.put(strValidation, new NuageDePoint("KGE - Alpha vs Beta " + strValidation));
            HashMap<String, NuageDePoint> courbesKgeBetaR = new HashMap<String, NuageDePoint>();
            courbesKgeBetaR.put(strCalibration, new NuageDePoint("KGE - Beta vs Correlation " + strCalibration));
            courbesKgeBetaR.put(strValidation, new NuageDePoint("KGE - Beta vs Correlation " + strValidation));
            HashMap<String, NuageDePoint> courbesKgenpAlphaR = new HashMap<String, NuageDePoint>();
            courbesKgenpAlphaR.put(strCalibration, new NuageDePoint("KGENP - Alpha vs Correlation " + strCalibration));
            courbesKgenpAlphaR.put(strValidation, new NuageDePoint("KGENP - Alpha vs Correlation " + strValidation));
            HashMap<String, NuageDePoint> courbesKgenpAlphaBeta = new HashMap<String, NuageDePoint>();
            courbesKgenpAlphaBeta.put(strCalibration, new NuageDePoint("KGENP - Alpha vs Beta " + strCalibration));
            courbesKgenpAlphaBeta.put(strValidation, new NuageDePoint("KGENP - Alpha vs Beta " + strValidation));
            HashMap<String, NuageDePoint> courbesKgenpBetaR = new HashMap<String, NuageDePoint>();
            courbesKgenpBetaR.put(strCalibration, new NuageDePoint("KGENP - Beta vs Correlation " + strCalibration));
            courbesKgenpBetaR.put(strValidation, new NuageDePoint("KGENP - Beta vs Correlation " + strValidation));
            for (Map map : List.of(courbesKgeAlphaR, courbesKgeAlphaBeta, courbesKgeBetaR, courbesKgenpAlphaR, courbesKgenpAlphaBeta, courbesKgenpBetaR)) {
                for (Map.Entry entry : map.entrySet()) {
                    ((NuageDePoint)entry.getValue()).setCouleur(mapCouleur.get(entry.getKey()));
                }
            }
            HashMap<String, KGE> kges = new HashMap<String, KGE>();
            for (Map.Entry<String, ReadOnlyListProperty<StageBounds>> entry : Map.of(strCalibration, pRunParameters.getCalibrationStages(), strValidation, pRunParameters.getValidationStages()).entrySet()) {
                gof.init(pRunParameters.getInputData(), (List)entry.getValue(), 1, -2.147483648E9, pIOShift);
                WobjResult objRes = gof.compute(result);
                for (int i = 0; i < gof.getActivePartNumber(); ++i) {
                    Color couleur;
                    double beta;
                    double alpha;
                    double r;
                    ((CourbeRadar)courbes.get(entry.getKey())).ajoute(objRes.getObjs()[i] * (double)gof.getActivePartNumber());
                    if (KGE.class.equals(gof.getDescriptors().get(i).getFunctionClass())) {
                        KGE kge = (KGE)gof.getFunction(i);
                        kges.put(entry.getKey(), kge);
                        r = kge.getR();
                        alpha = kge.getAlpha();
                        beta = kge.getBeta();
                        couleur = mapCouleur.get(entry.getKey());
                        ((NuageDePoint)courbesKgeAlphaR.get(entry.getKey())).ajouterPoint(new Carre(alpha, r, couleur));
                        ((NuageDePoint)courbesKgeAlphaBeta.get(entry.getKey())).ajouterPoint(new Carre(alpha, beta, couleur));
                        ((NuageDePoint)courbesKgeBetaR.get(entry.getKey())).ajouterPoint(new Carre(beta, r, couleur));
                        continue;
                    }
                    if (!KGENP.class.equals(gof.getDescriptors().get(i).getFunctionClass())) continue;
                    KGENP kgenp = (KGENP)gof.getFunction(i);
                    r = kgenp.getR();
                    alpha = kgenp.getAlpha();
                    beta = kgenp.getBeta();
                    couleur = mapCouleur.get(entry.getKey());
                    ((NuageDePoint)courbesKgenpAlphaR.get(entry.getKey())).ajouterPoint(new Triangle(alpha, r, couleur));
                    ((NuageDePoint)courbesKgenpAlphaBeta.get(entry.getKey())).ajouterPoint(new Triangle(alpha, beta, couleur));
                    ((NuageDePoint)courbesKgenpBetaR.get(entry.getKey())).ajouterPoint(new Triangle(beta, r, couleur));
                }
            }
            ReadOnlyListProperty<StageBounds> readOnlyListProperty = pRunParameters.getCalibrationStages();
            WobjVar obsVar = new WobjVar(varname, pRunParameters.getInputData().getValues(varname.getColumnName()), null, WobjDataConverter.IDENTITY, (List<StageBounds>)readOnlyListProperty);
            WobjVar simVar = new WobjVar(varname, result.getValues(varname), null, WobjDataConverter.IDENTITY, (List<StageBounds>)readOnlyListProperty);
            DiagnosticEfficiency deCalib = this.de(obsVar, simVar, pRunMonitor.getConfig().getDEQuantile(varname));
            ReadOnlyListProperty<StageBounds> readOnlyListProperty2 = pRunParameters.getValidationStages();
            obsVar = new WobjVar(varname, pRunParameters.getInputData().getValues(varname.getColumnName()), null, WobjDataConverter.IDENTITY, (List<StageBounds>)readOnlyListProperty2);
            simVar = new WobjVar(varname, result.getValues(varname), null, WobjDataConverter.IDENTITY, (List<StageBounds>)readOnlyListProperty2);
            DiagnosticEfficiency deValid = this.de(obsVar, simVar, pRunMonitor.getConfig().getDEQuantile(varname));
            DEChart deChart = new DEChart("Diagnostic efficiency (" + varname.getHtmlLabel() + ")", deCalib, deValid);
            deChart.getDessin().setMarges(new Marges(0.0, 1.0, 0.0, 0.0));
            KGEChart kgeChart = new KGEChart("KGE decomposition (" + varname.getHtmlLabel() + ")", (KGE)kges.get(strCalibration), (KGE)kges.get(strValidation));
            kgeChart.getDessin().setMarges(new Marges(0.0, 1.0, 0.0, 0.0));
            GraphiqueRadar radar = new GraphiqueRadar("Performance criteria (" + varname.getHtmlLabel() + ")", objLabels, 0.4487989505128276, 0.0, 1.0, 0.2, 0.2);
            radar.getDessin().setMarges(new Marges(0.0, 1.0, 0.0, 0.0));
            radar.getDessin().getTitre().setFont(Utilitaire.FONT_PLAIN_10);
            radar.getDessin().getLegende().setFont(Utilitaire.FONT_PLAIN_9);
            radar.getDessin().getLegende().setCadre(false);
            radar.getDessin().getLegende().setTransparence(0.8f);
            radar.getDessin().getLegende().setPosY(6);
            radar.getDessin().getLegende().setDxGauche(-14);
            String strAlpha = "Alpha (relative variability)";
            String strBeta = "Beta (bias)";
            String strR = "Correlation";
            String htmlFormat = "<html>%s (%s)</html>";
            KgeChart chartKgeAlphaR = new KgeChart("Alpha vs Correlation (" + varname.getHtmlLabel() + ")", 0.5, 1.5, 0.0, 1.0, strAlpha, String.format(htmlFormat, strR, varname.getHtmlLabel()));
            chartKgeAlphaR.ajouterSeries(0, new ArrayList(courbesKgeAlphaR.values()));
            chartKgeAlphaR.ajouterSeries(0, new ArrayList(courbesKgenpAlphaR.values()));
            Font f = chartKgeAlphaR.getRepere(0).getAxeV().getActualFont();
            f = new Font(f.getFamily(), f.getStyle(), 12);
            chartKgeAlphaR.getRepere(0).getAxeV().setPolice(f);
            chartKgeAlphaR.getRepere(0).getAxeH().setPolice(f);
            chartKgeAlphaR.ajuster();
            KgeChart chartKgeAlphaBeta = new KgeChart("Alpha vs Beta (" + varname.getHtmlLabel() + ")", 0.5, 1.5, 0.5, 1.5, strAlpha, String.format(htmlFormat, strBeta, varname.getHtmlLabel()));
            chartKgeAlphaBeta.ajouterSeries(0, new ArrayList(courbesKgeAlphaBeta.values()));
            chartKgeAlphaBeta.ajouterSeries(0, new ArrayList(courbesKgenpAlphaBeta.values()));
            chartKgeAlphaBeta.getRepere(0).getAxeV().setPolice(f);
            chartKgeAlphaBeta.getRepere(0).getAxeH().setPolice(f);
            chartKgeAlphaBeta.ajuster();
            KgeChart chartKgeBetaR = new KgeChart("Beta vs Correlation (" + varname.getHtmlLabel() + ")", 0.5, 1.5, 0.0, 1.0, strBeta, String.format(htmlFormat, strR, varname.getHtmlLabel()));
            chartKgeBetaR.ajouterSeries(0, new ArrayList(courbesKgeBetaR.values()));
            chartKgeBetaR.ajouterSeries(0, new ArrayList(courbesKgenpBetaR.values()));
            chartKgeBetaR.getRepere(0).getAxeV().setPolice(f);
            chartKgeBetaR.getRepere(0).getAxeH().setPolice(f);
            chartKgeBetaR.ajuster();
            JPanel kgePane = new JPanel(new GridLayout(2, 2));
            kgePane.add(chartKgeAlphaR);
            kgePane.add(chartKgeAlphaBeta);
            kgePane.add(chartKgeBetaR);
            JLabel btQuantile = this.createBtQuantile(pRunMonitor, varname, deChart, deCalib, deValid);
            hBox.getInsets().set(0, 0, 0, 0);
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridy = 1;
            gc.gridwidth = 1;
            gc.gridx = 1;
            gc.weighty = 0.0;
            gc.gridheight = 1;
            gc.weightx = 1.0;
            gc.fill = 1;
            gc.anchor = 10;
            gc.insets = new Insets(0, 0, 0, 0);
            gc.ipady = 0;
            gc.ipadx = 0;
            hBox.add((Component)Utils.createHorizontalBox(0, true, this.createLabel("Diagnostic efficiency", varname), btQuantile), gc);
            gc.gridx = 2;
            hBox.add((Component)this.createLabel("Performance criteria", varname), gc);
            gc.gridx = 3;
            hBox.add((Component)this.createLabel("KGE decomposition", varname), gc);
            gc.gridx = 4;
            hBox.add((Component)this.createLabel("KGE decomposition", varname), gc);
            hBox.add((Component)kgeChart, gc);
            gc.gridy = 2;
            gc.gridx = 1;
            gc.weighty = 1.0;
            gc.gridheight = 1;
            hBox.add((Component)deChart, gc);
            gc.gridx = 2;
            hBox.add((Component)radar, gc);
            gc.gridx = 3;
            hBox.add((Component)kgePane, gc);
            gc.gridx = 4;
            hBox.add((Component)kgeChart, gc);
            radar.setSeries((CourbeRadar[])courbes.values().toArray(CourbeRadar[]::new));
            this.updateUI();
        }
    }

    private JLabel createBtQuantile(final RunMonitor pRunMonitor, final Varname varname, final Component deChart, final DiagnosticEfficiency deCalib, final DiagnosticEfficiency deValid) {
        final JLabel btQuantile = Utils.createLabel(" ... ");
        btQuantile.setToolTipText("Set High flow quantile...");
        btQuantile.setBorder(BorderFactory.createTitledBorder(""));
        btQuantile.setBackground(Color.LIGHT_GRAY);
        btQuantile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                btQuantile.setOpaque(true);
                btQuantile.setBackground(Color.GRAY);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                btQuantile.setOpaque(false);
                btQuantile.setBackground(Color.LIGHT_GRAY);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                String res = JOptionPane.showInputDialog(deChart, "High flow quantile", deCalib.getQuantile());
                if (res != null) {
                    try {
                        double q = Double.parseDouble(res.replace(',', '.'));
                        if (q <= 0.0 || q > 1.0) {
                            throw new KarstModException();
                        }
                        pRunMonitor.getConfig().setDEQuantile(varname, q);
                        deCalib.setQuantile(q);
                        deValid.setQuantile(q);
                        deChart.repaint();
                    }
                    catch (KarstModException ex) {
                        JOptionPane.showMessageDialog(deChart, "Wrong quantile value", "Value must be geater than 0 and lesser or equal to 1.", 0);
                        this.mouseClicked(e);
                    }
                }
            }
        });
        return btQuantile;
    }

    private JLabel createLabel(String pText, Varname pVarname) {
        JLabel label = Utils.createLabel("<html>" + pText + " (" + pVarname.getHtmlLabel() + ")</html>");
        label.setFont(Utilitaire.FONT_BOLD_11);
        label.setHorizontalAlignment(0);
        return label;
    }

    private DiagnosticEfficiency de(WobjVar pObsVar, WobjVar pSimVar, double pQuantile) {
        double[] obs = new double[pObsVar.getIndices().length];
        double[] sim = new double[pObsVar.getIndices().length];
        int k = 0;
        int[] nArray = pObsVar.getIndices();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = nArray[i];
            obs[k] = pObsVar.get(i2);
            sim[k] = pSimVar.get(i2);
            ++k;
        }
        return Math.min((double)pObsVar.getIndices().length * pQuantile, (double)pObsVar.getIndices().length * (1.0 - pQuantile)) > 1.0 ? new DiagnosticEfficiency(obs, sim, pQuantile) : null;
    }

    @Override
    public void setBusy(String pMessage) {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        this.add((Component)Utils.createLabel(pMessage), constraints);
        this.updateUI();
    }

    @Override
    public void setReady() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.fWarning, "North");
        this.add((Component)new JScrollPane(this.fBox), "Center");
        this.updateUI();
    }

    private static class Triangle
    extends PointGraphique {
        private int fDiametre;

        public Triangle(double pX, double pY, Color pColor) {
            super(pX, pY);
            this.setCouleur(pColor);
            this.fDiametre = 8;
        }

        @Override
        public void dessine(Graphics g, Repere pRepere) {
            double xPix = pRepere.getAxeH().valToPix(this.getX());
            double yPix = pRepere.getAxeV().valToPix(this.getY());
            if (Double.isFinite(xPix) && Double.isFinite(yPix)) {
                g.setColor(this.getCouleur());
                int r = this.fDiametre / 2;
                Polygon p = new Polygon();
                p.addPoint((int)xPix, (int)(yPix - (double)r));
                p.addPoint((int)(xPix + (double)r), (int)(yPix + (double)r));
                p.addPoint((int)(xPix - (double)r), (int)(yPix + (double)r));
                g.fillPolygon(p);
            }
        }

        @Override
        public void dessineLegende(Graphics2D pGraphics2d, int pX, int pY, int pWidth, int pHeight) {
            pGraphics2d.setColor(this.getCouleur());
            Polygon p = new Polygon();
            p.addPoint(pX + pHeight / 2, pY);
            p.addPoint(pX + pHeight, pY + pHeight);
            p.addPoint(pX, pY + pHeight);
            pGraphics2d.fillPolygon(p);
        }

        @Override
        public int getDiametre() {
            return this.fDiametre;
        }

        @Override
        public void setDiametre(int pDiametre) {
            this.fDiametre = pDiametre;
        }

        @Override
        public boolean equals(Object pO) {
            if (pO == null || this.getClass() != pO.getClass()) {
                return false;
            }
            if (!super.equals(pO)) {
                return false;
            }
            Triangle triangle = (Triangle)pO;
            return this.fDiametre == triangle.fDiametre;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fDiametre);
        }
    }

    private static class Carre
    extends PointGraphique {
        private int fDiametre;

        public Carre(double pX, double pY, Color pColor) {
            super(pX, pY);
            this.setCouleur(pColor);
            this.fDiametre = 8;
        }

        @Override
        public void dessine(Graphics g, Repere pRepere) {
            double xPix = pRepere.getAxeH().valToPix(this.getX());
            double yPix = pRepere.getAxeV().valToPix(this.getY());
            if (Double.isFinite(xPix) && Double.isFinite(yPix)) {
                g.setColor(this.getCouleur());
                int r = this.fDiametre / 2;
                g.fillRect((int)(xPix - (double)r), (int)(yPix - (double)r), this.fDiametre, this.fDiametre);
            }
        }

        @Override
        public void dessineLegende(Graphics2D pGraphics2d, int pX, int pY, int pWidth, int pHeight) {
            pGraphics2d.setColor(this.getCouleur());
            pGraphics2d.fillRect(pX, pY, pWidth, pHeight);
        }

        @Override
        public int getDiametre() {
            return this.fDiametre;
        }

        @Override
        public void setDiametre(int pDiametre) {
            this.fDiametre = pDiametre;
        }

        @Override
        public boolean equals(Object pO) {
            if (pO == null || this.getClass() != pO.getClass()) {
                return false;
            }
            if (!super.equals(pO)) {
                return false;
            }
            Carre carre = (Carre)pO;
            return this.fDiametre == carre.fDiametre;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fDiametre);
        }
    }
}

