/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.graphique.Courbe;
import fr.dbe.graphique.JPanneauGraphique;
import fr.dbe.graphique.LabelWidget;
import fr.dbe.graphique.Log10Function;
import fr.dbe.graphique.Marges;
import fr.dbe.graphique.NuageDePoint;
import fr.dbe.graphique.PointCourbe;
import fr.dbe.util.commun.Plage;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.Utils;
import fr.geonosis.karstmod.compute.SortedDischarge;
import fr.geonosis.karstmod.compute.SortedDischargeFormatter;
import fr.geonosis.karstmod.ihm.Styles;
import fr.geonosis.karstmod.ihm.graphs.FondPlage;
import fr.geonosis.karstmod.run.QNorm;
import java.awt.Color;
import java.util.Arrays;
import javax.swing.BorderFactory;

public class JGraphiqueDebitsClasses
extends JPanneauGraphique {
    private static final double[] XTICKS;
    private final NuageDePoint fSerieObs;
    private final NuageDePoint fSerieSim;
    private final FondPlage fFondPlage;
    private final Courbe fCourbeQobs;
    private final Courbe fCourbeQsim;
    private LabelWidget fLabelWidget;

    public JGraphiqueDebitsClasses(Courbe pCourbeQobs, Courbe pCourbeQsim, FondPlage pFondPlage, String pControlLabel) {
        super("", pControlLabel, false);
        this.fFondPlage = pFondPlage;
        this.fCourbeQobs = pCourbeQobs;
        this.fCourbeQsim = pCourbeQsim;
        this.fSerieObs = new NuageDePoint(Messages.getString("observe.firstUpper"));
        this.fSerieObs.setCouleur(Styles.COULEURS_COURBE_QOBS);
        this.fSerieObs.setCursorable(false);
        this.fSerieSim = new NuageDePoint(Messages.getString("simule.firstUpper"));
        this.fSerieSim.setCouleur(Styles.COULEURS_COURBE_QSIM);
        this.fSerieSim.setCursorable(false);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setControleEnabled(true);
        this.getDessin().setAfficheNomCourbe(true);
        this.getDessin().setMarges(new Marges(10.0, 15.0, 3.0, 3.0));
        this.getDessin().setTitle("");
        this.getDessin().getTitre().setVisible(true);
        this.getDessin().getTitre().setTransparence(0.0f);
        this.getRepere(0).getAxeV().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.getRepere(0).getAxeH().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.getRepere(0).getAxeV().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION);
        this.getRepere(0).getAxeH().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION);
        this.setScaleFunctions(0, new Log10Function(), null);
        this.ajouterSerie(0, this.fSerieObs);
        this.ajouterSerie(0, this.fSerieSim);
        this.getRepere(0).getQuadrillageH().linkToGraduation();
        this.setEtiquette(0, Utils.addHtmlTag(Messages.getString("discharge.varName")), "probability (%)");
        this.setUnits(0, Utils.addHtmlTag(Messages.getString("BaseUnite.9")), null);
    }

    public void maj() {
        this.fSerieObs.clear();
        this.fSerieSim.clear();
        int diametre = 5;
        double[] qObs = this.fCourbeQobs.getValues().toArray();
        if (qObs.length > 0) {
            int nb = 0;
            double[] discharges = new double[qObs.length];
            for (Plage p : this.fFondPlage.getPlages()) {
                for (int i = p.getIndiceMin(); i <= p.getIndiceMax(); ++i) {
                    discharges[nb++] = qObs[i];
                }
            }
            if (nb == 0) {
                return;
            }
            SortedDischarge sdObs = new SortedDischarge(Arrays.copyOf(discharges, nb));
            if (sdObs.isValuesMissing()) {
                if (this.fLabelWidget == null) {
                    this.fLabelWidget = new LabelWidget(this.getDessin(), Messages.getString("missingQobsValues"), 0, 0);
                    this.fLabelWidget.setFont(Styles.FONT_GRAPH_LABEL);
                    this.fLabelWidget.setCouleurTexte(Color.GRAY);
                    this.fLabelWidget.setVisible(true);
                    this.fLabelWidget.setVerticalAnchor(1);
                    this.fLabelWidget.setHorizontalAnchor(1);
                    this.getDessin().addWidget(this.fLabelWidget);
                }
            } else {
                if (this.fLabelWidget != null) {
                    this.getDessin().removeWidget(this.fLabelWidget);
                }
                this.fLabelWidget = null;
            }
            for (int i = 0; i < sdObs.size(); ++i) {
                this.fSerieObs.ajouterPoint(new PointCourbe(sdObs.discharge(i), sdObs.value(i), diametre, this.fSerieObs.getCouleur()));
            }
            double[] qSim = this.fCourbeQsim.getValues().toArray();
            if (qSim.length > 0) {
                nb = 0;
                discharges = new double[qSim.length];
                for (Plage p : this.fFondPlage.getPlages()) {
                    for (int i = p.getIndiceMin(); i <= p.getIndiceMax(); ++i) {
                        discharges[nb++] = qSim[i];
                    }
                }
                if (nb == 0) {
                    return;
                }
                SortedDischarge sdSimObs = new SortedDischarge(Arrays.copyOf(discharges, nb));
                for (int i = 0; i < sdSimObs.size(); ++i) {
                    this.fSerieSim.ajouterPoint(new PointCourbe(sdSimObs.discharge(i), sdSimObs.value(i), diametre, this.fSerieSim.getCouleur()));
                }
            }
        }
        this.ajuster();
        double max = XTICKS[XTICKS.length - 1];
        double valMax = this.getRepere(0).getAxeV().getMax();
        for (int i = XTICKS.length - 2; i >= 0; --i) {
            if (!(XTICKS[i] < valMax)) continue;
            max = XTICKS[i + 1];
            break;
        }
        this.ajusterY(0, 0.0, max);
        this.getRepere(0).getAxeV().getGraduation().setPositions(XTICKS);
        this.getRepere(0).getAxeV().getGraduation().setFormatter(new SortedDischargeFormatter());
    }

    public void clear() {
        this.fSerieObs.clear();
        this.fSerieSim.clear();
    }

    static {
        double[] xticks = new double[]{0.1, 0.3, 0.5, 0.7, 0.8, 0.9, 0.95, 0.98, 0.99, 0.995, 0.998, 0.9999};
        for (int i = 0; i < xticks.length; ++i) {
            xticks[i] = (1.0 + xticks[i]) / 2.0;
        }
        XTICKS = QNorm.compute(xticks);
    }
}

