/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.graphique.Courbe;
import fr.dbe.graphique.Histogramme;
import fr.dbe.graphique.PositionAxeH;
import fr.dbe.graphique.PositionBarreHistogramme;
import fr.dbe.graphique.Serie;
import fr.dbe.util.commun.Plage;
import fr.dbe.util.commun.Vecteur;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.ihm.graphs.FondPlage;
import fr.geonosis.karstmod.ihm.graphs.JGraphPeriod;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.Unit;
import java.awt.Color;

public class JGraphiqueBilanMasse
extends JGraphPeriod {
    private final Courbe fCourbeBilanMasse;
    private final Courbe fCourbeBilanMasseErreur;
    private final Courbe fCourbePOrPsr;
    private final Courbe fCourbeETEff;
    private final Courbe fCourbeQloss;
    private final Courbe fCourbeQrEloss;
    private final Courbe fCourbeQrLloss;
    private final Courbe fCourbeQrMloss;
    private final Courbe fCourbeQrCloss;
    private final Courbe fCourbeQS;
    private final Courbe fCourbeQpumpL;
    private final Courbe fCourbeQpumpM;
    private final Courbe fCourbeQpumpC;
    private final Courbe fCourbeQpumpS;
    private final Courbe fCourbeQsinkL;
    private final Courbe fCourbeQsinkM;
    private final Courbe fCourbeQsinkC;
    private final Courbe fCourbeQsinkS;
    private final Courbe fCourbeHauteurE;
    private final Courbe fCourbeHauteurL;
    private final Courbe fCourbeHauteurM;
    private final Courbe fCourbeHauteurC;
    private double fRa;
    private int fIOShift;

    public JGraphiqueBilanMasse(Courbe pCourbePOrPsr, Courbe pCourbeETEff, Courbe pCourbeQloss, Courbe pCourbeQrEloss, Courbe pCourbeQrLloss, Courbe pCourbeQrMloss, Courbe pCourbeQrCloss, Courbe pCourbeQS, Courbe pCourbeQpumpL, Courbe pCourbeQpumpM, Courbe pCourbeQpumpC, Courbe pCourbeQpumpS, Courbe pCourbeQsinkL, Courbe pCourbeQsinkM, Courbe pCourbeQsinkC, Courbe pCourbeQsinkS, FondPlage pCalibration, FondPlage pValidation, Courbe pCourbeHauteurE, Courbe pCourbeHauteurL, Courbe pCourbeHauteurM, Courbe pCourbeHauteurC) {
        super(Messages.getString("JGraphiqueBilanMasse.0"), Messages.getString("JResults.34"), null, pCalibration, pValidation);
        this.getDessin().getRepere(0).setPosAxeH(PositionAxeH.ORIGINE);
        this.fCourbePOrPsr = pCourbePOrPsr;
        this.fCourbeETEff = pCourbeETEff;
        this.fCourbeQloss = pCourbeQloss;
        this.fCourbeQrEloss = pCourbeQrEloss;
        this.fCourbeQrLloss = pCourbeQrLloss;
        this.fCourbeQrMloss = pCourbeQrMloss;
        this.fCourbeQrCloss = pCourbeQrCloss;
        this.fCourbeQS = pCourbeQS;
        this.fCourbeQpumpL = pCourbeQpumpL;
        this.fCourbeQpumpM = pCourbeQpumpM;
        this.fCourbeQpumpC = pCourbeQpumpC;
        this.fCourbeQpumpS = pCourbeQpumpS;
        this.fCourbeQsinkL = pCourbeQsinkL;
        this.fCourbeQsinkM = pCourbeQsinkM;
        this.fCourbeQsinkC = pCourbeQsinkC;
        this.fCourbeQsinkS = pCourbeQsinkS;
        this.fCourbeHauteurE = pCourbeHauteurE;
        this.fCourbeHauteurL = pCourbeHauteurL;
        this.fCourbeHauteurM = pCourbeHauteurM;
        this.fCourbeHauteurC = pCourbeHauteurC;
        this.fCourbeBilanMasse = new Courbe(Messages.getString("JGraphiqueBilanMasse.0"), 0.0, 1.0);
        this.fCourbeBilanMasseErreur = new Courbe(Messages.getString("JGraphiqueBilanMasse.3"), 0.0, 1.0);
        final Color minusColor = new Color(255, 0, 0);
        final Color plusColor = new Color(50, 200, 100);
        final Color minusFillColor = new Color(minusColor.getRed(), minusColor.getGreen(), minusColor.getBlue(), 50);
        final Color plusFillColor = new Color(plusColor.getRed(), plusColor.getGreen(), plusColor.getBlue(), 50);
        this.fCourbeBilanMasse.setTypeDessin(new Histogramme(PositionBarreHistogramme.DROITE){

            @Override
            protected Color getColor(Serie pCourbe, double pY) {
                return pY < 0.0 ? minusColor : plusColor;
            }

            @Override
            protected Color getFillColor(double pY) {
                return pY < 0.0 ? minusFillColor : plusFillColor;
            }
        });
        this.ajouterSerie(0, this.fCourbeBilanMasse);
        this.ajouterSerie(0, this.fCourbeBilanMasseErreur);
        this.fCourbeBilanMasseErreur.setVisible(false);
        this.getDessin().setTitle(this.fCourbeBilanMasse.getNom());
        this.setEtiquette(0, Messages.getString("JGraphiqueBilanMasse.2"), this.getEtiquetteVGauche());
        Unit.getInstance().baseProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            this.setEtiquette(0, Messages.getString("JGraphiqueBilanMasse.2"), this.getEtiquetteVGauche());
            this.maj(this.fRa, this.fIOShift);
            this.repaint();
        });
    }

    @Override
    protected String getEtiquetteVGauche() {
        return Messages.getString("JGraphiqueBilanMasse.1").replaceAll("@@unit", Unit.getInstance().getBase().get(Dimension.TIME));
    }

    @Override
    protected String getUnitVGauche() {
        return null;
    }

    public void maj(double pRa, int pIOShift) {
        Vecteur qSinkS;
        Vecteur qSinkC;
        Vecteur qSinkM;
        Vecteur qSinkL;
        Vecteur qPumpS;
        Vecteur qPumpC;
        Vecteur qPumpM;
        Vecteur qPumpL;
        Vecteur qrCloss;
        Vecteur qrMloss;
        Vecteur qrLloss;
        Vecteur qrEloss;
        this.fCourbeBilanMasse.clearDirect();
        this.fCourbeBilanMasseErreur.clearDirect();
        this.fRa = pRa;
        this.fIOShift = pIOShift;
        double coef = (double)Unit.getInstance().getBase().getSecondes() / (this.fRa * 1000.0);
        Vecteur qS = this.fCourbeQS.getValues();
        Vecteur zeroArray = new Vecteur(new double[qS.size()]);
        Vecteur p = this.fCourbePOrPsr.getValues();
        Vecteur etEff = this.fCourbeETEff.getValues();
        Vecteur qLoss = this.fCourbeQloss.getValues();
        if (qLoss.size() == 0) {
            qLoss = zeroArray;
        }
        if ((qrEloss = this.fCourbeQrEloss.getValues()).size() == 0) {
            qrEloss = zeroArray;
        }
        if ((qrLloss = this.fCourbeQrLloss.getValues()).size() == 0) {
            qrLloss = zeroArray;
        }
        if ((qrMloss = this.fCourbeQrMloss.getValues()).size() == 0) {
            qrMloss = zeroArray;
        }
        if ((qrCloss = this.fCourbeQrCloss.getValues()).size() == 0) {
            qrCloss = zeroArray;
        }
        if ((qPumpL = this.fCourbeQpumpL.getValues()).size() == 0) {
            qPumpL = zeroArray;
        }
        if ((qPumpM = this.fCourbeQpumpM.getValues()).size() == 0) {
            qPumpM = zeroArray;
        }
        if ((qPumpC = this.fCourbeQpumpC.getValues()).size() == 0) {
            qPumpC = zeroArray;
        }
        if ((qPumpS = this.fCourbeQpumpS.getValues()).size() == 0) {
            qPumpS = zeroArray;
        }
        if ((qSinkL = this.fCourbeQsinkL.getValues()).size() == 0) {
            qSinkL = zeroArray;
        }
        if ((qSinkM = this.fCourbeQsinkM.getValues()).size() == 0) {
            qSinkM = zeroArray;
        }
        if ((qSinkC = this.fCourbeQsinkC.getValues()).size() == 0) {
            qSinkC = zeroArray;
        }
        if ((qSinkS = this.fCourbeQsinkS.getValues()).size() == 0) {
            qSinkS = zeroArray;
        }
        Vecteur E = this.fCourbeHauteurE.getValues();
        Vecteur L = this.fCourbeHauteurL.getValues();
        Vecteur M = this.fCourbeHauteurM.getValues();
        Vecteur C = this.fCourbeHauteurC.getValues();
        int debut = Math.min(this.getFondPlageCalibration().getMin(), this.getFondPlageValidation().getMin());
        int fin = Math.max(this.getFondPlageCalibration().getMax(), this.getFondPlageValidation().getMax());
        this.fCourbeBilanMasse.setXMin(debut);
        this.fCourbeBilanMasseErreur.setXMin(debut);
        double[] bm = new double[fin - debut + 1];
        double[] bmErr = new double[fin - debut + 1];
        for (FondPlage fondPlage : new FondPlage[]{this.getFondPlageCalibration(), this.getFondPlageValidation()}) {
            if (qS.size() < fondPlage.getMax() + 1) continue;
            for (Plage pl : fondPlage.getPlages()) {
                for (int i = pl.getIndiceMin(); i <= pl.getIndiceMax(); ++i) {
                    if (Double.isNaN(qS.get(i + this.fIOShift))) continue;
                    bm[i - debut] = p.get(i) - etEff.get(i) - coef * (qLoss.get(i) + qrEloss.get(i) + qrLloss.get(i) + qrMloss.get(i) + qrCloss.get(i) + qS.get(i + this.fIOShift) + qPumpL.get(i) - qSinkL.get(i) + qPumpM.get(i) - qSinkM.get(i) + qPumpC.get(i) - qSinkC.get(i) + qPumpS.get(i) - qSinkS.get(i));
                    bmErr[i - debut] = bm[i - debut] + E.get(i) - E.get(i + 1) + L.get(i) - L.get(i + 1) + M.get(i) - M.get(i + 1) + C.get(i) - C.get(i + 1);
                }
            }
        }
        this.fCourbeBilanMasse.setValuesDirect(bm);
        this.fCourbeBilanMasseErreur.setValuesDirect(bmErr);
        this.ajuster();
    }

    public void clear() {
        this.fCourbeBilanMasse.clearDirect();
    }
}

