/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.Fond;
import fr.dbe.graphique.Graduation;
import fr.dbe.graphique.JDessinGraphique;
import fr.dbe.graphique.JPanneauGraphique;
import fr.dbe.graphique.Marges;
import fr.dbe.graphique.formatter.IFormatter;
import fr.dbe.graphique.formatter.LabelFormatter;
import fr.dbe.util.commun.IElementListener;
import fr.dbe.util.commun.Vecteur;
import fr.dbe.util.ihm.Utils;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.ihm.Styles;
import fr.geonosis.karstmod.ihm.graphs.FondPlage;
import fr.geonosis.karstmod.modele.BaseUnit;
import fr.geonosis.karstmod.modele.ElementAdapterDesactivable;
import fr.geonosis.karstmod.modele.ElementAdapterNonDesactivable;
import fr.geonosis.karstmod.modele.Unit;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public abstract class JGraphPeriod
extends JPanneauGraphique {
    public static final String DEBIT_M_S = Messages.getString("JGraphiquePluiesDebits.0");
    public static final String M3_S = Messages.getString("m3s");
    public static final String PLUIE_ET = Messages.getString("pluie.displayName") + ", " + Messages.getString("evapotranspiration.displayName");
    public static final String TEMPS = Messages.getString("JGraphiquePluiesDebits.2");
    public static final String HAUTEUR = Messages.getString("JGraphiquePluiesHauteurs.1");
    private final FondPlage fFondPlageChauffe;
    private final FondPlage fFondPlageValidation;
    private final FondPlage fFondPlageCalibration;
    private JCheckBoxMenuItem fCbHour;
    private JCheckBoxMenuItem fCbDay;
    private JCheckBoxMenuItem fCbWeek;
    private JCheckBoxMenuItem fCbMonth;
    private JCheckBoxMenuItem fCbYear;
    private double fMaxIntervalleGraduations;
    private JButton btFitCalibration;
    private JButton btFitValidation;
    private JButton btFitWarmup;

    public JGraphPeriod(String pNom, String pLibInfo, FondPlage pChauffe, FondPlage pCalibration, FondPlage pValidation) {
        super(pNom, pLibInfo, false);
        this.fFondPlageChauffe = pChauffe;
        this.fFondPlageCalibration = pCalibration;
        this.fFondPlageValidation = pValidation;
        if (this.fFondPlageChauffe == null) {
            this.btFitWarmup.setVisible(false);
        }
        if (this.fFondPlageCalibration == null) {
            this.btFitCalibration.setVisible(false);
        }
        if (this.fFondPlageValidation == null) {
            this.btFitValidation.setVisible(false);
        }
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setControleEnabled(true);
        this.getDessin().setAfficheNomCourbe(true);
        this.getDessin().setMarges(new Marges(10.0, 3.0, 3.0, 3.0));
        this.getRepere(0).getAxeH().getGraduation().setIntervalle(1.0);
        this.getDessin().setTauxAjustementV(80);
        this.getDessin().getTitre().setVisible(false);
        this.getDessin().getTitre().setTransparence(0.0f);
        this.getRepere(0).getAxeV().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.getRepere(0).getAxeH().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.getRepere(0).getAxeV().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION);
        this.getRepere(0).getAxeH().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION);
        this.getRepere(0).getAxeH().getGraduation().setOrientation(0.5235987755982988);
        this.getRepere(0).getQuadrillageH().linkToGraduation();
        this.getRepere(0).getQuadrillageV().linkToGraduation();
        if (pChauffe != null) {
            this.getRepere(0).ajouteFond(pChauffe);
        }
        this.getRepere(0).ajouteFond(pCalibration);
        this.getRepere(0).ajouteFond(pValidation);
        this.fMaxIntervalleGraduations = -1.0;
        ElementAdapterNonDesactivable listener = new ElementAdapterNonDesactivable(){

            @Override
            public void valeurModifiee(Object pValue) {
                if (JGraphPeriod.this.fCbDay.isSelected() || JGraphPeriod.this.fCbHour.isSelected()) {
                    JGraphPeriod.this.fMaxIntervalleGraduations = 1.0;
                    JGraphPeriod.this.getRepere(0).getAxeH().getGraduation().setIntervalle(1.0);
                }
            }
        };
        this.getRepere(0).getAxeH().getElementListenerHelper().addElementListener("BORNES", (IElementListener)listener);
        this.getDessin().getElementListenerHelper().addElementListener("zoom", (IElementListener)listener);
        ElementAdapterNonDesactivable adpt = new ElementAdapterNonDesactivable(){

            @Override
            public void valeurModifiee(Object pValue) {
                if (JGraphPeriod.this.fCbDay.isSelected() || JGraphPeriod.this.fCbHour.isSelected()) {
                    double[] indices = ((Graduation)pValue).getLastDrawingPositions();
                    Arrays.sort(indices);
                    double max = JGraphPeriod.this.deltaMax(indices);
                    if (max == 0.0) {
                        return;
                    }
                    if (Unit.getInstance().getBase() == BaseUnit.DAY) {
                        if (max == 1.0) {
                            if (JGraphPeriod.this.fMaxIntervalleGraduations != 1.0) {
                                JGraphPeriod.this.fMaxIntervalleGraduations = 1.0;
                                JGraphPeriod.this.getRepere(0).getAxeH().getGraduation().setIntervalle(1.0);
                                JGraphPeriod.this.getDessin().repaint();
                            }
                        } else if (max <= 7.0) {
                            if (JGraphPeriod.this.fMaxIntervalleGraduations != 5.0) {
                                JGraphPeriod.this.fMaxIntervalleGraduations = 5.0;
                                double[] pos = JGraphPeriod.this.computeDayPos(new String[]{"01", "05", "10", "15", "20", "25"});
                                JGraphPeriod.this.getRepere(0).getAxeH().getGraduation().setPositions(pos);
                                JGraphPeriod.this.getDessin().repaint();
                            }
                        } else if (max <= 12.0) {
                            if (JGraphPeriod.this.fMaxIntervalleGraduations != 10.0) {
                                JGraphPeriod.this.fMaxIntervalleGraduations = 10.0;
                                double[] pos = JGraphPeriod.this.computeDayPos(new String[]{"01", "10", "20"});
                                JGraphPeriod.this.getRepere(0).getAxeH().getGraduation().setPositions(pos);
                                JGraphPeriod.this.getDessin().repaint();
                            }
                        } else if (max <= 17.0) {
                            if (JGraphPeriod.this.fMaxIntervalleGraduations != 15.0) {
                                JGraphPeriod.this.fMaxIntervalleGraduations = 15.0;
                                double[] pos = JGraphPeriod.this.computeDayPos(new String[]{"01", "15"});
                                JGraphPeriod.this.getRepere(0).getAxeH().getGraduation().setPositions(pos);
                                JGraphPeriod.this.getDessin().repaint();
                            }
                        } else if (JGraphPeriod.this.fMaxIntervalleGraduations != 30.0) {
                            JGraphPeriod.this.fMaxIntervalleGraduations = 30.0;
                            JGraphPeriod.this.getRepere(0).getAxeH().getGraduation().setPositions(JGraphPeriod.this.computePos(2, 1));
                            JGraphPeriod.this.getDessin().repaint();
                        }
                    } else {
                        try {
                            if (max == 1.0) {
                                if (JGraphPeriod.this.fMaxIntervalleGraduations != 1.0) {
                                    JGraphPeriod.this.fMaxIntervalleGraduations = 1.0;
                                    JGraphPeriod.this.getRepere(0).getAxeH().getGraduation().setIntervalle(1.0);
                                    JGraphPeriod.this.getDessin().repaint();
                                }
                            } else if (max <= 6.0) {
                                if (JGraphPeriod.this.fMaxIntervalleGraduations != 6.0) {
                                    JGraphPeriod.this.fMaxIntervalleGraduations = 6.0;
                                    double[] pos = JGraphPeriod.this.computeHourPos(new String[]{"00", "06", "12", "18"});
                                    JGraphPeriod.this.getRepere(0).getAxeH().getGraduation().setPositions(pos);
                                    JGraphPeriod.this.getDessin().repaint();
                                }
                            } else if (max <= 12.0) {
                                if (JGraphPeriod.this.fMaxIntervalleGraduations != 10.0) {
                                    JGraphPeriod.this.fMaxIntervalleGraduations = 10.0;
                                    double[] pos = JGraphPeriod.this.computeHourPos(new String[]{"00", "12"});
                                    JGraphPeriod.this.getRepere(0).getAxeH().getGraduation().setPositions(pos);
                                    JGraphPeriod.this.getDessin().repaint();
                                }
                            } else if (max <= 24.0) {
                                if (JGraphPeriod.this.fMaxIntervalleGraduations != 24.0) {
                                    JGraphPeriod.this.fMaxIntervalleGraduations = 24.0;
                                    double[] pos = JGraphPeriod.this.computeHourPos(new String[]{"00"});
                                    JGraphPeriod.this.getRepere(0).getAxeH().getGraduation().setPositions(pos);
                                    JGraphPeriod.this.getDessin().repaint();
                                }
                            } else if (max <= 168.0) {
                                if (JGraphPeriod.this.fMaxIntervalleGraduations != 120.0) {
                                    JGraphPeriod.this.fMaxIntervalleGraduations = 120.0;
                                    double[] pos = JGraphPeriod.this.computeDayPos(new String[]{"01", "05", "10", "15", "20", "25"});
                                    JGraphPeriod.this.getRepere(0).getAxeH().getGraduation().setPositions(pos);
                                    JGraphPeriod.this.getDessin().repaint();
                                }
                            } else if (max <= 288.0) {
                                if (JGraphPeriod.this.fMaxIntervalleGraduations != 240.0) {
                                    JGraphPeriod.this.fMaxIntervalleGraduations = 240.0;
                                    double[] pos = JGraphPeriod.this.computeDayPos(new String[]{"01", "10", "20"});
                                    JGraphPeriod.this.getRepere(0).getAxeH().getGraduation().setPositions(pos);
                                    JGraphPeriod.this.getDessin().repaint();
                                }
                            } else if (max <= 408.0) {
                                if (JGraphPeriod.this.fMaxIntervalleGraduations != 360.0) {
                                    JGraphPeriod.this.fMaxIntervalleGraduations = 360.0;
                                    double[] pos = JGraphPeriod.this.computeDayPos(new String[]{"01", "15"});
                                    JGraphPeriod.this.getRepere(0).getAxeH().getGraduation().setPositions(pos);
                                    JGraphPeriod.this.getDessin().repaint();
                                }
                            } else if (JGraphPeriod.this.fMaxIntervalleGraduations != 720.0) {
                                JGraphPeriod.this.fMaxIntervalleGraduations = 720.0;
                                JGraphPeriod.this.getRepere(0).getAxeH().getGraduation().setPositions(JGraphPeriod.this.computePos(2, 1));
                                JGraphPeriod.this.getDessin().repaint();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        this.getRepere(0).getAxeH().getGraduation().getElementListenerHelper().addElementListener("formatter", (IElementListener)adpt);
        this.getRepere(0).getAxeH().getGraduation().getElementListenerHelper().addElementListener("drawn", (IElementListener)adpt);
    }

    private double deltaMax(double[] pIndices) {
        double max = 0.0;
        for (int i = 1; i < pIndices.length; ++i) {
            double delta = pIndices[i] - pIndices[i - 1];
            if (!(delta > max)) continue;
            max = delta;
        }
        return max;
    }

    protected abstract String getEtiquetteVGauche();

    protected abstract String getUnitVGauche();

    @Override
    protected JComponent[] getTools() {
        ArrayList<JButton> controls = new ArrayList<JButton>();
        this.btFitWarmup = new JButton();
        this.btFitWarmup.setIcon(Utils.chargeIcone("fitWarmup.png", this.getClass()));
        this.btFitWarmup.setMargin(new Insets(1, 1, 1, 1));
        this.btFitWarmup.setToolTipText(Messages.getString("JGraph.1"));
        this.btFitWarmup.addActionListener(e -> this.fitWarmup());
        controls.add(this.btFitWarmup);
        this.btFitCalibration = new JButton();
        this.btFitCalibration.setIcon(Utils.chargeIcone("fitCalibration.png", this.getClass()));
        this.btFitCalibration.setMargin(new Insets(1, 1, 1, 1));
        this.btFitCalibration.setToolTipText(Messages.getString("JGraph.2"));
        this.btFitCalibration.addActionListener(e -> this.fitCalibration());
        controls.add(this.btFitCalibration);
        this.btFitValidation = new JButton();
        this.btFitValidation.setIcon(Utils.chargeIcone("fitValidation.png", this.getClass()));
        this.btFitValidation.setMargin(new Insets(1, 1, 1, 1));
        this.btFitValidation.setToolTipText(Messages.getString("JGraph.3"));
        this.btFitValidation.addActionListener(e -> this.fitValidation());
        controls.add(this.btFitValidation);
        JButton btAjuster = new JButton();
        btAjuster.setIcon(Utils.chargeIcone("ajusterPeriodes.png", this.getClass()));
        btAjuster.setMargin(new Insets(1, 1, 1, 1));
        btAjuster.setToolTipText(Messages.getString("JGraph.0"));
        btAjuster.addActionListener(e -> this.fitPeriods());
        controls.add(btAjuster);
        JPopupMenu ctxtMenu = new JPopupMenu();
        ctxtMenu.setFont(Styles.FONT_DEFAUT);
        this.fCbHour = new JCheckBoxMenuItem("Hour");
        this.fCbHour.setFont(Styles.FONT_DEFAUT);
        this.fCbDay = new JCheckBoxMenuItem("Day");
        this.fCbDay.setFont(Styles.FONT_DEFAUT);
        this.fCbWeek = new JCheckBoxMenuItem("Week");
        this.fCbWeek.setFont(Styles.FONT_DEFAUT);
        this.fCbMonth = new JCheckBoxMenuItem("Month");
        this.fCbMonth.setFont(Styles.FONT_DEFAUT);
        this.fCbYear = new JCheckBoxMenuItem("Year");
        this.fCbYear.setFont(Styles.FONT_DEFAUT);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.fCbHour);
        bg.add(this.fCbDay);
        bg.add(this.fCbWeek);
        bg.add(this.fCbMonth);
        bg.add(this.fCbYear);
        ctxtMenu.add(this.fCbHour);
        ctxtMenu.add(this.fCbDay);
        ctxtMenu.add(this.fCbWeek);
        ctxtMenu.add(this.fCbMonth);
        ctxtMenu.add(this.fCbYear);
        this.fCbHour.addActionListener(evt -> {
            if (this.fCbHour.isSelected()) {
                this.fMaxIntervalleGraduations = -1.0;
                this.getRepere(0).getAxeH().getGraduation().setIntervalle(1.0);
                this.getDessin().repaint();
            }
        });
        this.fCbDay.addActionListener(evt -> {
            if (this.fCbDay.isSelected()) {
                this.fMaxIntervalleGraduations = -1.0;
                this.getRepere(0).getAxeH().getGraduation().setIntervalle(Unit.getInstance().getBase() == BaseUnit.HOUR ? 24.0 : 1.0);
                this.getDessin().repaint();
            }
        });
        this.fCbWeek.addActionListener(evt -> {
            if (this.fCbWeek.isSelected()) {
                this.fMaxIntervalleGraduations = -1.0;
                this.getRepere(0).getAxeH().getGraduation().setIntervalle(Unit.getInstance().getBase() == BaseUnit.HOUR ? 168.0 : 7.0);
                this.getDessin().repaint();
            }
        });
        this.fCbMonth.addActionListener(evt -> {
            if (this.fCbMonth.isSelected()) {
                this.fMaxIntervalleGraduations = -1.0;
                this.getRepere(0).getAxeH().getGraduation().setPositions(this.computePos(2, 1));
                this.getDessin().repaint();
            }
        });
        this.fCbYear.addActionListener(evt -> {
            if (this.fCbYear.isSelected()) {
                this.fMaxIntervalleGraduations = -1.0;
                this.getRepere(0).getAxeH().getGraduation().setPositions(this.computePos(1, 1));
                this.getDessin().repaint();
            }
        });
        this.fCbHour.setSelected(Unit.getInstance().getBase() == BaseUnit.HOUR);
        this.fCbDay.setSelected(Unit.getInstance().getBase() == BaseUnit.DAY);
        Unit.getInstance().baseProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            if (this.fCbHour.isSelected() && pNewValue == BaseUnit.DAY) {
                this.fCbDay.setSelected(true);
                return;
            }
            for (JCheckBoxMenuItem cb : new JCheckBoxMenuItem[]{this.fCbHour, this.fCbDay, this.fCbWeek, this.fCbMonth, this.fCbYear}) {
                if (!cb.isSelected()) continue;
                cb.getActionListeners()[0].actionPerformed(null);
                break;
            }
        });
        JButton btTimeStepChoice = new JButton();
        btTimeStepChoice.setIcon(Utils.chargeIcone("timeStepChoice.png", this.getClass()));
        btTimeStepChoice.addActionListener(pE -> {
            Point location = new Point(btAjuster.getLocation());
            location.translate(btAjuster.getWidth(), 0);
            ctxtMenu.setLocation(location);
            this.fCbHour.setVisible(Unit.getInstance().getBase() == BaseUnit.HOUR);
            ctxtMenu.show(btTimeStepChoice, btTimeStepChoice.getWidth(), 0);
        });
        controls.add(btTimeStepChoice);
        return controls.toArray(new JComponent[0]);
    }

    private double[] computePos(int pField, int pDelta) {
        Vecteur pos = new Vecteur((int)(this.getRepere(0).getAxeH().getMax() - this.getRepere(0).getAxeH().getMin()) / 365 + 1, 10);
        IFormatter formatter = this.getRepere(0).getAxeH().getGraduation().getFormatter();
        if (formatter instanceof LabelFormatter && ((LabelFormatter)formatter).getLabels().length > 0) {
            String[] labels = ((LabelFormatter)formatter).getLabels();
            switch (pField) {
                case 2: {
                    for (int p = 0; p < labels.length; ++p) {
                        String[] tab = labels[p].split(" ");
                        String date = tab[0];
                        String[] dateFields = date.split("/");
                        if (tab.length == 1) {
                            if (!"01".equals(dateFields[2])) continue;
                            pos.ajouter(p);
                            p += Unit.getInstance().getBase() == BaseUnit.HOUR ? 648 : 27;
                            continue;
                        }
                        String hour = tab[1];
                        String[] hourFields = hour.split(":");
                        if (!"01".equals(dateFields[2]) || !"00".equals(hourFields[0])) continue;
                        pos.ajouter(p);
                        p += Unit.getInstance().getBase() == BaseUnit.HOUR ? 648 : 27;
                    }
                    break;
                }
                case 1: {
                    for (int p = (int)this.getRepere(0).getAxeH().getMin(); p < labels.length; ++p) {
                        String[] tab = labels[p].split(" ");
                        String date = tab[0];
                        String[] dateFields = date.split("/");
                        if (tab.length == 1) {
                            if (!"01".equals(dateFields[1]) || !"01".equals(dateFields[2])) continue;
                            pos.ajouter(p);
                            p += Unit.getInstance().getBase() == BaseUnit.HOUR ? 8736 : 364;
                            continue;
                        }
                        String hour = tab[1];
                        String[] hourFields = hour.split(":");
                        if (!"01".equals(dateFields[1]) || !"01".equals(dateFields[2]) || !"00".equals(hourFields[0])) continue;
                        pos.ajouter(p);
                        p += Unit.getInstance().getBase() == BaseUnit.HOUR ? 648 : 27;
                    }
                    break;
                }
            }
        }
        return pos.toArray();
    }

    private double[] computeDayPos(String[] pDays) {
        Vecteur pos = new Vecteur((int)(this.getRepere(0).getAxeH().getMax() - this.getRepere(0).getAxeH().getMin()) / 365 + 1, 10);
        IFormatter formatter = this.getRepere(0).getAxeH().getGraduation().getFormatter();
        if (formatter instanceof LabelFormatter && ((LabelFormatter)formatter).getLabels().length > 0) {
            String[] labels = ((LabelFormatter)formatter).getLabels();
            for (int p = 0; p < labels.length; ++p) {
                String[] tab = labels[p].split(" ");
                String date = tab[0];
                String[] dateFields = date.split("/");
                String hour = tab.length > 1 ? tab[1].split(":")[0] : "00";
                for (String s : pDays) {
                    if (!s.equals(dateFields[2]) || !"00".equals(hour)) continue;
                    pos.ajouter(p);
                }
            }
        }
        return pos.toArray();
    }

    private double[] computeHourPos(String[] pHours) {
        Vecteur pos = new Vecteur((int)(this.getRepere(0).getAxeH().getMax() - this.getRepere(0).getAxeH().getMin()) / 365 + 1, 10);
        IFormatter formatter = this.getRepere(0).getAxeH().getGraduation().getFormatter();
        if (formatter instanceof LabelFormatter && ((LabelFormatter)formatter).getLabels().length > 0) {
            String[] labels = ((LabelFormatter)formatter).getLabels();
            for (int p = 0; p < labels.length; ++p) {
                String[] tab = labels[p].split(" ");
                String hour = tab[1].split(":")[0];
                for (String s : pHours) {
                    if (!s.equals(hour)) continue;
                    pos.ajouter(p);
                }
            }
        }
        return pos.toArray();
    }

    public void fitWarmup() {
        if (!this.fFondPlageChauffe.getPlages().isEmpty()) {
            this.setBornesX(0, this.fFondPlageChauffe.getMin(), this.fFondPlageChauffe.getMax());
            this.repaint();
        }
    }

    public void fitCalibration() {
        if (!this.fFondPlageCalibration.getPlages().isEmpty()) {
            this.setBornesX(0, this.fFondPlageCalibration.getMin(), this.fFondPlageCalibration.getMax());
            this.repaint();
        }
    }

    public void fitValidation() {
        if (!this.fFondPlageValidation.getPlages().isEmpty()) {
            this.setBornesX(0, this.fFondPlageValidation.getMin(), this.fFondPlageValidation.getMax());
            this.repaint();
        }
    }

    public void fitPeriods() {
        double min = Double.MAX_VALUE;
        double max = -4.9E-324;
        for (Fond fond : this.getRepere(0).getFonds()) {
            if (!(fond instanceof FondPlage) || ((FondPlage)fond).getPlages().isEmpty()) continue;
            min = Math.min((double)((FondPlage)fond).getMin(), min);
            max = Math.max((double)((FondPlage)fond).getMax(), max);
        }
        if (min != Double.MAX_VALUE && max != -4.9E-324) {
            this.setBornesX(0, min, max);
        }
        this.repaint();
    }

    public void linkWith(final JGraphPeriod ... pGraphiquesCibles) {
        this.getDessin().getRepere(0).getAxeH().getElementListenerHelper().addElementListener("BORNES", (IElementListener)new ElementAdapterDesactivable(){

            @Override
            public void valeurModifiee(Object pValue) {
                for (JGraphPeriod p : pGraphiquesCibles) {
                    Axe axe = p.getDessin().getRepere(0).getAxeH();
                    axe.getElementListenerHelper().active(false);
                    p.setBornesX(0, ((Axe)pValue).getMin(), ((Axe)pValue).getMax());
                    axe.getElementListenerHelper().active(true);
                }
            }
        });
        this.getDessin().getRepere(0).getAxeH().getGraduation().getElementListenerHelper().addElementListener("repartition", (IElementListener)new ElementAdapterDesactivable(){

            @Override
            public void valeurModifiee(Object pValue) {
                for (JGraphPeriod p : pGraphiquesCibles) {
                    if (JGraphPeriod.this.fCbHour.isSelected()) {
                        p.fCbHour.setSelected(true);
                        continue;
                    }
                    if (JGraphPeriod.this.fCbDay.isSelected()) {
                        p.fCbDay.setSelected(true);
                        continue;
                    }
                    if (JGraphPeriod.this.fCbWeek.isSelected()) {
                        p.fCbWeek.setSelected(true);
                        continue;
                    }
                    if (JGraphPeriod.this.fCbMonth.isSelected()) {
                        p.fCbMonth.setSelected(true);
                        continue;
                    }
                    if (!JGraphPeriod.this.fCbYear.isSelected()) continue;
                    p.fCbYear.setSelected(true);
                }
            }
        });
        this.getDessin().getElementListenerHelper().addElementListener("centre", (IElementListener)new ElementAdapterDesactivable(){

            @Override
            public void valeurModifiee(Object pValue) {
                for (JGraphPeriod p : pGraphiquesCibles) {
                    JDessinGraphique dessin = p.getDessin();
                    dessin.getElementListenerHelper().active(false);
                    dessin.setZoom(JGraphPeriod.this.getDessin().getZoomX(), dessin.getZoomY());
                    if (dessin.getWidth() == 0) {
                        dessin.centre((Point)pValue, JGraphPeriod.this.getDessin().getWidth());
                    } else {
                        dessin.centre((Point)pValue);
                    }
                    dessin.getElementListenerHelper().active(true);
                }
            }
        });
        this.getDessin().getRepere(0).getAxeH().getGraduation().getElementListenerHelper().addElementListener("repartition", (IElementListener)new ElementAdapterDesactivable(){

            @Override
            public void valeurModifiee(Object pValue) {
                for (JGraphPeriod p : pGraphiquesCibles) {
                    Graduation graduation = p.getDessin().getRepere(0).getAxeH().getGraduation();
                    graduation.getElementListenerHelper().active(false);
                    switch (((Graduation)pValue).getRepartition()) {
                        case INTERVALLE: {
                            graduation.setIntervalle(((Graduation)pValue).getIntervalle());
                            break;
                        }
                        case NOMBRE: {
                            graduation.setNombre(((Graduation)pValue).getNombre());
                            break;
                        }
                        case POSITIONS: {
                            graduation.setPositions(((Graduation)pValue).getPositions());
                        }
                    }
                    graduation.getElementListenerHelper().active(true);
                }
            }
        });
    }

    public FondPlage getFondPlageValidation() {
        return this.fFondPlageValidation;
    }

    public FondPlage getFondPlageCalibration() {
        return this.fFondPlageCalibration;
    }
}

